/*
 * Decompiled with CFR 0.152.
 */
package asjava.unirpc;

import asjava.uniobjects.UniSSLDescriptor;
import asjava.unirpc.UniRPCSSLSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class UniRPCSocket {
    private int referenceCount = 0;
    private Socket socket = null;
    private boolean isSSLSocket = false;

    public UniRPCSocket(String host, int port) throws UnknownHostException, IOException {
        this.socket = new Socket(host, port);
        ++this.referenceCount;
    }

    public UniRPCSocket(InetAddress host, int port, UniSSLDescriptor ussld, boolean sslflag) throws UnknownHostException, IOException {
        if (!sslflag) {
            this.socket = new Socket(host, port);
            ++this.referenceCount;
        } else {
            this.socket = UniRPCSSLSocket.createSSLSocket(host, port, ussld);
            ++this.referenceCount;
            this.isSSLSocket = true;
        }
    }

    public UniRPCSocket(InetAddress address, int port) throws IOException {
        this.socket = this.getSocketFromChannel(address, port);
        ++this.referenceCount;
    }

    public UniRPCSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        this.socket = new Socket(host, port, localAddr, localPort);
        ++this.referenceCount;
    }

    public UniRPCSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        this.socket = new Socket(address, port, localAddr, localPort);
        ++this.referenceCount;
    }

    public void makeSecure(String host, int port, UniSSLDescriptor ussld) throws IOException {
        this.socket = UniRPCSSLSocket.makeSecure(this.socket, host, port, ussld);
        this.isSSLSocket = true;
    }

    public synchronized void close() throws IOException {
        --this.referenceCount;
        if (this.referenceCount < 1) {
            this.socket.setSoLinger(true, 0);
            if (!this.isSSLSocket) {
                this.socket.shutdownOutput();
                this.socket.shutdownInput();
            } else {
                SocketChannel channel = this.socket.getChannel();
                if (channel != null) {
                    channel.configureBlocking(true);
                }
            }
            this.socket.close();
        }
    }

    public int getCount() {
        return this.referenceCount;
    }

    public synchronized UniRPCSocket multiplex() {
        ++this.referenceCount;
        return this;
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public int getSoTimeout() throws SocketException {
        return this.getSoTimeout();
    }

    public void setSoLinger(boolean on, int val) throws SocketException {
        this.socket.setSoLinger(on, val);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.socket.setTcpNoDelay(on);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public boolean isSSLSocket() {
        return this.isSSLSocket;
    }

    public boolean isServerAlive() {
        SocketChannel channel = this.socket.getChannel();
        if (channel == null) {
            return true;
        }
        ByteBuffer buf = ByteBuffer.allocate(1);
        int r = 0;
        try {
            channel.configureBlocking(false);
            r = channel.read(buf);
            channel.configureBlocking(true);
        }
        catch (IOException iOException) {
            return false;
        }
        return r != -1;
    }

    Socket getSocketFromChannel(InetAddress address, int port) throws IOException {
        InetSocketAddress isa = new InetSocketAddress(address, port);
        SocketChannel channel = SocketChannel.open(isa);
        channel.configureBlocking(true);
        return channel.socket();
    }
}

