/*
 * Decompiled with CFR 0.152.
 */
package asjava.unirpc;

import asjava.uniclientlibs.UniString;
import asjava.uniclientlibs.UniTokens;
import asjava.unirpc.UniRPC;
import asjava.unirpc.UniRPCPacketException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class UniRPCPMessage
extends UniRPC {
    private byte[] headerBuffer = new byte[24];
    private byte[] dataInfoBuffer = new byte[16384];
    private byte[] dataBuffer = new byte[32768];
    private byte[] dataBufferEncrypted;
    private byte[] dataBufferCompressed;
    private int dataOffset;
    private int currentArgumentCount;
    private int currentCompressionThreshold;
    private boolean isCompressed;
    private boolean isEncrypted;
    private static final byte UNIRPC_PATT_CHECK = 108;
    private static final int UNIRPC_HEADER_SIZE = 24;
    private static final int UNIRPC_DEFAULT_PACKET_TYPE = 0;
    private static final int UNIRPC_MAX_PACKET_ARGS = 2048;
    private static final int UNIRPC_DEFAULT_DATA_SIZE = 32768;
    private static final int UNIRPC_INT_LENGTH = 1;
    private static final int UNIRPC_DOUBLE_LENGTH = 1;
    private static final byte UNIRPC_UNCOMPRESSED = 0;
    private static final byte UNIRPC_COMPRESSED = 1;

    public UniRPCPMessage() {
        this.resetHeader();
        this.resetData();
        this.currentCompressionThreshold = 0;
    }

    public void dump() {
        String temp;
        int i;
        if (this.debugLevel > 5) {
            this.debugWriter.println("Packet Header Detail:");
            if (this.debugLevel > 7) {
                this.debugWriter.print(" headerBuffer=0x");
                i = 0;
                while (i < this.headerBuffer.length) {
                    temp = Integer.toHexString(this.headerBuffer[i] & 0xFF);
                    if (temp.length() == 1) {
                        this.debugWriter.print("0" + temp);
                    } else {
                        this.debugWriter.print(temp);
                    }
                    if ((i + 1) % 4 == 0) {
                        this.debugWriter.print(" ");
                    }
                    ++i;
                }
                this.debugWriter.println();
            }
            this.debugWriter.println(" Version=" + ((this.headerBuffer[1] & 0xFF) << 0));
            this.debugWriter.println(" Sequence=" + (((this.headerBuffer[2] & 0xFF) << 8) + ((this.headerBuffer[3] & 0xFF) << 0)));
            if (this.isEncrypted && this.isCompressed) {
                this.debugWriter.print(" Encrypted & Compressed Length=");
            } else if (this.isEncrypted) {
                this.debugWriter.print(" Encrypted Length=");
            } else {
                this.debugWriter.print(" Data Length=");
            }
            this.debugWriter.println(((this.headerBuffer[4] & 0xFF) << 24) + ((this.headerBuffer[5] & 0xFF) << 16) + ((this.headerBuffer[6] & 0xFF) << 8) + ((this.headerBuffer[7] & 0xFF) << 0));
            this.debugWriter.println(" Type=" + (((this.headerBuffer[8] & 0xFF) << 24) + ((this.headerBuffer[9] & 0xFF) << 16) + ((this.headerBuffer[10] & 0xFF) << 8) + ((this.headerBuffer[11] & 0xFF) << 0)));
            this.debugWriter.println(" Highest Supported Version=" + ((this.headerBuffer[12] & 0xFF) << 0));
            this.debugWriter.println(" Compression Mask=0x" + Integer.toHexString(this.headerBuffer[13] & 0xFF));
            this.debugWriter.println(" Encryption Mask=0x" + Integer.toHexString(this.headerBuffer[14] & 0xFF));
            this.debugWriter.println(" Return Code=" + (((this.headerBuffer[16] & 0xFF) << 24) + ((this.headerBuffer[17] & 0xFF) << 16) + ((this.headerBuffer[18] & 0xFF) << 8) + ((this.headerBuffer[19] & 0xFF) << 0)));
            this.debugWriter.println(" Argument Count=" + (((this.headerBuffer[20] & 0xFF) << 8) + ((this.headerBuffer[21] & 0xFF) << 0)));
            this.debugWriter.println(" Proc Length=" + (((this.headerBuffer[22] & 0xFF) << 8) + ((this.headerBuffer[23] & 0xFF) << 0)));
        }
        if (this.debugLevel > 3) {
            this.debugWriter.println("Packet Data Detail:");
            if (this.debugLevel > 7) {
                this.debugWriter.print(" dataInfoBuffer=0x");
                i = 0;
                while (i < this.currentArgumentCount * 8) {
                    temp = Integer.toHexString(this.dataInfoBuffer[i] & 0xFF);
                    if (temp.length() == 1) {
                        this.debugWriter.print("0" + temp);
                    } else {
                        this.debugWriter.print(temp);
                    }
                    if ((i + 1) % 4 == 0) {
                        if ((i + 1) % 24 == 0 && i + 1 < this.currentArgumentCount * 8) {
                            this.debugWriter.println();
                            this.debugWriter.print("                0x");
                        } else {
                            this.debugWriter.print(" ");
                        }
                    }
                    ++i;
                }
                this.debugWriter.println();
                this.debugWriter.print(" dataBuffer=0x");
                i = 0;
                while (i < this.dataOffset) {
                    temp = Integer.toHexString(this.dataBuffer[i] & 0xFF);
                    if (temp.length() == 1) {
                        this.debugWriter.print("0" + temp);
                    } else if (temp.length() == 2) {
                        this.debugWriter.print(temp);
                    } else {
                        this.debugWriter.print("(" + temp + ")");
                    }
                    if ((i + 1) % 4 == 0) {
                        if ((i + 1) % 24 == 0) {
                            this.debugWriter.println();
                            this.debugWriter.print("            0x");
                        } else {
                            this.debugWriter.print(" ");
                        }
                    }
                    ++i;
                }
                this.debugWriter.println();
                if (this.debugLevel > 8) {
                    this.debugWriter.print(" dataBufferEncrypted=0x");
                    if (this.dataBufferEncrypted != null) {
                        i = 0;
                        while (i < this.dataBufferEncrypted.length) {
                            temp = Integer.toHexString(this.dataBufferEncrypted[i] & 0xFF);
                            if (temp.length() == 1) {
                                this.debugWriter.print("0" + temp);
                            } else if (temp.length() == 2) {
                                this.debugWriter.print(temp);
                            } else {
                                this.debugWriter.print("(" + temp + ")");
                            }
                            if ((i + 1) % 4 == 0) {
                                if ((i + 1) % 24 == 0) {
                                    this.debugWriter.println();
                                    this.debugWriter.print("                     0x");
                                } else {
                                    this.debugWriter.print(" ");
                                }
                            }
                            ++i;
                        }
                    }
                    this.debugWriter.println();
                    this.debugWriter.print(" dataBufferCompressed=0x");
                    i = 0;
                    while (i < this.dataBufferCompressed.length) {
                        temp = Integer.toHexString(this.dataBufferCompressed[i] & 0xFF);
                        if (temp.length() == 1) {
                            this.debugWriter.print("0" + temp);
                        } else if (temp.length() == 2) {
                            this.debugWriter.print(temp);
                        } else {
                            this.debugWriter.print("(" + temp + ")");
                        }
                        if ((i + 1) % 4 == 0) {
                            if ((i + 1) % 24 == 0) {
                                this.debugWriter.println();
                                this.debugWriter.print("                      0x");
                            } else {
                                this.debugWriter.print(" ");
                            }
                        }
                        ++i;
                    }
                    this.debugWriter.println();
                }
            }
            int i2 = 0;
            while (i2 < this.currentArgumentCount) {
                this.debugWriter.print(" Argument[" + i2 + "]");
                int tmpLength = ((this.dataInfoBuffer[i2 * 8 + 0] & 0xFF) << 24) + ((this.dataInfoBuffer[i2 * 8 + 1] & 0xFF) << 16) + ((this.dataInfoBuffer[i2 * 8 + 2] & 0xFF) << 8) + ((this.dataInfoBuffer[i2 * 8 + 3] & 0xFF) << 0);
                this.debugWriter.print("=Length=" + tmpLength);
                int tmpType = ((this.dataInfoBuffer[i2 * 8 + 4] & 0xFF) << 24) + ((this.dataInfoBuffer[i2 * 8 + 5] & 0xFF) << 16) + ((this.dataInfoBuffer[i2 * 8 + 6] & 0xFF) << 8) + ((this.dataInfoBuffer[i2 * 8 + 7] & 0xFF) << 0);
                this.debugWriter.print("=Type=" + tmpType);
                this.debugWriter.print("=Value=");
                try {
                    switch (tmpType) {
                        case 0: {
                            this.debugWriter.print(this.readInteger(i2));
                            break;
                        }
                        case 1: {
                            this.debugWriter.print(this.readDouble(i2));
                            break;
                        }
                        case 2: {
                            this.debugWriter.print(this.readCharArray(i2));
                            break;
                        }
                        case 4: {
                            int[] intArray = this.readIntegerArray(i2);
                            int j = 0;
                            while (j < intArray.length) {
                                this.debugWriter.print(String.valueOf(intArray[j]) + ",");
                                ++j;
                            }
                            break;
                        }
                        case 5: {
                            double[] doubleArray = this.readDoubleArray(i2);
                            int j = 0;
                            while (j < doubleArray.length) {
                                this.debugWriter.print(String.valueOf(doubleArray[j]) + ",");
                                ++j;
                            }
                            break;
                        }
                        case 3: {
                            this.debugWriter.print(this.readString(i2));
                            break;
                        }
                        default: {
                            this.debugWriter.print("Unrecognized Data Type");
                            break;
                        }
                    }
                }
                catch (UniRPCPacketException e) {
                    this.debugWriter.print("UniRPCMessage.dump():PacketException:" + e.getMessage());
                }
                this.debugWriter.println();
                ++i2;
            }
            this.debugWriter.println();
        }
    }

    public int getArgumentCount() {
        return this.currentArgumentCount;
    }

    public int getCompressionThreshold() {
        return this.currentCompressionThreshold;
    }

    public int getLength(byte anEncryptionType) {
        if (!this.isEncrypted) {
            this.encrypt(anEncryptionType);
            this.isEncrypted = true;
        }
        if (!this.isCompressed) {
            this.compress();
            this.isCompressed = true;
        }
        return 24 + this.dataBufferCompressed.length;
    }

    public int getSize() {
        return 24 + this.currentArgumentCount * 8 + this.dataOffset;
    }

    public char[] readCharArray(int anIndex) throws UniRPCPacketException {
        if (anIndex >= this.currentArgumentCount) {
            throw new UniRPCPacketException("The requested item does NOT exist.", 81004);
        }
        int tmpDataOffset = this.dataItemOffset(anIndex);
        int itemLength = ((this.dataInfoBuffer[anIndex * 8 + 0] & 0xFF) << 24) + ((this.dataInfoBuffer[anIndex * 8 + 1] & 0xFF) << 16) + ((this.dataInfoBuffer[anIndex * 8 + 2] & 0xFF) << 8) + ((this.dataInfoBuffer[anIndex * 8 + 3] & 0xFF) << 0);
        int itemType = ((this.dataInfoBuffer[anIndex * 8 + 4] & 0xFF) << 24) + ((this.dataInfoBuffer[anIndex * 8 + 5] & 0xFF) << 16) + ((this.dataInfoBuffer[anIndex * 8 + 6] & 0xFF) << 8) + ((this.dataInfoBuffer[anIndex * 8 + 7] & 0xFF) << 0);
        if (itemType != 2) {
            throw new UniRPCPacketException("The requested item is NOT a character array.", 81004);
        }
        char[] charArray = new String(this.dataBuffer, tmpDataOffset, itemLength).toCharArray();
        return charArray;
    }

    public byte readCompressionMask() {
        return this.headerBuffer[13];
    }

    public double readDouble(int anIndex) throws UniRPCPacketException {
        if (anIndex >= this.currentArgumentCount) {
            throw new UniRPCPacketException("The requested item does NOT exist.", 81004);
        }
        int tmpDataOffset = this.dataItemOffset(anIndex);
        int itemType = ((this.dataInfoBuffer[anIndex * 8 + 4] & 0xFF) << 24) + ((this.dataInfoBuffer[anIndex * 8 + 5] & 0xFF) << 16) + ((this.dataInfoBuffer[anIndex * 8 + 6] & 0xFF) << 8) + ((this.dataInfoBuffer[anIndex * 8 + 7] & 0xFF) << 0);
        if (itemType != 1) {
            throw new UniRPCPacketException("The requested item is NOT a double.", 81004);
        }
        int highLong = ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 24) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 16) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 8) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 0);
        int lowLong = ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 24) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 16) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 8) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 0);
        return Double.longBitsToDouble(((long)highLong << 32) + ((long)lowLong & 0xFFFFFFFFL));
    }

    public double[] readDoubleArray(int anIndex) throws UniRPCPacketException {
        if (anIndex >= this.currentArgumentCount) {
            throw new UniRPCPacketException("The requested item does NOT exist.", 81004);
        }
        int tmpDataOffset = this.dataItemOffset(anIndex);
        int itemLength = ((this.dataInfoBuffer[anIndex * 8 + 0] & 0xFF) << 24) + ((this.dataInfoBuffer[anIndex * 8 + 1] & 0xFF) << 16) + ((this.dataInfoBuffer[anIndex * 8 + 2] & 0xFF) << 8) + ((this.dataInfoBuffer[anIndex * 8 + 3] & 0xFF) << 0);
        int itemType = ((this.dataInfoBuffer[anIndex * 8 + 4] & 0xFF) << 24) + ((this.dataInfoBuffer[anIndex * 8 + 5] & 0xFF) << 16) + ((this.dataInfoBuffer[anIndex * 8 + 6] & 0xFF) << 8) + ((this.dataInfoBuffer[anIndex * 8 + 7] & 0xFF) << 0);
        double[] doubleArray = new double[itemLength];
        if (itemType == 5) {
            int i = 0;
            while (i < itemLength) {
                int highLong = ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 24) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 16) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 8) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 0);
                int lowLong = ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 24) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 16) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 8) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 0);
                doubleArray[i] = Double.longBitsToDouble(((long)highLong << 32) + ((long)lowLong & 0xFFFFFFFFL));
                ++i;
            }
        } else {
            throw new UniRPCPacketException("The requested item is NOT a double array.", 81004);
        }
        return doubleArray;
    }

    public byte readEncryptionMask() {
        return this.headerBuffer[14];
    }

    public int readHeaderVersion() {
        return (this.headerBuffer[1] & 0xFF) << 0;
    }

    public int readHeaderVersionHighest() {
        return (this.headerBuffer[12] & 0xFF) << 0;
    }

    public int readInteger(int anIndex) throws UniRPCPacketException {
        if (anIndex >= this.currentArgumentCount) {
            throw new UniRPCPacketException("The requested item does NOT exist.", 81004);
        }
        int tmpDataOffset = this.dataItemOffset(anIndex);
        int itemType = ((this.dataInfoBuffer[anIndex * 8 + 4] & 0xFF) << 24) + ((this.dataInfoBuffer[anIndex * 8 + 5] & 0xFF) << 16) + ((this.dataInfoBuffer[anIndex * 8 + 6] & 0xFF) << 8) + ((this.dataInfoBuffer[anIndex * 8 + 7] & 0xFF) << 0);
        if (itemType != 0) {
            throw new UniRPCPacketException("The requested item is NOT an integer.", 81004);
        }
        int itemValue = ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 24) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 16) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 8) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 0);
        return itemValue;
    }

    public int[] readIntegerArray(int anIndex) throws UniRPCPacketException {
        if (anIndex >= this.currentArgumentCount) {
            throw new UniRPCPacketException("The requested item does NOT exist.", 81004);
        }
        int tmpDataOffset = this.dataItemOffset(anIndex);
        int itemLength = ((this.dataInfoBuffer[anIndex * 8 + 0] & 0xFF) << 24) + ((this.dataInfoBuffer[anIndex * 8 + 1] & 0xFF) << 16) + ((this.dataInfoBuffer[anIndex * 8 + 2] & 0xFF) << 8) + ((this.dataInfoBuffer[anIndex * 8 + 3] & 0xFF) << 0);
        int itemType = ((this.dataInfoBuffer[anIndex * 8 + 4] & 0xFF) << 24) + ((this.dataInfoBuffer[anIndex * 8 + 5] & 0xFF) << 16) + ((this.dataInfoBuffer[anIndex * 8 + 6] & 0xFF) << 8) + ((this.dataInfoBuffer[anIndex * 8 + 7] & 0xFF) << 0);
        int[] integerArray = new int[itemLength];
        if (itemType == 4) {
            int i = 0;
            while (i < itemLength) {
                integerArray[i] = ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 24) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 16) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 8) + ((this.dataBuffer[tmpDataOffset++] & 0xFF) << 0);
                ++i;
            }
        } else {
            throw new UniRPCPacketException("The requested item is NOT an integer array.", 81004);
        }
        return integerArray;
    }

    public int readMessageType() {
        return ((this.headerBuffer[8] & 0xFF) << 24) + ((this.headerBuffer[9] & 0xFF) << 16) + ((this.headerBuffer[10] & 0xFF) << 8) + ((this.headerBuffer[11] & 0xFF) << 0);
    }

    public int readReturnCode() {
        return ((this.headerBuffer[16] & 0xFF) << 24) + ((this.headerBuffer[17] & 0xFF) << 16) + ((this.headerBuffer[18] & 0xFF) << 8) + ((this.headerBuffer[19] & 0xFF) << 0);
    }

    public byte[] readBytes(int anIndex) throws UniRPCPacketException {
        if (anIndex >= this.currentArgumentCount) {
            throw new UniRPCPacketException("The requested item does NOT exist.", 81004);
        }
        int tmpDataOffset = this.dataItemOffset(anIndex);
        int itemLength = ((this.dataInfoBuffer[anIndex * 8 + 0] & 0xFF) << 24) + ((this.dataInfoBuffer[anIndex * 8 + 1] & 0xFF) << 16) + ((this.dataInfoBuffer[anIndex * 8 + 2] & 0xFF) << 8) + ((this.dataInfoBuffer[anIndex * 8 + 3] & 0xFF) << 0);
        int itemType = ((this.dataInfoBuffer[anIndex * 8 + 4] & 0xFF) << 24) + ((this.dataInfoBuffer[anIndex * 8 + 5] & 0xFF) << 16) + ((this.dataInfoBuffer[anIndex * 8 + 6] & 0xFF) << 8) + ((this.dataInfoBuffer[anIndex * 8 + 7] & 0xFF) << 0);
        if (itemType == 3 || itemType == 2) {
            byte[] bArray = new byte[itemLength];
            System.arraycopy(this.dataBuffer, tmpDataOffset, bArray, 0, itemLength);
            return bArray;
        }
        throw new UniRPCPacketException("The requested item is NOT a UniVerse string.", 81004);
    }

    public String readString(int anIndex) throws UniRPCPacketException {
        String itemValue;
        if (anIndex >= this.currentArgumentCount) {
            throw new UniRPCPacketException("The requested item does NOT exist.", 81004);
        }
        int tmpDataOffset = this.dataItemOffset(anIndex);
        int itemLength = ((this.dataInfoBuffer[anIndex * 8 + 0] & 0xFF) << 24) + ((this.dataInfoBuffer[anIndex * 8 + 1] & 0xFF) << 16) + ((this.dataInfoBuffer[anIndex * 8 + 2] & 0xFF) << 8) + ((this.dataInfoBuffer[anIndex * 8 + 3] & 0xFF) << 0);
        int itemType = ((this.dataInfoBuffer[anIndex * 8 + 4] & 0xFF) << 24) + ((this.dataInfoBuffer[anIndex * 8 + 5] & 0xFF) << 16) + ((this.dataInfoBuffer[anIndex * 8 + 6] & 0xFF) << 8) + ((this.dataInfoBuffer[anIndex * 8 + 7] & 0xFF) << 0);
        if (itemType == 3 || itemType == 2) {
            if (clientEncoding == null) {
                itemValue = new String(this.dataBuffer, tmpDataOffset, itemLength);
            } else {
                try {
                    itemValue = new String(this.dataBuffer, tmpDataOffset, itemLength, clientEncoding);
                }
                catch (Exception e) {
                    throw new UniRPCPacketException("In write, encoding conversion error" + e.getMessage(), 81004);
                }
            }
        } else {
            throw new UniRPCPacketException("The requested item is NOT a UniVerse string.", 81004);
        }
        return itemValue;
    }

    public int readType(int anIndex) throws UniRPCPacketException {
        if (anIndex >= this.currentArgumentCount) {
            throw new UniRPCPacketException("The requested item does NOT exist.", 81004);
        }
        return ((this.dataInfoBuffer[anIndex * 8 + 4] & 0xFF) << 24) + ((this.dataInfoBuffer[anIndex * 8 + 5] & 0xFF) << 16) + ((this.dataInfoBuffer[anIndex * 8 + 6] & 0xFF) << 8) + ((this.dataInfoBuffer[anIndex * 8 + 7] & 0xFF) << 0);
    }

    public UniString readUniString(int anIndex) throws UniRPCPacketException {
        return new UniString(this.readString(anIndex));
    }

    public void receive(DataInputStream aDataIn) throws UniRPCPacketException {
        if (aDataIn == null) {
            throw new UniRPCPacketException("The DataInputStream is dead.", 81002);
        }
        try {
            aDataIn.readFully(this.headerBuffer);
            int dataLength = this.readHeaderLength();
            this.currentArgumentCount = this.readArgumentCount();
            this.dataBufferCompressed = new byte[dataLength];
            int maxreadsize = UniTokens.UNIRPC_SOCKETREAD_MAX_SIZE;
            if (dataLength > maxreadsize) {
                int j;
                int offset = 0;
                byte[] sBA = new byte[maxreadsize];
                int loop = dataLength / maxreadsize;
                int i = 0;
                while (i < loop) {
                    aDataIn.readFully(sBA);
                    j = offset;
                    while (j < offset + maxreadsize) {
                        this.dataBufferCompressed[j] = sBA[j - offset];
                        ++j;
                    }
                    offset += maxreadsize;
                    ++i;
                }
                int left = dataLength - offset;
                if (left > 0) {
                    sBA = new byte[left];
                    aDataIn.readFully(sBA);
                    j = offset;
                    while (j < offset + left) {
                        this.dataBufferCompressed[j] = sBA[j - offset];
                        ++j;
                    }
                }
            } else {
                aDataIn.readFully(this.dataBufferCompressed);
            }
            this.decompress();
            this.decrypt();
        }
        catch (IOException e) {
            throw new UniRPCPacketException(e.getMessage(), 81009);
        }
        if (this.debugLevel > 3) {
            this.dump();
        }
    }

    public void send(DataOutputStream aDataOut, byte anEncryptionMask) throws UniRPCPacketException {
        if (aDataOut == null) {
            throw new UniRPCPacketException("The DataOutputStream is dead.", 81002);
        }
        try {
            if (!this.isEncrypted) {
                this.encrypt(anEncryptionMask);
                this.isEncrypted = true;
            }
            if (!this.isCompressed) {
                this.compress();
                this.isCompressed = true;
            }
            if (this.debugLevel > 3) {
                this.dump();
            }
            aDataOut.write(this.headerBuffer);
            aDataOut.write(this.dataBufferCompressed);
            this.isEncrypted = false;
            this.isCompressed = false;
        }
        catch (IOException e) {
            throw new UniRPCPacketException(e.getMessage(), 81009);
        }
    }

    public void setCompressionThreshold(int aThreshold) throws UniRPCPacketException {
        if (!this.isCompressionSupported() && aThreshold != 0) {
            throw new UniRPCPacketException("Compression is not supported on this connection.", 81026);
        }
        this.currentCompressionThreshold = aThreshold;
    }

    @Override
    public void setVersionCurrent(int aVersion) {
        super.setVersionCurrent(aVersion);
        this.headerBuffer[0] = 108;
        this.headerBuffer[1] = (byte)(this.currentVersion >>> 0 & 0xFF);
    }

    public void write(int anIndex, char[] aCharArray) throws UniRPCPacketException {
        byte[] tmpbArray;
        if (anIndex == 0) {
            this.resetData();
        } else {
            if (anIndex != this.currentArgumentCount) {
                throw new UniRPCPacketException("All packet arguments must be inserted in order, starting with zero.", 81010);
            }
            if (anIndex >= 2048) {
                throw new UniRPCPacketException("A maximum of 2048 packet arguments are supported.", 81010);
            }
        }
        String aString = new String(aCharArray);
        if (clientEncoding != null) {
            try {
                tmpbArray = aString.getBytes(clientEncoding);
            }
            catch (Exception exception) {
                throw new UniRPCPacketException("In write, encoding conversion error", 81004);
            }
        } else {
            tmpbArray = aString.getBytes();
        }
        byte[] bArray = new byte[tmpbArray.length + 1];
        int i = 0;
        while (i < tmpbArray.length) {
            bArray[i] = tmpbArray[i];
            ++i;
        }
        bArray[tmpbArray.length] = 0;
        this.dataInfoBuffer[anIndex * 8 + 0] = (byte)(bArray.length - 1 >>> 24 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 1] = (byte)(bArray.length - 1 >>> 16 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 2] = (byte)(bArray.length - 1 >>> 8 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 3] = (byte)(bArray.length - 1 >>> 0 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 4] = 0;
        this.dataInfoBuffer[anIndex * 8 + 5] = 0;
        this.dataInfoBuffer[anIndex * 8 + 6] = 0;
        this.dataInfoBuffer[anIndex * 8 + 7] = 2;
        ++this.currentArgumentCount;
        if (bArray.length + 3 > this.dataBuffer.length - this.dataOffset) {
            this.increaseDataBuffer(bArray.length + 3);
        }
        i = 0;
        while (i < bArray.length) {
            this.dataBuffer[this.dataOffset++] = bArray[i];
            ++i;
        }
        this.dataOffset += (bArray.length + 3 & 0xFFFFFFFC) - bArray.length;
    }

    public void write(int anIndex, double aDouble) throws UniRPCPacketException {
        if (anIndex == 0) {
            this.resetData();
        } else {
            if (anIndex != this.currentArgumentCount) {
                throw new UniRPCPacketException("All packet arguments must be inserted in order, starting with zero.", 81010);
            }
            if (anIndex >= 2048) {
                throw new UniRPCPacketException("A maximum of 2048 packet arguments are supported.", 81010);
            }
        }
        this.dataInfoBuffer[anIndex * 8 + 0] = 0;
        this.dataInfoBuffer[anIndex * 8 + 1] = 0;
        this.dataInfoBuffer[anIndex * 8 + 2] = 0;
        this.dataInfoBuffer[anIndex * 8 + 3] = 1;
        this.dataInfoBuffer[anIndex * 8 + 4] = 0;
        this.dataInfoBuffer[anIndex * 8 + 5] = 0;
        this.dataInfoBuffer[anIndex * 8 + 6] = 0;
        this.dataInfoBuffer[anIndex * 8 + 7] = 1;
        ++this.currentArgumentCount;
        if (8 > this.dataBuffer.length - this.dataOffset) {
            this.increaseDataBuffer(8);
        }
        long longDouble = Double.doubleToLongBits(aDouble);
        this.dataBuffer[this.dataOffset++] = (byte)((int)(longDouble >>> 56) & 0xFF);
        this.dataBuffer[this.dataOffset++] = (byte)((int)(longDouble >>> 48) & 0xFF);
        this.dataBuffer[this.dataOffset++] = (byte)((int)(longDouble >>> 40) & 0xFF);
        this.dataBuffer[this.dataOffset++] = (byte)((int)(longDouble >>> 32) & 0xFF);
        this.dataBuffer[this.dataOffset++] = (byte)((int)(longDouble >>> 24) & 0xFF);
        this.dataBuffer[this.dataOffset++] = (byte)((int)(longDouble >>> 16) & 0xFF);
        this.dataBuffer[this.dataOffset++] = (byte)((int)(longDouble >>> 8) & 0xFF);
        this.dataBuffer[this.dataOffset++] = (byte)((int)(longDouble >>> 0) & 0xFF);
    }

    public void write(int anIndex, double[] aDouble) throws UniRPCPacketException {
        if (anIndex == 0) {
            this.resetData();
        } else {
            if (anIndex != this.currentArgumentCount) {
                throw new UniRPCPacketException("All packet arguments must be inserted in order, starting with zero.", 81010);
            }
            if (anIndex >= 2048) {
                throw new UniRPCPacketException("A maximum of 2048 packet arguments are supported.", 81010);
            }
        }
        this.dataInfoBuffer[anIndex * 8 + 0] = (byte)(aDouble.length >>> 24 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 1] = (byte)(aDouble.length >>> 16 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 2] = (byte)(aDouble.length >>> 8 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 3] = (byte)(aDouble.length >>> 0 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 4] = 0;
        this.dataInfoBuffer[anIndex * 8 + 5] = 0;
        this.dataInfoBuffer[anIndex * 8 + 6] = 0;
        this.dataInfoBuffer[anIndex * 8 + 7] = 5;
        ++this.currentArgumentCount;
        if (aDouble.length * 8 > this.dataBuffer.length - this.dataOffset) {
            this.increaseDataBuffer(aDouble.length * 8);
        }
        int i = 0;
        while (i < aDouble.length) {
            long longDouble = Double.doubleToLongBits(aDouble[i]);
            this.dataBuffer[this.dataOffset++] = (byte)((int)(longDouble >>> 56) & 0xFF);
            this.dataBuffer[this.dataOffset++] = (byte)((int)(longDouble >>> 48) & 0xFF);
            this.dataBuffer[this.dataOffset++] = (byte)((int)(longDouble >>> 40) & 0xFF);
            this.dataBuffer[this.dataOffset++] = (byte)((int)(longDouble >>> 32) & 0xFF);
            this.dataBuffer[this.dataOffset++] = (byte)((int)(longDouble >>> 24) & 0xFF);
            this.dataBuffer[this.dataOffset++] = (byte)((int)(longDouble >>> 16) & 0xFF);
            this.dataBuffer[this.dataOffset++] = (byte)((int)(longDouble >>> 8) & 0xFF);
            this.dataBuffer[this.dataOffset++] = (byte)((int)(longDouble >>> 0) & 0xFF);
            ++i;
        }
    }

    public void write(int anIndex, int anInteger) throws UniRPCPacketException {
        if (anIndex == 0) {
            this.resetData();
        } else {
            if (anIndex != this.currentArgumentCount) {
                throw new UniRPCPacketException("All packet arguments must be inserted in order, starting with zero.", 81010);
            }
            if (anIndex >= 2048) {
                throw new UniRPCPacketException("A maximum of 2048 packet arguments are supported.", 81010);
            }
        }
        this.dataInfoBuffer[anIndex * 8 + 0] = 0;
        this.dataInfoBuffer[anIndex * 8 + 1] = 0;
        this.dataInfoBuffer[anIndex * 8 + 2] = 0;
        this.dataInfoBuffer[anIndex * 8 + 3] = 1;
        this.dataInfoBuffer[anIndex * 8 + 4] = 0;
        this.dataInfoBuffer[anIndex * 8 + 5] = 0;
        this.dataInfoBuffer[anIndex * 8 + 6] = 0;
        this.dataInfoBuffer[anIndex * 8 + 7] = 0;
        ++this.currentArgumentCount;
        if (4 > this.dataBuffer.length - this.dataOffset) {
            this.increaseDataBuffer(4);
        }
        this.dataBuffer[this.dataOffset++] = (byte)(anInteger >>> 24 & 0xFF);
        this.dataBuffer[this.dataOffset++] = (byte)(anInteger >>> 16 & 0xFF);
        this.dataBuffer[this.dataOffset++] = (byte)(anInteger >>> 8 & 0xFF);
        this.dataBuffer[this.dataOffset++] = (byte)(anInteger >>> 0 & 0xFF);
    }

    public void write(int anIndex, int[] anInteger) throws UniRPCPacketException {
        if (anIndex == 0) {
            this.resetData();
        } else {
            if (anIndex != this.currentArgumentCount) {
                throw new UniRPCPacketException("All packet arguments must be inserted in order, starting with zero.", 81010);
            }
            if (anIndex >= 2048) {
                throw new UniRPCPacketException("A maximum of 2048 packet arguments are supported.", 81010);
            }
        }
        this.dataInfoBuffer[anIndex * 8 + 0] = (byte)(anInteger.length >>> 24 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 1] = (byte)(anInteger.length >>> 16 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 2] = (byte)(anInteger.length >>> 8 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 3] = (byte)(anInteger.length >>> 0 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 4] = 0;
        this.dataInfoBuffer[anIndex * 8 + 5] = 0;
        this.dataInfoBuffer[anIndex * 8 + 6] = 0;
        this.dataInfoBuffer[anIndex * 8 + 7] = 4;
        ++this.currentArgumentCount;
        if (anInteger.length * 4 > this.dataBuffer.length - this.dataOffset) {
            this.increaseDataBuffer(anInteger.length * 4);
        }
        int i = 0;
        while (i < anInteger.length) {
            this.dataBuffer[this.dataOffset++] = (byte)(anInteger[i] >>> 24 & 0xFF);
            this.dataBuffer[this.dataOffset++] = (byte)(anInteger[i] >>> 16 & 0xFF);
            this.dataBuffer[this.dataOffset++] = (byte)(anInteger[i] >>> 8 & 0xFF);
            this.dataBuffer[this.dataOffset++] = (byte)(anInteger[i] >>> 0 & 0xFF);
            ++i;
        }
    }

    public void write(int anIndex, String aString) throws UniRPCPacketException {
        byte[] bArray;
        if (anIndex == 0) {
            this.resetData();
        } else {
            if (anIndex != this.currentArgumentCount) {
                throw new UniRPCPacketException("All packet arguments must be inserted in order, starting with zero.", 81010);
            }
            if (anIndex >= 2048) {
                throw new UniRPCPacketException("A maximum of 2048 packet arguments are supported.", 81010);
            }
        }
        if (clientEncoding != null) {
            try {
                bArray = aString.getBytes(clientEncoding);
            }
            catch (Exception exception) {
                throw new UniRPCPacketException("In write, encoding conversion error", 81004);
            }
        } else {
            bArray = aString.getBytes();
        }
        this.dataInfoBuffer[anIndex * 8 + 0] = (byte)(bArray.length >>> 24 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 1] = (byte)(bArray.length >>> 16 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 2] = (byte)(bArray.length >>> 8 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 3] = (byte)(bArray.length >>> 0 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 4] = 0;
        this.dataInfoBuffer[anIndex * 8 + 5] = 0;
        this.dataInfoBuffer[anIndex * 8 + 6] = 0;
        this.dataInfoBuffer[anIndex * 8 + 7] = 3;
        ++this.currentArgumentCount;
        if (bArray.length + 3 > this.dataBuffer.length - this.dataOffset) {
            this.increaseDataBuffer(bArray.length + 3);
        }
        int i = 0;
        while (i < bArray.length) {
            this.dataBuffer[this.dataOffset++] = bArray[i];
            ++i;
        }
        this.dataOffset += (bArray.length + 3 & 0xFFFFFFFC) - bArray.length;
    }

    public void write(int anIndex, UniString aString) throws UniRPCPacketException {
        byte[] bArray;
        if (clientEncoding != null) {
            try {
                bArray = aString.getBytes();
            }
            catch (Exception exception) {
                throw new UniRPCPacketException("In write, encoding conversion error", 81004);
            }
        } else {
            bArray = aString.getBytes();
        }
        this.write(anIndex, bArray);
    }

    public void write(int anIndex, byte[] bArray) throws UniRPCPacketException {
        if (anIndex == 0) {
            this.resetData();
        } else {
            if (anIndex != this.currentArgumentCount) {
                throw new UniRPCPacketException("All packet arguments must be inserted in order, starting with zero.", 81010);
            }
            if (anIndex >= 2048) {
                throw new UniRPCPacketException("A maximum of 2048 packet arguments are supported.", 81010);
            }
        }
        this.dataInfoBuffer[anIndex * 8 + 0] = (byte)(bArray.length >>> 24 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 1] = (byte)(bArray.length >>> 16 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 2] = (byte)(bArray.length >>> 8 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 3] = (byte)(bArray.length >>> 0 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 4] = 0;
        this.dataInfoBuffer[anIndex * 8 + 5] = 0;
        this.dataInfoBuffer[anIndex * 8 + 6] = 0;
        this.dataInfoBuffer[anIndex * 8 + 7] = 3;
        ++this.currentArgumentCount;
        if (bArray.length + 3 > this.dataBuffer.length - this.dataOffset) {
            this.increaseDataBuffer(bArray.length + 3);
        }
        int i = 0;
        while (i < bArray.length) {
            this.dataBuffer[this.dataOffset++] = bArray[i];
            ++i;
        }
        this.dataOffset += (bArray.length + 3 & 0xFFFFFFFC) - bArray.length;
    }

    public void writeChars(int anIndex, byte[] bArray) throws UniRPCPacketException {
        if (anIndex == 0) {
            this.resetData();
        } else {
            if (anIndex != this.currentArgumentCount) {
                throw new UniRPCPacketException("All packet arguments must be inserted in order, starting with zero.", 81010);
            }
            if (anIndex >= 2048) {
                throw new UniRPCPacketException("A maximum of 2048 packet arguments are supported.", 81010);
            }
        }
        this.dataInfoBuffer[anIndex * 8 + 0] = (byte)(bArray.length >>> 24 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 1] = (byte)(bArray.length >>> 16 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 2] = (byte)(bArray.length >>> 8 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 3] = (byte)(bArray.length >>> 0 & 0xFF);
        this.dataInfoBuffer[anIndex * 8 + 4] = 0;
        this.dataInfoBuffer[anIndex * 8 + 5] = 0;
        this.dataInfoBuffer[anIndex * 8 + 6] = 0;
        this.dataInfoBuffer[anIndex * 8 + 7] = 2;
        ++this.currentArgumentCount;
        if (bArray.length + 4 > this.dataBuffer.length - this.dataOffset) {
            this.increaseDataBuffer(bArray.length + 4);
        }
        int i = 0;
        while (i < bArray.length) {
            this.dataBuffer[this.dataOffset++] = bArray[i];
            ++i;
        }
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataOffset += (bArray.length + 1 + 3 & 0xFFFFFFFC) - (bArray.length + 1);
    }

    public void writeMessageType(int aType) {
        this.headerBuffer[8] = (byte)(aType >>> 24 & 0xFF);
        this.headerBuffer[9] = (byte)(aType >>> 16 & 0xFF);
        this.headerBuffer[10] = (byte)(aType >>> 8 & 0xFF);
        this.headerBuffer[11] = (byte)(aType >>> 0 & 0xFF);
    }

    public void writeReturnCode(int aReturnCode) {
        this.headerBuffer[16] = (byte)(aReturnCode >>> 24 & 0xFF);
        this.headerBuffer[17] = (byte)(aReturnCode >>> 16 & 0xFF);
        this.headerBuffer[18] = (byte)(aReturnCode >>> 8 & 0xFF);
        this.headerBuffer[19] = (byte)(aReturnCode >>> 0 & 0xFF);
    }

    private void compress() {
        if (this.currentCompressionThreshold > 0 && this.currentArgumentCount * 8 + this.dataOffset >= this.currentCompressionThreshold) {
            this.dataBufferCompressed = this.dataBufferEncrypted;
            this.writeHeaderLength(this.dataBufferCompressed.length);
            this.writeCompressionMask((byte)1);
        } else {
            this.dataBufferCompressed = this.dataBufferEncrypted;
            this.writeHeaderLength(this.dataBufferCompressed.length);
            this.writeCompressionMask((byte)0);
        }
    }

    private int dataItemOffset(int anIndex) {
        int tmpDataOffset = 0;
        int i = 0;
        while (i < anIndex) {
            int tmpType = ((this.dataInfoBuffer[i * 8 + 4] & 0xFF) << 24) + ((this.dataInfoBuffer[i * 8 + 5] & 0xFF) << 16) + ((this.dataInfoBuffer[i * 8 + 6] & 0xFF) << 8) + ((this.dataInfoBuffer[i * 8 + 7] & 0xFF) << 0);
            switch (tmpType) {
                case 0: {
                    tmpDataOffset += 4;
                    break;
                }
                case 1: {
                    tmpDataOffset += 8;
                    break;
                }
                case 2: 
                case 6: {
                    int tmpLength = ((this.dataInfoBuffer[i * 8 + 0] & 0xFF) << 24) + ((this.dataInfoBuffer[i * 8 + 1] & 0xFF) << 16) + ((this.dataInfoBuffer[i * 8 + 2] & 0xFF) << 8) + ((this.dataInfoBuffer[i * 8 + 3] & 0xFF) << 0);
                    int tmpLengthPlusOne = tmpLength + 1;
                    tmpDataOffset += tmpLengthPlusOne;
                    tmpDataOffset += (tmpLengthPlusOne + 3 & 0xFFFFFFFC) - tmpLengthPlusOne;
                    break;
                }
                case 4: {
                    int tmpLength = ((this.dataInfoBuffer[i * 8 + 0] & 0xFF) << 24) + ((this.dataInfoBuffer[i * 8 + 1] & 0xFF) << 16) + ((this.dataInfoBuffer[i * 8 + 2] & 0xFF) << 8) + ((this.dataInfoBuffer[i * 8 + 3] & 0xFF) << 0);
                    tmpDataOffset += 4 * tmpLength;
                    break;
                }
                case 5: {
                    int tmpLength = ((this.dataInfoBuffer[i * 8 + 0] & 0xFF) << 24) + ((this.dataInfoBuffer[i * 8 + 1] & 0xFF) << 16) + ((this.dataInfoBuffer[i * 8 + 2] & 0xFF) << 8) + ((this.dataInfoBuffer[i * 8 + 3] & 0xFF) << 0);
                    tmpDataOffset += 8 * tmpLength;
                    break;
                }
                case 3: {
                    int tmpLength = ((this.dataInfoBuffer[i * 8 + 0] & 0xFF) << 24) + ((this.dataInfoBuffer[i * 8 + 1] & 0xFF) << 16) + ((this.dataInfoBuffer[i * 8 + 2] & 0xFF) << 8) + ((this.dataInfoBuffer[i * 8 + 3] & 0xFF) << 0);
                    tmpDataOffset += tmpLength;
                    tmpDataOffset += (tmpLength + 3 & 0xFFFFFFFC) - tmpLength;
                    break;
                }
                default: {
                    int tmpLength = ((this.dataInfoBuffer[i * 8 + 0] & 0xFF) << 24) + ((this.dataInfoBuffer[i * 8 + 1] & 0xFF) << 16) + ((this.dataInfoBuffer[i * 8 + 2] & 0xFF) << 8) + ((this.dataInfoBuffer[i * 8 + 3] & 0xFF) << 0);
                    tmpDataOffset += tmpLength;
                    tmpDataOffset += (tmpLength + 3 & 0xFFFFFFFC) - tmpLength;
                }
            }
            ++i;
        }
        return tmpDataOffset;
    }

    private void decompress() {
        this.dataBufferEncrypted = this.headerBuffer[13] == 1 ? this.dataBufferCompressed : this.dataBufferCompressed;
        this.dataBufferCompressed = null;
    }

    private void decrypt() {
        byte encryptionType = this.readEncryptionMask();
        int dataBufferLength = this.dataBufferEncrypted.length - this.currentArgumentCount * 8;
        this.resizeDataBuffer(dataBufferLength);
        this.dataOffset = dataBufferLength;
        if (encryptionType == 1) {
            int i = 0;
            i = 0;
            while (i < this.currentArgumentCount * 8) {
                this.dataInfoBuffer[i] = (byte)(this.dataBufferEncrypted[i] ^ (byte)this.currentVersion);
                ++i;
            }
            int j = 0;
            while (j < this.dataOffset) {
                this.dataBuffer[j] = (byte)(this.dataBufferEncrypted[i] ^ (byte)this.currentVersion);
                ++j;
                ++i;
            }
        } else {
            System.arraycopy(this.dataBufferEncrypted, 0, this.dataInfoBuffer, 0, this.currentArgumentCount * 8);
            System.arraycopy(this.dataBufferEncrypted, this.currentArgumentCount * 8, this.dataBuffer, 0, this.dataOffset);
        }
        this.writeHeaderLength(this.currentArgumentCount * 8 + this.dataOffset);
        this.dataBufferEncrypted = null;
        if (dataBufferLength > UniTokens.UNIRPC_SOCKETREAD_MAX_SIZE) {
            System.gc();
        }
    }

    private void encrypt(byte anEncryptionType) {
        this.dataBufferEncrypted = new byte[this.currentArgumentCount * 8 + this.dataOffset];
        if (anEncryptionType == 1) {
            int i = 0;
            i = 0;
            while (i < this.currentArgumentCount * 8) {
                this.dataBufferEncrypted[i] = (byte)(this.dataInfoBuffer[i] ^ (byte)this.currentVersion);
                ++i;
            }
            int j = 0;
            while (j < this.dataOffset) {
                this.dataBufferEncrypted[i] = (byte)(this.dataBuffer[j] ^ (byte)this.currentVersion);
                ++j;
                ++i;
            }
        } else {
            System.arraycopy(this.dataInfoBuffer, 0, this.dataBufferEncrypted, 0, this.currentArgumentCount * 8);
            System.arraycopy(this.dataBuffer, 0, this.dataBufferEncrypted, this.currentArgumentCount * 8, this.dataOffset);
        }
        this.writeEncryptionMask(anEncryptionType);
        this.writeArgumentCount(this.currentArgumentCount);
    }

    private void increaseDataBuffer(int length) {
        byte[] newDataBuffer = new byte[this.dataBuffer.length + (length / 32768 + 1) * 32768];
        System.arraycopy(this.dataBuffer, 0, newDataBuffer, 0, this.dataBuffer.length);
        this.dataBuffer = newDataBuffer;
    }

    private int readArgumentCount() {
        return ((this.headerBuffer[20] & 0xFF) << 8) + ((this.headerBuffer[21] & 0xFF) << 0);
    }

    private int readHeaderLength() {
        return ((this.headerBuffer[4] & 0xFF) << 24) + ((this.headerBuffer[5] & 0xFF) << 16) + ((this.headerBuffer[6] & 0xFF) << 8) + ((this.headerBuffer[7] & 0xFF) << 0);
    }

    private void resetData() {
        this.dataOffset = 0;
        this.currentArgumentCount = 0;
        this.isCompressed = false;
        this.isEncrypted = false;
        if (this.dataBuffer.length > 32768) {
            this.dataBuffer = new byte[32768];
        }
    }

    private void resetHeader() {
        int i = 0;
        while (i < this.headerBuffer.length) {
            this.headerBuffer[i] = 0;
            ++i;
        }
        this.headerBuffer[0] = 108;
        this.headerBuffer[1] = (byte)(this.currentVersion >>> 0 & 0xFF);
        this.headerBuffer[8] = 0;
        this.headerBuffer[9] = 0;
        this.headerBuffer[10] = 0;
        this.headerBuffer[11] = 0;
        this.headerBuffer[12] = 2;
        this.headerBuffer[13] = 0;
        this.headerBuffer[14] = 0;
    }

    private void resizeDataBuffer(int aLength) {
        if ((aLength > this.dataBuffer.length || this.dataBuffer.length != 32768) && aLength > this.dataBuffer.length) {
            this.dataBuffer = aLength > this.dataBuffer.length ? new byte[(aLength / 32768 + 1) * 32768] : new byte[32768];
        }
    }

    private void writeArgumentCount(int aArgumentCount) {
        this.headerBuffer[20] = (byte)(aArgumentCount >>> 8 & 0xFF);
        this.headerBuffer[21] = (byte)(aArgumentCount >>> 0 & 0xFF);
    }

    private void writeCompressionMask(byte aMask) {
        this.headerBuffer[13] = aMask;
    }

    private void writeEncryptionMask(byte aMask) {
        this.headerBuffer[14] = aMask;
    }

    private void writeHeaderLength(int aLength) {
        this.headerBuffer[4] = (byte)(aLength >>> 24 & 0xFF);
        this.headerBuffer[5] = (byte)(aLength >>> 16 & 0xFF);
        this.headerBuffer[6] = (byte)(aLength >>> 8 & 0xFF);
        this.headerBuffer[7] = (byte)(aLength >>> 0 & 0xFF);
    }
}

