/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniproxy;

import asjava.uniproxy.UniProxyConnection;
import asjava.uniproxy.UniProxyException;
import asjava.uniproxy.UniProxyServer;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class UniProxyServerT1
extends Thread {
    int port;
    UniProxyServer parent;
    private Hashtable clientConnectTable = new Hashtable();
    private boolean isSuspended = false;
    private int debugLevel;
    private int maxConnections;
    private ServerSocket socketServer;
    private SSLServerSocket sslSocketServer;
    private Socket newConnection;
    private ThreadGroup tg;
    private boolean externalSSLType;
    private String kstype;
    private String tstype;
    private static char pwdDelim = (char)95;

    public UniProxyServerT1(int port, UniProxyServer ups, ThreadGroup tg, boolean externalSSLType) {
        this.port = port;
        this.parent = ups;
        this.debugLevel = this.parent.getDebugLevel();
        this.maxConnections = this.parent.getMaxConnections();
        this.tg = tg;
        this.externalSSLType = externalSSLType;
    }

    public void SuspendT1Server() {
        this.isSuspended = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartT1Server() {
        if (this.isSuspended) {
            if (this.debugLevel > 0) {
                this.parent.writeLog("Restarting proxy server.");
            }
            this.isSuspended = false;
            UniProxyServerT1 uniProxyServerT1 = this;
            synchronized (uniProxyServerT1) {
                this.notify();
            }
        } else {
            this.parent.writeLog("Error: Proxy server Thread T1 not in suspended state, can't restart it.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object sslKeyFile;
            new Frame();
            if (this.debugLevel > 0) {
                this.parent.writeLog("Starting SSL proxy server.");
            }
            if (this.externalSSLType) {
                sslKeyFile = this.parent.getConfiguration().getProxySSLKeyFile();
                String sslKeyFilePwd = this.parent.getConfiguration().getProxySSLKeyFilePwd();
                String sslTrustFile = this.parent.getConfiguration().getProxySSLTrustFile();
                String sslPwdMethod = this.parent.getConfiguration().getProxyPwdMethod();
                boolean sslClientAuthentication = this.parent.getConfiguration().getProxySSLClientAuthentication();
                this.kstype = this.parent.getConfiguration().getProxyKeystoreType();
                this.tstype = this.parent.getConfiguration().getProxyTruststoreType();
                if (sslPwdMethod.equals("INTERACTIVE")) {
                    if (this.debugLevel > 0) {
                        this.parent.writeLog("getting keystore password interactively");
                    }
                    try {
                        Runtime r = Runtime.getRuntime();
                        Process p = r.exec("java asjava.uniproxy.UniProxyGetPwd");
                        p.waitFor();
                        File f = new File("tmp0967");
                        int n = (int)f.length();
                        char[] cbuf = new char[n];
                        FileReader fr = new FileReader("tmp0967");
                        n = fr.read(cbuf);
                        fr.close();
                        String password = new String(cbuf);
                        System.out.println(password);
                        sslKeyFilePwd = password;
                        f.delete();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.debugLevel > 0) {
                        this.parent.writeLog("getting truststore password interactively");
                    }
                } else if (sslPwdMethod.equals("USER_DEFINED")) {
                    int indf;
                    if (this.debugLevel > 0) {
                        this.parent.writeLog("calling user defined method");
                    }
                    if ((indf = sslKeyFilePwd.indexOf(pwdDelim)) != -1) {
                        String method_name;
                        String arg = sslKeyFilePwd.substring(0, indf);
                        int indl = sslKeyFilePwd.lastIndexOf(pwdDelim);
                        if (indf != indl) {
                            method_name = sslKeyFilePwd.substring(indf + 1, indl);
                            if (this.debugLevel > 0) {
                                this.parent.writeLog("method=" + method_name);
                            }
                        } else {
                            throw new UniProxyException(10005);
                        }
                        String class_name = sslKeyFilePwd.substring(indl + 1);
                        if (this.debugLevel > 0) {
                            this.parent.writeLog("class=" + class_name);
                        }
                        try {
                            Class<?> c = Class.forName(class_name);
                            Class[] parsDef = new Class[]{arg.getClass()};
                            Method m = c.getMethod(method_name, parsDef);
                            Object[] pars = new Object[]{arg};
                            sslKeyFilePwd = (String)m.invoke(null, pars);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new UniProxyException(10005);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            throw new UniProxyException(10005);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            throw new UniProxyException(10005);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new UniProxyException(10005);
                        }
                    } else {
                        throw new UniProxyException(10005);
                    }
                }
                System.setProperty("javax.net.ssl.trustStore", sslTrustFile);
                System.setProperty("javax.net.ssl.keyStore", (String)sslKeyFile);
                System.setProperty("javax.net.ssl.keyStorePassword", sslKeyFilePwd);
                SSLServerSocketFactory factory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
                this.sslSocketServer = (SSLServerSocket)factory.createServerSocket(this.port);
                if (sslClientAuthentication) {
                    this.sslSocketServer.setNeedClientAuth(true);
                } else {
                    this.sslSocketServer.setNeedClientAuth(false);
                }
                this.sslSocketServer.setSoTimeout(5000);
                if (this.debugLevel > 2) {
                    this.parent.writeLog("Accepting proxy connections on port " + this.sslSocketServer.getLocalPort());
                }
            } else {
                this.socketServer = new ServerSocket(this.port);
                this.socketServer.setSoTimeout(5000);
                if (this.debugLevel > 2) {
                    this.parent.writeLog("Accepting proxy connections on port " + this.socketServer.getLocalPort());
                }
            }
            while (!this.parent.getisShutdown()) {
                UniProxyConnection proxyConnection;
                try {
                    this.newConnection = this.externalSSLType ? this.sslSocketServer.accept() : this.socketServer.accept();
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (!this.isSuspended) continue;
                    try {
                        sslKeyFile = this;
                        synchronized (sslKeyFile) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (this.isSuspended) {
                    try {
                        sslKeyFile = this;
                        synchronized (sslKeyFile) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    proxyConnection = new UniProxyConnection(this.tg, this.parent, this.newConnection, this.externalSSLType);
                }
                catch (UniProxyException uniProxyException) {
                    continue;
                }
                if (this.clientConnectTable.size() >= this.maxConnections) {
                    this.syncConnectionTable();
                    if (this.clientConnectTable.size() >= this.maxConnections) {
                        if (this.debugLevel > 2) {
                            this.parent.writeLog("Connection limit reached, pausing 5000 seconds for connection slots to be freed up.");
                        }
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        this.syncConnectionTable();
                        if (this.clientConnectTable.size() >= this.maxConnections) {
                            proxyConnection.setExceedMaxSessions();
                        }
                    }
                }
                proxyConnection.start();
                if (this.debugLevel > 2) {
                    this.parent.writeLog("A new client connection thread started.");
                }
                this.clientConnectTable.put(proxyConnection, proxyConnection);
            }
        }
        catch (IOException e) {
            this.parent.writeLog("UniProxyServerT1 thread Error: " + e.toString());
        }
        catch (UniProxyException e) {
            this.parent.writeLog("UniProxyServerT1 thread Error: " + e.toString());
        }
        this.shutdown();
        try {
            this.parent.notifyMe();
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.debugLevel > 0) {
            this.parent.writeLog("Shutting down proxy server.");
        }
        this.SuspendT1Server();
        this.syncConnectionTable();
        Enumeration enum1 = this.clientConnectTable.elements();
        while (enum1.hasMoreElements()) {
            UniProxyConnection item = (UniProxyConnection)enum1.nextElement();
            if (this.debugLevel > 5) {
                this.parent.writeLog("   waiting on client connection " + item.hashCode() + " to finish.");
            }
            try {
                item.join();
                if (this.debugLevel <= 5) continue;
                this.parent.writeLog("   client connection " + item.hashCode() + " has finished.");
            }
            catch (InterruptedException e) {
                this.parent.writeLog(e.toString());
            }
        }
        this.isSuspended = false;
        UniProxyServerT1 uniProxyServerT1 = this;
        synchronized (uniProxyServerT1) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownFast() {
        UniProxyConnection item;
        if (this.debugLevel > 0) {
            this.parent.writeLog("Shutting down proxy server immediately.");
        }
        this.SuspendT1Server();
        this.syncConnectionTable();
        if (this.debugLevel > 5) {
            this.parent.writeLog("Signal all open client connection threads to terminate.");
        }
        Enumeration enum1 = this.clientConnectTable.elements();
        while (enum1.hasMoreElements()) {
            item = (UniProxyConnection)enum1.nextElement();
            if (this.debugLevel > 5) {
                this.parent.writeLog("   sending shutdown fast signal to client connection " + item.hashCode() + ".");
            }
            item.stopFast();
        }
        if (this.debugLevel > 5) {
            this.parent.writeLog("Wait on all open client connection threads to finish.");
        }
        enum1 = this.clientConnectTable.elements();
        while (enum1.hasMoreElements()) {
            item = (UniProxyConnection)enum1.nextElement();
            if (this.debugLevel > 5) {
                this.parent.writeLog("   waiting on client connection " + item.hashCode() + " to finish.");
            }
            try {
                item.join(60000L);
                if (item.isAlive()) {
                    item.stop();
                    this.parent.writeLog("Error: client connection " + item.hashCode() + " did not finish and has been killed.");
                    continue;
                }
                if (this.debugLevel <= 5) continue;
                this.parent.writeLog("   client connection " + item.hashCode() + " has finished.");
            }
            catch (InterruptedException e) {
                this.parent.writeLog(e.toString());
            }
        }
        this.isSuspended = false;
        UniProxyServerT1 uniProxyServerT1 = this;
        synchronized (uniProxyServerT1) {
            this.notify();
        }
    }

    public void status() {
        if (this.debugLevel > -1) {
            this.parent.writeLog("Dumping current status of proxy server to log file.");
            this.parent.writeLog("   Updating the connection table.");
        }
        this.syncConnectionTable();
        if (this.debugLevel >= 8) {
            this.parent.writeLog("Connection Table Details:");
            this.parent.writeLog("   Maximum available connections=" + this.maxConnections);
            this.parent.writeLog("   Currently open client connections=" + this.clientConnectTable.size());
            this.parent.writeLog("   Current 'CLIENT' ThreadGroup active count=" + this.tg.activeCount());
        }
        this.parent.writeLog("   Connection List:");
        Enumeration enum1 = this.clientConnectTable.elements();
        while (enum1.hasMoreElements()) {
            UniProxyConnection item = (UniProxyConnection)enum1.nextElement();
            this.parent.writeLog("       ClientID:" + item.hashCode());
            item.status();
        }
    }

    private void syncConnectionTable() {
        if (this.debugLevel > 8) {
            this.parent.writeLog("Synchronizing Connection Table, cleaning up stale connections.");
        }
        Enumeration enum1 = this.clientConnectTable.elements();
        while (enum1.hasMoreElements()) {
            UniProxyConnection item = (UniProxyConnection)enum1.nextElement();
            if (item.isAlive()) continue;
            this.clientConnectTable.remove(item);
            if (this.debugLevel <= 8) continue;
            this.parent.writeLog("removing connection " + item.toString() + " because it is no longer alive.");
        }
        if (this.debugLevel > 8) {
            this.parent.writeLog("Connection Table Details:");
            this.parent.writeLog("   Maximum available connections=" + this.maxConnections);
            this.parent.writeLog("   Currently open client connections=" + this.clientConnectTable.size());
            this.parent.writeLog("   Current 'CLIENT' ThreadGroup active count=" + this.tg.activeCount());
        }
    }
}

