/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniproxy;

import asjava.uniproxy.UniProxyAdminServer;
import asjava.uniproxy.UniProxyConfiguration;
import asjava.uniproxy.UniProxyException;
import asjava.uniproxy.UniProxyServerT1;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;

public class UniProxyServer {
    private boolean isSuspendServer = false;
    private boolean isShutdownServer = false;
    private boolean waitForThreads = false;
    private int debugLevel;
    private int maxConnections;
    private UniProxyServerT1 upst1;
    private UniProxyServerT1 upst2;
    private RandomAccessFile logFile;
    private SimpleDateFormat logTime;
    private UniProxyConfiguration proxyConfiguration;
    private UniProxyAdminServer adminServer;
    private Hashtable dnsCache = new Hashtable();
    private ThreadGroup clientThreadGroup = new ThreadGroup("CLIENT");

    public UniProxyServer() {
        this.proxyConfiguration = new UniProxyConfiguration();
        this.logTime = new SimpleDateFormat("yy.MM.dd-HH.mm.ss");
    }

    public static void main(String[] args) {
        if (args.length != 1 || !args[0].toLowerCase().startsWith("-config=")) {
            System.out.println("Error: Incorrect or wrong number of arguments!");
            UniProxyServer.printUsage();
            System.exit(0);
        }
        UniProxyServer proxyServer = new UniProxyServer();
        UniProxyConfiguration newProxyConfiguration = new UniProxyConfiguration();
        try {
            newProxyConfiguration.setLocation(args[0].substring(8));
            newProxyConfiguration.load();
            proxyServer.setConfiguration(newProxyConfiguration);
            proxyServer.writeLog("---------------NEW SERVER INSTANCE---------------");
            if (newProxyConfiguration.getDebugLevel() > 0) {
                proxyServer.writeLog("Finished loading server configuration.");
                newProxyConfiguration.dump(proxyServer);
            }
        }
        catch (UniProxyException e) {
            proxyServer.writeLog("Failed to set proxy server configuration because:" + e.getMessage());
            System.exit(0);
        }
        try {
            proxyServer.runServer();
        }
        catch (UniProxyException e) {
            System.out.println("Error: Proxy server exiting, error=" + e.getMessage());
            proxyServer.writeLog("Error: Proxy server exiting, error=" + e.getMessage());
            System.exit(0);
        }
        proxyServer.writeLog("-------------SERVER EXITING NORMALLY-------------");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniProxyConfiguration getConfiguration() {
        UniProxyConfiguration uniProxyConfiguration = this.proxyConfiguration;
        synchronized (uniProxyConfiguration) {
            return this.proxyConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress lookupInetAddress(String aServerName) {
        InetAddress netAddress;
        UniProxyServer uniProxyServer = this;
        synchronized (uniProxyServer) {
            netAddress = (InetAddress)this.dnsCache.get(aServerName);
        }
        if (netAddress == null) {
            try {
                netAddress = InetAddress.getByName(aServerName);
                uniProxyServer = this;
                synchronized (uniProxyServer) {
                    this.dnsCache.put(aServerName, netAddress);
                }
            }
            catch (UnknownHostException unknownHostException) {
                netAddress = null;
            }
        }
        return netAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigure() {
        Object object;
        if (this.debugLevel > 0) {
            this.writeLog("Reconfiguring proxy server.");
        }
        UniProxyConfiguration newProxyConfiguration = new UniProxyConfiguration();
        newProxyConfiguration.setLocation(this.proxyConfiguration.getLocation());
        try {
            newProxyConfiguration.load();
            this.setConfiguration(newProxyConfiguration);
            object = this.proxyConfiguration;
            synchronized (object) {
                this.writeLog("This is the new proxy configuration.");
                newProxyConfiguration.dump(this);
            }
        }
        catch (UniProxyException e) {
            this.writeLog("Error: Failed to reload proxy server configuration with error=" + e.toString());
        }
        object = this;
        synchronized (object) {
            this.dnsCache.clear();
        }
    }

    public void restart() {
        if (this.isSuspendServer) {
            if (this.debugLevel > 0) {
                this.writeLog("Restarting proxy server.");
            }
            this.upst1.restartT1Server();
            if (this.upst2 != null) {
                this.upst2.restartT1Server();
            }
            this.isSuspendServer = false;
        } else {
            this.writeLog("Error: Proxy server not in suspended state, can't restart it.");
        }
    }

    public void runServer() throws UniProxyException {
        try {
            if (this.debugLevel > 0) {
                this.writeLog("Starting proxy server.");
            }
            this.upst1 = new UniProxyServerT1(this.proxyConfiguration.getPort(), this, this.clientThreadGroup, false);
            if (this.proxyConfiguration.getProxySSLFlag() || this.proxyConfiguration.getProxySSLOnlyFlag()) {
                this.upst2 = new UniProxyServerT1(this.proxyConfiguration.getSSLPort(), this, this.clientThreadGroup, true);
            } else {
                if (this.debugLevel > 0) {
                    this.writeLog("Not starting ssl thread of proxy");
                }
                this.upst2 = null;
            }
            this.upst1.start();
            if (this.upst2 != null) {
                this.upst2.start();
            }
            this.adminServer = new UniProxyAdminServer(this);
            this.adminServer.start();
            this.waitMe();
        }
        catch (InterruptedException e) {
            this.writeLog("ProxyServer Interrupted Exception. Exiting " + e.getMessage());
        }
        try {
            this.shutdown();
            this.adminServer.stop();
            this.adminServer.join(2000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfiguration(UniProxyConfiguration aProxyConfiguration) throws UniProxyException {
        UniProxyConfiguration uniProxyConfiguration = this.proxyConfiguration;
        synchronized (uniProxyConfiguration) {
            this.proxyConfiguration = aProxyConfiguration;
            this.debugLevel = this.proxyConfiguration.getDebugLevel();
            this.maxConnections = this.proxyConfiguration.getMaxConnections();
            try {
                if (this.logFile != null) {
                    this.logFile.close();
                }
                this.logFile = new RandomAccessFile(String.valueOf(this.proxyConfiguration.getPathLog()) + this.proxyConfiguration.getNameLog(), "rw");
                long fileLength = this.logFile.length();
                this.logFile.seek(fileLength);
            }
            catch (IOException e) {
                throw new UniProxyException("Error: Failed to open new logging file:" + e.getMessage(), 10000);
            }
        }
    }

    public void shutdown() {
        if (this.debugLevel > 0) {
            this.writeLog("Shutting down proxy server.");
        }
        this.suspendServer();
        this.isShutdownServer = true;
        this.isSuspendServer = false;
        if (this.upst1 != null) {
            this.upst1.shutdown();
        }
        if (this.upst2 != null) {
            this.upst2.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownFast() {
        if (this.debugLevel > 0) {
            this.writeLog("Shutting down proxy server immediately.");
        }
        this.suspendServer();
        if (this.debugLevel > 5) {
            this.writeLog("Signal all open client connection threads to terminate.");
        }
        if (this.debugLevel > 5) {
            this.writeLog("Wait on all open client connection threads to finish.");
        }
        this.isShutdownServer = true;
        this.isSuspendServer = false;
        UniProxyServer uniProxyServer = this;
        synchronized (uniProxyServer) {
            this.notify();
        }
    }

    public boolean getisShutdown() {
        return this.isShutdownServer;
    }

    public boolean getisSuspended() {
        return this.isSuspendServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void status() {
        UniProxyConfiguration uniProxyConfiguration = this.proxyConfiguration;
        synchronized (uniProxyConfiguration) {
            if (this.debugLevel > -1) {
                this.writeLog("Dumping current status of proxy server to log file.");
                this.writeLog("   Updating the connection table.");
            }
            if (this.debugLevel <= 8) {
                this.writeLog("Connection Table Details:");
                this.writeLog("   Maximum available connections=" + this.maxConnections);
            }
            this.writeLog("   Connection List:");
            this.getConfiguration().dump(this);
        }
    }

    public void suspendServer() {
        if (this.debugLevel > 0) {
            this.writeLog("Suspending proxy server.");
        }
        this.isSuspendServer = true;
        if (this.upst1 != null) {
            this.upst1.SuspendT1Server();
        }
        if (this.upst2 != null) {
            this.upst2.SuspendT1Server();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLogRaw(String aLogEntry) {
        UniProxyConfiguration uniProxyConfiguration = this.proxyConfiguration;
        synchronized (uniProxyConfiguration) {
            if (this.logFile != null) {
                try {
                    this.logFile.writeBytes(String.valueOf(aLogEntry) + "\n");
                }
                catch (IOException e) {
                    System.out.println(aLogEntry);
                    System.out.println("UniProxyServer.writeLogRaw() failed:" + e.toString());
                }
            } else {
                System.out.println(aLogEntry);
            }
        }
    }

    protected void writeLog(String aLogEntry) {
        this.writeLogRaw(String.valueOf(this.logTime.format(new Date(System.currentTimeMillis()))) + "-S" + " " + aLogEntry);
    }

    private static void printUsage() {
        System.out.println("Usage: UniProxyServer -config=configuration file");
    }

    public synchronized void waitMe() throws InterruptedException {
        if (!this.waitForThreads) {
            this.waitForThreads = true;
            this.wait();
        }
    }

    public synchronized void notifyMe() throws InterruptedException {
        if (this.waitForThreads) {
            this.waitForThreads = false;
            this.notify();
        }
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }
}

