/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniproxy;

import asjava.uniproxy.UniConnectionDetails;
import asjava.uniproxy.UniProxyConfiguration;
import asjava.uniproxy.UniProxyException;
import asjava.uniproxy.UniProxySSLio;
import asjava.uniproxy.UniProxyServer;
import asjava.unirpc.UniRPCPProxyHeader;
import asjava.unirpc.UniRPCPacket;
import asjava.unirpc.UniRPCPacketException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class UniProxyConnection
extends Thread {
    private boolean isMultiplexed = false;
    private boolean isStopFast = false;
    private boolean inIOLoop = false;
    private boolean isExceedMaxSessions = false;
    private int debugLevel;
    private int networkTimeout;
    private byte[] buffer;
    private Socket clientSocket;
    private DataInputStream clientInStream;
    private DataOutputStream clientOutStream;
    private UniProxyServer proxyServer;
    private UniProxyConfiguration proxyConfiguration;
    private Hashtable serverConnectTable = new Hashtable();
    private SimpleDateFormat logTime;
    private static final int PROXY_HEADER = 0;
    private static final int NO_PROXY_HEADER = 1;
    private boolean sslFlag = false;
    private boolean waitForSSLThreads = false;
    private boolean externalSSLType = false;

    public UniProxyConnection(ThreadGroup aThreadGroup, UniProxyServer aServer, Socket aSocket, boolean externalSSLType) throws UniProxyException {
        super(aThreadGroup, "UniProxyConnection");
        if (aServer == null) {
            throw new UniProxyException("A valid UniProxyServer reference is required.", 10004);
        }
        if (aSocket == null) {
            throw new UniProxyException("A valid Socket reference is required.", 10004);
        }
        this.proxyServer = aServer;
        this.clientSocket = aSocket;
        this.proxyConfiguration = this.proxyServer.getConfiguration();
        this.debugLevel = this.proxyConfiguration.getDebugLevel();
        this.buffer = new byte[this.proxyConfiguration.getBufferSize()];
        this.networkTimeout = this.proxyConfiguration.getNetworkTimeout();
        this.logTime = new SimpleDateFormat("yy.MM.dd'-'HH.mm.ss");
        this.externalSSLType = externalSSLType;
    }

    public synchronized void waitMe() throws InterruptedException {
        if (!this.waitForSSLThreads) {
            this.waitForSSLThreads = true;
            this.wait();
        }
    }

    public synchronized void notifyMe() throws InterruptedException {
        if (this.waitForSSLThreads) {
            this.waitForSSLThreads = false;
            this.notify();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block32: {
            timeoutAccumulator = 0;
            if (this.debugLevel > 0) {
                this.writeLog("Running a client connection thread.");
            }
            try {
                proxyHeader = new UniRPCPProxyHeader();
                this.clientSocket.setSoLinger(true, this.networkTimeout);
                this.clientSocket.setTcpNoDelay(true);
                this.clientInStream = new DataInputStream(this.clientSocket.getInputStream());
                this.clientOutStream = new DataOutputStream(this.clientSocket.getOutputStream());
                conObject = new UniConnectionDetails();
                returnCode = this.addConnection(0, conObject);
                if (this.sslFlag && returnCode == 0) {
                    this.clientSocket.setSoTimeout(this.networkTimeout);
                    conObject.serverSocket.setSoTimeout(this.networkTimeout);
                    try {
                        io1 = new UniProxySSLio(this.clientInStream, conObject.serverOutStream, this, "client_thread");
                        io2 = new UniProxySSLio(conObject.serverInStream, this.clientOutStream, this, "server_thread");
                        io1.start();
                        io2.start();
                        this.waitMe();
                        if (this.debugLevel > 0) {
                            this.writeLog("One of SSL Thread finished Main Thread is Exiting");
                        }
                        break block32;
                    }
                    catch (InterruptedException v0) {
                        this.writeLog("Main SSL ThreaD Interrupted Exception. Exiting");
                    }
                    break block32;
                }
                if (this.sslFlag) break block32;
                if (this.debugLevel > 2 && returnCode == 0) {
                    this.writeLog("Entering packet pass-through mode.");
                }
                while (returnCode == 0) {
                    bytesToRead = 0;
                    bytesRead = 0;
                    if (this.isStopFast) break;
                    if (this.debugLevel > 6 && !this.inIOLoop) {
                        this.writeLog("Waiting on next client packet...");
                    }
                    try {
                        this.clientSocket.setSoTimeout(5000);
                        proxyHeader.receive(this.clientInStream);
                    }
                    catch (UniRPCPacketException e) {
                        if (e.getErrorCode() == 81015) {
                            this.inIOLoop = true;
                            if ((timeoutAccumulator += 5000) < this.networkTimeout) continue;
                            if (this.debugLevel > 4) {
                                this.writeLog("Client connection closed, proxy server network timeout.");
                            }
                        } else {
                            this.inIOLoop = false;
                            if (this.debugLevel > 4) {
                                this.writeLog("Client connection closed by the client.");
                            }
                        }
                        break;
                    }
                    this.inIOLoop = false;
                    timeoutAccumulator = 0;
                    this.clientSocket.setSoTimeout(this.networkTimeout);
                    connectionID = new Integer(proxyHeader.readConnection());
                    if (this.debugLevel > 6) {
                        this.writeLog("   Server connection ID=" + connectionID);
                    }
                    if ((connectionObject = (UniConnectionDetails)this.serverConnectTable.get(connectionID)) == null && connectionID == 0) {
                        if (this.debugLevel > 4) {
                            this.writeLog("   Multiplexing an additional server connection into");
                            this.writeLog("      the current client proxy connection.");
                        }
                        connectionObject = new UniConnectionDetails();
                        this.addConnection(1, connectionObject);
                        continue;
                    }
                    try {
                        if (proxyHeader.readHeaderType() != 10000) {
                            bytesToRead = proxyHeader.getLength();
                            while (bytesToRead > 0) {
                                bytesRead = bytesToRead < this.buffer.length ? bytesToRead : this.buffer.length;
                                this.clientInStream.readFully(this.buffer, 0, bytesRead);
                                connectionObject.serverOutStream.write(this.buffer, 0, bytesRead);
                                bytesToRead -= bytesRead;
                            }
                            if (this.debugLevel > 6) {
                                this.writeLog("   Finished forwarding client packet.");
                                this.writeLog("   Waiting on server packet...");
                            }
                        } else if (this.debugLevel > 6) {
                            this.writeLog("   Proxy spoofing header received from client.");
                            this.writeLog("   Waiting on server packet...");
                        }
                        connectionObject.serverInStream.readFully(this.buffer, 0, 24);
                        bytesToRead = ((this.buffer[4] & 255) << 24) + ((this.buffer[5] & 255) << 16) + ((this.buffer[6] & 255) << 8) + ((this.buffer[7] & 255) << 0);
                        proxyHeader.setLength(bytesToRead + 24);
                        bytesRead = bytesToRead < this.buffer.length - 24 ? bytesToRead : this.buffer.length - 24;
                        connectionObject.serverInStream.readFully(this.buffer, 24, bytesRead);
                        bytesToRead -= bytesRead;
                        proxyHeader.send(this.clientOutStream);
                        this.clientOutStream.write(this.buffer, 0, bytesRead + 24);
                        while (bytesToRead > 0) {
                            bytesRead = bytesToRead < this.buffer.length ? bytesToRead : this.buffer.length;
                            connectionObject.serverInStream.readFully(this.buffer, 0, bytesRead);
                            bytesToRead -= bytesRead;
                            this.clientOutStream.write(this.buffer, 0, bytesRead);
                        }
                        if (this.debugLevel <= 6) continue;
                        this.writeLog("   Finished forwarding server packet.");
                        continue;
                    }
                    catch (IOException e) {
                        this.writeLog("Error: Server side of client connection was dropped!:" + e.toString());
                        connectionObject.serverInStream.close();
                        connectionObject.serverOutStream.close();
                        connectionObject.serverSocket.close();
                        this.serverConnectTable.remove(connectionObject);
                        ** if (this.serverConnectTable.size() <= 0) goto lbl-1000
                    }
lbl-1000:
                    // 1 sources

                    {
                        continue;
                    }
lbl-1000:
                    // 1 sources

                    {
                        break;
                    }
                }
            }
            catch (IOException e) {
                this.writeLog("Error: " + e.toString());
            }
            catch (UniRPCPacketException e) {
                this.writeLog("Error: An error has occured during a data packet exchange:" + e.toString());
            }
        }
        try {
            enum1 = this.serverConnectTable.elements();
            while (enum1.hasMoreElements()) {
                serverConnTemp = (UniConnectionDetails)enum1.nextElement();
                serverConnTemp.serverInStream.close();
                serverConnTemp.serverOutStream.close();
                serverConnTemp.serverSocket.close();
            }
            this.serverConnectTable.clear();
            this.clientOutStream.close();
            this.clientInStream.close();
            this.clientSocket.close();
        }
        catch (IOException e) {
            this.writeLog(e.toString());
            this.writeLog("Error: failed to clean up connection when shutting down.");
        }
    }

    public void setExceedMaxSessions() {
        this.isExceedMaxSessions = true;
    }

    public void status() {
        Enumeration enum1 = this.serverConnectTable.elements();
        while (enum1.hasMoreElements()) {
            UniConnectionDetails item = (UniConnectionDetails)enum1.nextElement();
            this.writeLog("   ServerID:" + item.hashCode());
        }
    }

    public void stopFast() {
        this.isStopFast = true;
    }

    public void writeLog(String aLogEntry) {
        this.proxyServer.writeLogRaw(String.valueOf(this.logTime.format(new Date(System.currentTimeMillis()))) + "-C" + new Integer(this.hashCode()) + " " + aLogEntry);
    }

    public boolean getIsStopFast() {
        return this.isStopFast;
    }

    private int addConnection(int aFlag, UniConnectionDetails connectionObject) {
        int returnCode = 0;
        if (this.debugLevel > 4) {
            this.writeLog("Adding a new server connection.");
        }
        if ((returnCode = this.GetLoginPacketAndSetConnectionObject(aFlag, connectionObject)) != 0) {
            return returnCode;
        }
        if (this.sslFlag && aFlag == 1) {
            this.writeLog("We cannot come here since we are multiplexing with ssl connection ");
            return -1;
        }
        if (this.sslFlag && !this.proxyConfiguration.getProxySSLFlag()) {
            return 81001;
        }
        if (!this.sslFlag && !this.externalSSLType && this.proxyConfiguration.getProxySSLOnlyFlag()) {
            return 81001;
        }
        returnCode = this.AuthenticateClient(connectionObject);
        if (returnCode == 0) {
            if (this.isExceedMaxSessions && aFlag == 0) {
                returnCode = 83002;
            } else if (this.serverConnectTable.size() >= this.proxyConfiguration.getMaxMultiplexedServers() && aFlag == 1) {
                returnCode = 83003;
            }
        }
        Integer connectionIDObject = this.buildLoginReplyAndSend(connectionObject, returnCode);
        if (returnCode != 0) {
            return -1;
        }
        returnCode = this.establishServerConnection(connectionObject);
        if (returnCode != 0) {
            this.writeLog("   Error: Failed server connect to " + connectionObject.serverName);
            return -1;
        }
        this.serverConnectTable.put(connectionIDObject, connectionObject);
        if (this.debugLevel > 4) {
            this.writeLog("   New connection successfully completed!!!");
        }
        return 0;
    }

    private int GetLoginPacketAndSetConnectionObject(int aFlag, UniConnectionDetails connectionObject) {
        int returnCode = 0;
        if (this.debugLevel > 4) {
            this.writeLog("Adding a new server connection.");
        }
        UniRPCPacket loginPacketIn = new UniRPCPacket();
        if (aFlag == 0) {
            loginPacketIn.setProxyHeader(new UniRPCPProxyHeader());
        }
        try {
            if (this.debugLevel > 4) {
                this.writeLog("   receiving proxy login packet.");
            }
            loginPacketIn.receive(this.clientInStream);
            if (this.debugLevel > 6) {
                this.writeLog("   look at proxy login packet values.");
            }
            connectionObject.serverName = loginPacketIn.readString(0);
            connectionObject.serverPort = loginPacketIn.readInteger(1);
            connectionObject.accessToken = loginPacketIn.readString(2);
            int sslFlagInt = loginPacketIn.readInteger(3);
            if (sslFlagInt > 0) {
                this.sslFlag = true;
            }
        }
        catch (UniRPCPacketException e) {
            this.writeLog("   Error: addConnection() " + e.getMessage());
            returnCode = -1;
        }
        return returnCode;
    }

    private int AuthenticateClient(UniConnectionDetails connectionObject) {
        int returnCode = 0;
        try {
            returnCode = this.proxyConfiguration.authenticateClient(connectionObject.accessToken, connectionObject.serverName);
            if (returnCode == 0) {
                if (this.debugLevel > 4) {
                    this.writeLog("   Client successfully authenticated.");
                }
            } else {
                returnCode = 83001;
                this.writeLog("   Warning: Client authentication failed! Try another access token and server.");
            }
        }
        catch (UniProxyException e) {
            this.writeLog("   Error: addConnection() " + e.getMessage());
            returnCode = 83001;
        }
        return returnCode;
    }

    private Integer buildLoginReplyAndSend(UniConnectionDetails connectionObject, int returnCode) {
        UniRPCPacket loginPacketOut = new UniRPCPacket();
        loginPacketOut.setProxyHeader(new UniRPCPProxyHeader());
        Integer connectionIDObject = new Integer(connectionObject.hashCode());
        try {
            loginPacketOut.getProxyHeader().writeConnection(connectionIDObject.hashCode());
            loginPacketOut.write(0, returnCode);
            loginPacketOut.write(1, connectionIDObject.hashCode());
            loginPacketOut.send(this.clientOutStream, (byte)1, connectionIDObject.hashCode());
            if (this.debugLevel > 4) {
                this.writeLog("   Reply to proxy login packet sent.");
            }
        }
        catch (UniRPCPacketException e) {
            this.writeLog("   Error: " + e.getMessage());
            connectionIDObject = null;
        }
        return connectionIDObject;
    }

    private int establishServerConnection(UniConnectionDetails connectionObject) {
        InetAddress netAddress = this.proxyServer.lookupInetAddress(connectionObject.serverName);
        try {
            connectionObject.serverSocket = new Socket(netAddress, connectionObject.serverPort);
            connectionObject.serverSocket.setSoLinger(true, this.networkTimeout);
            connectionObject.serverSocket.setTcpNoDelay(true);
            connectionObject.serverOutStream = new DataOutputStream(connectionObject.serverSocket.getOutputStream());
            connectionObject.serverInStream = new DataInputStream(connectionObject.serverSocket.getInputStream());
            if (this.debugLevel > 4) {
                this.writeLog("   Connection to the requested server established!");
            }
        }
        catch (Exception exception) {
            return -1;
        }
        return 0;
    }
}

