/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniproxy;

import asjava.uniproxy.UniProxyException;
import asjava.uniproxy.UniProxyServer;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Vector;

public class UniProxyConfiguration {
    private int bufferSize = 4096;
    private int debugLevel = 0;
    private int maxConnections = 128;
    private int maxMultiplexedServers = 4;
    private int networkTimeout = 300000;
    private String configLocation = "uniproxy.config";
    private String logFilePath = "";
    private String logFileName = "";
    private int serverPort = 31448;
    private boolean proxySSLFlag = false;
    private boolean proxySSLOnlyFlag = false;
    private int serverSSLPort = 31452;
    private String proxySSLKeyFile = "testkeys";
    private String proxySSLKeyFilePwd = "new.pass";
    private String proxySSLTrustFile = "testtrust";
    private boolean proxySSLClientAuthentication = false;
    private String kstype = "JKS";
    private String tstype = "JKS";
    private String pwdmethod = "INTERACTIVE";
    private int adminPort = 31458;
    private String adminAccessToken = "";
    private Vector accessServer = new Vector();
    private Object[][] accessTokenServer = new Object[0][0];

    public int authenticateAdmin(String aAdminAccessToken) throws UniProxyException {
        if (this.adminAccessToken.equals(aAdminAccessToken)) {
            return 0;
        }
        return -1;
    }

    public int authenticateClient(String aAccessToken, String aServer) throws UniProxyException {
        int result = -1;
        boolean isServerAuth = true;
        if (this.accessTokenServer.length == 0 && this.accessServer.size() == 0) {
            return 0;
        }
        if (aAccessToken != null) {
            int i = 0;
            while (i < this.accessTokenServer.length) {
                if (((String)this.accessTokenServer[i][0]).equals(aAccessToken)) {
                    result = 0;
                    if (((Vector)this.accessTokenServer[i][1]).size() <= 0) break;
                    result = ((Vector)this.accessTokenServer[i][1]).contains(aServer) ? 0 : -1;
                    isServerAuth = false;
                    break;
                }
                ++i;
            }
        }
        if (aServer != null && result == 0 && isServerAuth) {
            result = this.accessServer.size() == 0 || this.accessServer.contains(aServer) ? 0 : -1;
        }
        return result;
    }

    public void dump(UniProxyServer aServer) {
        if (aServer != null) {
            aServer.writeLog("Proxy server configuration:");
            aServer.writeLog("   Configuration Path:" + this.configLocation);
            aServer.writeLog("   ACCESS_TOKEN_SERVER=");
            int i = 0;
            while (i < this.accessTokenServer.length) {
                aServer.writeLog("      Token:" + (String)this.accessTokenServer[i][0] + " Server:" + (Vector)this.accessTokenServer[i][1]);
                ++i;
            }
            aServer.writeLog("   ACCESS_SERVER=" + this.accessServer);
            aServer.writeLog("   ADMIN_ACCESS_TOKEN=" + this.adminAccessToken);
            aServer.writeLog("   ADMIN_PORT=" + this.adminPort);
            aServer.writeLog("   BUFFER_SIZE=" + this.bufferSize);
            aServer.writeLog("   DEBUG_LEVEL=" + this.debugLevel);
            aServer.writeLog("   KEYSTORE_TYPE = " + this.kstype);
            aServer.writeLog("   MAX_CONNECTIONS=" + this.maxConnections);
            aServer.writeLog("   MAX_MULTIPLEXED_SERVERS=" + this.maxMultiplexedServers);
            aServer.writeLog("   NAME_LOG=" + this.logFileName);
            aServer.writeLog("   NETWORK_TIMEOUT=" + this.networkTimeout);
            aServer.writeLog("   PATH_LOG=" + this.logFilePath);
            aServer.writeLog("   PROXY_PORT=" + this.serverPort);
            aServer.writeLog("   PROXY_SSL_FLAG=" + this.proxySSLFlag);
            aServer.writeLog("   PROXY_SSL_PORT=" + this.serverSSLPort);
            aServer.writeLog("   SSL_KEY_FILE=" + this.proxySSLKeyFile);
            aServer.writeLog("   SSL_TRUST_FILE= " + this.proxySSLTrustFile);
            aServer.writeLog("   SSL_CLIENT_AUTHENTICATION = " + this.proxySSLClientAuthentication);
            aServer.writeLog("   TRUSTSTORE_TYPE = " + this.tstype);
            aServer.writeLog("   PWD_METHOD = " + this.pwdmethod);
        } else {
            System.out.println("A null UniProxyServer reference was passed into UniProxyConfiguration.dump().");
        }
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public String getAdminAccessToken() {
        return this.adminAccessToken;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMaxMultiplexedServers() {
        return this.maxMultiplexedServers;
    }

    public String getLocation() {
        return this.configLocation;
    }

    public String getNameLog() {
        return this.logFileName;
    }

    public int getNetworkTimeout() {
        return this.networkTimeout;
    }

    public String getPathLog() {
        return this.logFilePath;
    }

    public int getPort() {
        return this.serverPort;
    }

    public boolean getProxySSLFlag() {
        return this.proxySSLFlag;
    }

    public boolean getProxySSLOnlyFlag() {
        return this.proxySSLOnlyFlag;
    }

    public int getSSLPort() {
        return this.serverSSLPort;
    }

    public String getProxySSLKeyFile() {
        return this.proxySSLKeyFile;
    }

    public String getProxySSLKeyFilePwd() {
        return this.proxySSLKeyFilePwd;
    }

    public String getProxySSLTrustFile() {
        return this.proxySSLTrustFile;
    }

    public boolean getProxySSLClientAuthentication() {
        return this.proxySSLClientAuthentication;
    }

    public String getProxyKeystoreType() {
        return this.kstype;
    }

    public String getProxyTruststoreType() {
        return this.tstype;
    }

    public String getProxyPwdMethod() {
        return this.pwdmethod;
    }

    public void load() throws UniProxyException {
        StreamTokenizer parser;
        try {
            FileReader configIOStream = new FileReader(this.configLocation);
            parser = new StreamTokenizer(configIOStream);
        }
        catch (FileNotFoundException e) {
            throw new UniProxyException(e.toString(), 10001);
        }
        catch (IOException e) {
            throw new UniProxyException(e.toString(), 10001);
        }
        parser.commentChar(35);
        parser.slashSlashComments(false);
        parser.slashStarComments(false);
        parser.whitespaceChars(61, 61);
        parser.quoteChar(34);
        parser.wordChars(46, 46);
        parser.wordChars(92, 92);
        parser.wordChars(47, 47);
        parser.wordChars(58, 58);
        parser.wordChars(95, 95);
        try {
            int status = parser.nextToken();
            while (status != -1) {
                String tmpstr;
                if (parser.ttype != -3) {
                    throw new UniProxyException("Parsed a number when a word was expected.", 1);
                }
                String tokenName = parser.sval;
                if (tokenName.equals("ACCESS_TOKEN")) {
                    status = parser.nextToken();
                    Object[][] newAccessTokenServer = new Object[this.accessTokenServer.length + 1][2];
                    System.arraycopy(this.accessTokenServer, 0, newAccessTokenServer, 0, this.accessTokenServer.length);
                    this.accessTokenServer = newAccessTokenServer;
                    if (parser.ttype == -3) {
                        this.accessTokenServer[this.accessTokenServer.length - 1][0] = new String(parser.sval);
                        this.accessTokenServer[this.accessTokenServer.length - 1][1] = new Vector();
                    } else {
                        this.accessTokenServer[this.accessTokenServer.length - 1][0] = new String(Double.toString(parser.nval));
                        this.accessTokenServer[this.accessTokenServer.length - 1][1] = new Vector();
                    }
                } else if (tokenName.equals("ACCESS_TOKEN_SERVER")) {
                    status = parser.nextToken();
                    if (this.accessTokenServer.length > 0) {
                        if (parser.ttype == -3) {
                            ((Vector)this.accessTokenServer[this.accessTokenServer.length - 1][1]).addElement(parser.sval);
                        } else {
                            ((Vector)this.accessTokenServer[this.accessTokenServer.length - 1][1]).addElement(Double.toString(parser.nval));
                        }
                    }
                } else if (tokenName.equals("ACCESS_SERVER")) {
                    status = parser.nextToken();
                    if (parser.ttype == -3) {
                        this.accessServer.addElement(parser.sval);
                    } else {
                        this.accessServer.addElement(Double.toString(parser.nval));
                    }
                } else if (tokenName.equals("ADMIN_ACCESS_TOKEN")) {
                    status = parser.nextToken();
                    this.adminAccessToken = parser.ttype == -3 ? parser.sval : Double.toString(parser.nval);
                } else if (tokenName.equals("ADMIN_PORT")) {
                    status = parser.nextToken();
                    this.adminPort = new Integer((int)parser.nval);
                } else if (tokenName.equals("BUFFER_SIZE")) {
                    status = parser.nextToken();
                    int j = new Integer((int)parser.nval);
                    this.bufferSize = j >= 4096 ? j : 4096;
                } else if (tokenName.equals("DEBUG_LEVEL")) {
                    status = parser.nextToken();
                    int j = new Integer((int)parser.nval);
                    this.debugLevel = j >= 0 && j <= 9 ? j : 0;
                } else if (tokenName.equals("MAX_CONNECTIONS")) {
                    status = parser.nextToken();
                    this.maxConnections = new Integer((int)parser.nval);
                } else if (tokenName.equals("MAX_MULTIPLEXED_SERVERS")) {
                    status = parser.nextToken();
                    this.maxMultiplexedServers = new Integer((int)parser.nval);
                } else if (tokenName.equals("NAME_LOG")) {
                    status = parser.nextToken();
                    this.logFileName = parser.ttype == -3 ? parser.sval : Double.toString(parser.nval);
                } else if (tokenName.equals("NETWORK_TIMEOUT")) {
                    status = parser.nextToken();
                    this.networkTimeout = new Integer((int)parser.nval);
                } else if (tokenName.equals("PATH_LOG")) {
                    status = parser.nextToken();
                    this.logFilePath = parser.sval;
                } else if (tokenName.equals("PROXY_PORT")) {
                    status = parser.nextToken();
                    this.serverPort = new Integer((int)parser.nval);
                } else if (tokenName.equals("PROXY_SSL_FLAG")) {
                    status = parser.nextToken();
                    tmpstr = parser.ttype == -3 ? parser.sval : Double.toString(parser.nval);
                    this.proxySSLFlag = tmpstr.equals("true");
                } else if (tokenName.equals("PROXY_SSL_ONLY_FLAG")) {
                    status = parser.nextToken();
                    tmpstr = parser.ttype == -3 ? parser.sval : Double.toString(parser.nval);
                    this.proxySSLOnlyFlag = tmpstr.equals("true");
                } else if (tokenName.equals("PROXY_SSL_PORT")) {
                    status = parser.nextToken();
                    this.serverSSLPort = new Integer((int)parser.nval);
                } else if (tokenName.equals("SSL_KEY_FILE")) {
                    status = parser.nextToken();
                    this.proxySSLKeyFile = parser.ttype == -3 ? parser.sval : Double.toString(parser.nval);
                } else if (tokenName.equals("SSL_KEY_FILE_PWD")) {
                    status = parser.nextToken();
                    this.proxySSLKeyFilePwd = parser.ttype == -3 ? parser.sval : Double.toString(parser.nval);
                } else if (tokenName.equals("SSL_TRUST_FILE")) {
                    status = parser.nextToken();
                    this.proxySSLTrustFile = parser.ttype == -3 ? parser.sval : Double.toString(parser.nval);
                } else if (tokenName.equals("SSL_CLIENT_AUTHENTICATION")) {
                    status = parser.nextToken();
                    tmpstr = parser.ttype == -3 ? parser.sval : Double.toString(parser.nval);
                    this.proxySSLClientAuthentication = tmpstr.equals("true");
                } else if (tokenName.equals("SSL_KEY_FILE_TYPE")) {
                    status = parser.nextToken();
                    this.kstype = parser.ttype == -3 ? parser.sval : Double.toString(parser.nval);
                } else if (tokenName.equals("SSL_TRUST_FILE_TYPE")) {
                    status = parser.nextToken();
                    this.tstype = parser.ttype == -3 ? parser.sval : Double.toString(parser.nval);
                } else if (tokenName.equals("SSL_PWD_METHOD")) {
                    status = parser.nextToken();
                    this.pwdmethod = parser.ttype == -3 ? parser.sval : Double.toString(parser.nval);
                }
                if (status != -1) {
                    status = parser.nextToken();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new UniProxyException(e.toString(), 10001);
        }
        catch (NullPointerException nullPointerException) {
            throw new UniProxyException("proxy server configuration file formatted incorrectly.", 10001);
        }
    }

    public void setLocation(String aLocation) {
        this.configLocation = aLocation;
    }
}

