/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniproxy;

import asjava.uniproxy.UniProxyException;
import asjava.uniproxy.UniProxyServer;
import asjava.unirpc.UniRPCPacket;
import asjava.unirpc.UniRPCPacketException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;

public class UniProxyAdminServer
extends Thread {
    private boolean isShutdown = false;
    private int debugLevel;
    private SimpleDateFormat logTime;
    private UniProxyServer proxyServer;
    private Socket proxyAdminClient;
    private DataOutputStream proxyAdminDataOut;
    private DataInputStream proxyAdminDataIn;
    private UniRPCPacket outPacket;
    private UniRPCPacket inPacket;
    private int adminListenPort = -1;
    private int currentTimeoutSeconds = 0;
    private int currentCommandCode = 0;
    private String currentCommandText = "";

    private UniProxyAdminServer() {
    }

    public UniProxyAdminServer(UniProxyServer aProxyServer) throws UniProxyException {
        if (aProxyServer == null) {
            throw new UniProxyException("A valid UniProxyServer reference is required.", 10004);
        }
        this.proxyServer = aProxyServer;
        this.debugLevel = this.proxyServer.getConfiguration().getDebugLevel();
        this.adminListenPort = this.proxyServer.getConfiguration().getAdminPort();
        this.logTime = new SimpleDateFormat("yy.MM.dd-HH.mm.ss");
    }

    public void connectAdminClient(Socket aSocket) throws UniProxyException {
        if (this.debugLevel > 2) {
            this.writeLog("Connecting to proxy admin client...");
        }
        try {
            this.proxyAdminClient = aSocket;
            this.proxyAdminClient.setSoTimeout(this.currentTimeoutSeconds * 1000);
            this.proxyAdminClient.setSoLinger(false, -1);
            this.proxyAdminClient.setTcpNoDelay(true);
            this.proxyAdminDataOut = new DataOutputStream(this.proxyAdminClient.getOutputStream());
            this.proxyAdminDataIn = new DataInputStream(this.proxyAdminClient.getInputStream());
        }
        catch (Exception e) {
            throw new UniProxyException(e.getMessage(), 10002);
        }
    }

    public void disconnectAdminClient() throws UniProxyException {
        if (this.debugLevel > 2) {
            this.writeLog("Disconnecting from proxy admin client...");
        }
        try {
            if (this.proxyAdminDataOut != null) {
                this.proxyAdminDataOut.close();
                this.proxyAdminDataOut = null;
            }
            if (this.proxyAdminDataIn != null) {
                this.proxyAdminDataIn.close();
                this.proxyAdminDataIn = null;
            }
            if (this.proxyAdminClient != null) {
                this.proxyAdminClient.close();
                this.proxyAdminClient = null;
            }
        }
        catch (IOException e) {
            throw new UniProxyException(e.toString(), 10002);
        }
    }

    public int getPort() {
        return this.adminListenPort;
    }

    public void processCommand() throws UniProxyException {
        if (this.debugLevel > 2) {
            this.writeLog("Processing the current administrative command.");
        }
        this.outPacket = new UniRPCPacket();
        this.inPacket = new UniRPCPacket();
        try {
            this.inPacket.receive(this.proxyAdminDataIn);
            int resultVer = this.verifyVersion(this.inPacket.readInteger(0));
            int resultAuth = this.proxyServer.getConfiguration().authenticateAdmin(this.inPacket.readString(1));
            if (resultAuth == 0 && resultVer == 0) {
                this.currentCommandCode = this.inPacket.readInteger(2);
                this.currentCommandText = this.inPacket.readString(3);
                try {
                    switch (this.currentCommandCode) {
                        case 2: {
                            this.proxyServer.suspendServer();
                            break;
                        }
                        case 3: {
                            this.proxyServer.restart();
                            break;
                        }
                        case 4: {
                            this.proxyServer.shutdown();
                            this.isShutdown = true;
                            break;
                        }
                        case 5: {
                            this.proxyServer.shutdownFast();
                            this.isShutdown = true;
                            break;
                        }
                        case 6: {
                            this.proxyServer.reconfigure();
                            break;
                        }
                        case 7: {
                            this.proxyServer.status();
                            break;
                        }
                        default: {
                            throw new UniProxyException("This administrative command is not supported", 10003);
                        }
                    }
                    this.outPacket.write(0, 0);
                }
                catch (UniProxyException e) {
                    this.outPacket.write(0, e.getErrorCode());
                    this.outPacket.write(1, e.getMessage());
                }
            } else if (resultVer != 0) {
                this.outPacket.write(0, 83000);
                this.outPacket.write(1, "Unsupported proxy administration client version!");
                this.writeLog("Error: Unsupported proxy administration client version!");
            } else {
                this.outPacket.write(0, 83000);
                this.outPacket.write(1, "Invalid proxy administration access token!");
                this.writeLog("Error: Invalid proxy administration access token!");
            }
            this.outPacket.send(this.proxyAdminDataOut, (byte)0, 0);
        }
        catch (UniRPCPacketException e) {
            throw new UniProxyException(e.getMessage(), e.getErrorCode());
        }
    }

    @Override
    public void run() {
        try {
            if (this.debugLevel > 2) {
                this.writeLog("Starting proxy admin server.");
            }
            ServerSocket adminServer = new ServerSocket(this.adminListenPort);
            if (this.debugLevel > 4) {
                this.writeLog("Accepting proxy admin connections on port " + adminServer.getLocalPort());
            }
            while (!this.isShutdown) {
                this.connectAdminClient(adminServer.accept());
                this.processCommand();
                this.disconnectAdminClient();
                if (this.currentCommandCode != 1) continue;
                this.writeLog("***I was wondering if the code path went here!!!");
                break;
            }
            try {
                adminServer.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            this.writeLog(e.toString());
            this.writeLog("Proxy admin server exception! All administrative features disabled!");
            this.writeLog("Shutting down proxy server!!!");
            this.proxyServer.shutdown();
        }
        catch (UniProxyException e) {
            this.writeLog(e.getMessage());
            this.writeLog("Proxy admin server exception! All administrative features disabled!");
            this.writeLog("Shutting down proxy server!!!");
            this.proxyServer.shutdown();
        }
    }

    public void setPort(int aPort) {
        this.adminListenPort = aPort;
    }

    public int verifyVersion(int aVersion) {
        if (aVersion > 1) {
            return -1;
        }
        return 0;
    }

    public void writeLog(String aLogEntry) {
        this.proxyServer.writeLogRaw(String.valueOf(this.logTime.format(new Date(System.currentTimeMillis()))) + "-A" + " " + aLogEntry);
    }
}

