/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniproxy;

import asjava.uniproxy.UniProxyConfiguration;
import asjava.uniproxy.UniProxyException;
import asjava.unirpc.UniRPCPacket;
import asjava.unirpc.UniRPCPacketException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;

public class UniProxyAdminClient {
    private PrintWriter debugWriter = System.out != null ? new PrintWriter(System.out, true) : null;
    private Socket proxyAdminConnection;
    private UniRPCPacket outPacket;
    private UniRPCPacket inPacket;
    private DataOutputStream proxyAdminDataOut;
    private DataInputStream proxyAdminDataIn;
    private int currentTimeoutSeconds = 0;
    private static String currentAccessToken = "";
    private static String currentCommandText = "";
    private static int currentCommand = 0;
    private static String currentConfigLocation = "";
    private static int currentPort = 0;
    private static String currentServer = "";

    public static void main(String[] args) {
        UniProxyAdminClient.parseCommandLine(args);
        UniProxyAdminClient adminClient = new UniProxyAdminClient();
        try {
            if (currentCommand == 1) {
                adminClient.startProxy();
            } else {
                adminClient.connectProxy();
                switch (currentCommand) {
                    case 2: {
                        adminClient.suspendProxy();
                        break;
                    }
                    case 3: {
                        adminClient.restartProxy();
                        break;
                    }
                    case 4: {
                        adminClient.shutdownProxy();
                        break;
                    }
                    case 5: {
                        adminClient.shutdownProxyFast();
                        break;
                    }
                    case 6: {
                        adminClient.reconfigureProxy();
                        break;
                    }
                    case 7: {
                        adminClient.statusProxy();
                        break;
                    }
                }
                adminClient.disconnectProxy();
            }
        }
        catch (UniProxyException e) {
            System.out.println(e.getMessage());
            System.exit(0);
        }
    }

    public void connectProxy() throws UniProxyException {
        this.debugWriter.println("Connecting to proxy admin server.");
        try {
            this.proxyAdminConnection = new Socket(currentServer, currentPort);
            this.proxyAdminConnection.setSoTimeout(this.currentTimeoutSeconds * 1000);
            this.proxyAdminConnection.setSoLinger(false, -1);
            this.proxyAdminConnection.setTcpNoDelay(true);
            this.proxyAdminDataOut = new DataOutputStream(this.proxyAdminConnection.getOutputStream());
            this.proxyAdminDataIn = new DataInputStream(this.proxyAdminConnection.getInputStream());
        }
        catch (IOException e) {
            throw new UniProxyException(e.toString(), 10002);
        }
    }

    public void disconnectProxy() throws UniProxyException {
        this.debugWriter.println("Disconnecting from proxy adminserver.");
        try {
            this.proxyAdminDataOut.close();
            this.proxyAdminDataOut = null;
            this.proxyAdminDataIn.close();
            this.proxyAdminDataIn = null;
            this.proxyAdminConnection.close();
            this.proxyAdminConnection = null;
        }
        catch (IOException e) {
            throw new UniProxyException(e.toString(), 10002);
        }
    }

    public PrintWriter getDebugWriter() {
        return this.debugWriter;
    }

    public void reconfigureProxy() throws UniProxyException {
        this.debugWriter.println("Reconfiguring proxy server...");
        this.outPacket = new UniRPCPacket();
        this.inPacket = new UniRPCPacket();
        try {
            this.outPacket.write(0, 1);
            this.outPacket.write(1, currentAccessToken);
            this.outPacket.write(2, currentCommand);
            this.outPacket.write(3, currentCommandText);
            this.outPacket.send(this.proxyAdminDataOut, (byte)0, 0);
            this.inPacket.receive(this.proxyAdminDataIn);
            if (this.inPacket.readInteger(0) == 0) {
                this.debugWriter.println("Proxy server successfully reconfigured.");
            } else {
                this.debugWriter.println("Command Failed!!!");
                this.debugWriter.println("   " + this.inPacket.readString(1));
            }
        }
        catch (UniRPCPacketException e) {
            throw new UniProxyException(e.getMessage(), e.getErrorCode());
        }
    }

    public void restartProxy() throws UniProxyException {
        this.debugWriter.println("Restarting proxy server...");
        this.outPacket = new UniRPCPacket();
        this.inPacket = new UniRPCPacket();
        try {
            this.outPacket.write(0, 1);
            this.outPacket.write(1, currentAccessToken);
            this.outPacket.write(2, currentCommand);
            this.outPacket.write(3, currentCommandText);
            this.outPacket.send(this.proxyAdminDataOut, (byte)0, 0);
            this.inPacket.receive(this.proxyAdminDataIn);
            if (this.inPacket.readInteger(0) == 0) {
                this.debugWriter.println("Proxy server successfully restarted.");
            } else {
                this.debugWriter.println("Command Failed!!!");
                this.debugWriter.println("   " + this.inPacket.readString(1));
            }
        }
        catch (UniRPCPacketException e) {
            throw new UniProxyException(e.getMessage(), e.getErrorCode());
        }
    }

    public void setDebugWriter(PrintStream aPrintStream) {
        this.debugWriter = new PrintWriter(aPrintStream, true);
    }

    public void setDebugWriter(FileOutputStream aFileStream) {
        this.debugWriter = new PrintWriter(aFileStream, true);
    }

    public void setDebugWriter(Writer aWriter) {
        this.debugWriter = new PrintWriter(aWriter, true);
    }

    public void shutdownProxy() throws UniProxyException {
        this.debugWriter.println("Shutting down proxy server...");
        this.outPacket = new UniRPCPacket();
        this.inPacket = new UniRPCPacket();
        try {
            this.outPacket.write(0, 1);
            this.outPacket.write(1, currentAccessToken);
            this.outPacket.write(2, currentCommand);
            this.outPacket.write(3, currentCommandText);
            this.outPacket.send(this.proxyAdminDataOut, (byte)0, 0);
            this.inPacket.receive(this.proxyAdminDataIn);
            if (this.inPacket.readInteger(0) == 0) {
                this.debugWriter.println("Proxy server completing shutdown.");
            } else {
                this.debugWriter.println("Command Failed!!!");
                this.debugWriter.println("   " + this.inPacket.readString(1));
            }
        }
        catch (UniRPCPacketException e) {
            throw new UniProxyException(e.getMessage(), e.getErrorCode());
        }
    }

    public void shutdownProxyFast() throws UniProxyException {
        this.debugWriter.println("Shutting down proxy server immediately...");
        this.outPacket = new UniRPCPacket();
        this.inPacket = new UniRPCPacket();
        try {
            this.outPacket.write(0, 1);
            this.outPacket.write(1, currentAccessToken);
            this.outPacket.write(2, currentCommand);
            this.outPacket.write(3, currentCommandText);
            this.outPacket.send(this.proxyAdminDataOut, (byte)0, 0);
            this.inPacket.receive(this.proxyAdminDataIn);
            if (this.inPacket.readInteger(0) == 0) {
                this.debugWriter.println("Proxy server completing shutdown.");
            } else {
                this.debugWriter.println("Command Failed!!!");
                this.debugWriter.println("   " + this.inPacket.readString(1));
            }
        }
        catch (UniRPCPacketException e) {
            throw new UniProxyException(e.getMessage(), e.getErrorCode());
        }
    }

    public void startProxy() throws UniProxyException {
        this.debugWriter.println("Starting proxy server...");
        UniProxyConfiguration proxyConfiguration = new UniProxyConfiguration();
        try {
            proxyConfiguration.setLocation(currentConfigLocation);
            proxyConfiguration.load();
            int result = proxyConfiguration.authenticateAdmin(currentAccessToken);
            if (result == 0) {
                Runtime.getRuntime().exec("java asjava.uniproxy.UniProxyServer -config=" + currentConfigLocation);
                this.debugWriter.println("Proxy server started.");
            } else {
                this.debugWriter.println("Error: Proxy server administration authentication failed.");
            }
        }
        catch (UniProxyException e) {
            this.debugWriter.println("Error: failed to load Proxy server configuration:" + e.getMessage());
            System.exit(0);
        }
        catch (IOException e) {
            this.debugWriter.println("Error: failed to launch the Proxy server process:" + e.toString());
            System.exit(0);
        }
    }

    public void statusProxy() throws UniProxyException {
        this.debugWriter.println("Dumping status of proxy server to log file...");
        this.outPacket = new UniRPCPacket();
        this.inPacket = new UniRPCPacket();
        try {
            this.outPacket.write(0, 1);
            this.outPacket.write(1, currentAccessToken);
            this.outPacket.write(2, currentCommand);
            this.outPacket.write(3, currentCommandText);
            this.outPacket.send(this.proxyAdminDataOut, (byte)0, 0);
            this.inPacket.receive(this.proxyAdminDataIn);
            if (this.inPacket.readInteger(0) == 0) {
                this.debugWriter.println("Proxy server status successfully output.");
            } else {
                this.debugWriter.println("Command Failed!!!");
                this.debugWriter.println("   " + this.inPacket.readString(1));
            }
        }
        catch (UniRPCPacketException e) {
            throw new UniProxyException(e.getMessage(), e.getErrorCode());
        }
    }

    public void suspendProxy() throws UniProxyException {
        this.debugWriter.println("Suspending proxy server...");
        this.outPacket = new UniRPCPacket();
        this.inPacket = new UniRPCPacket();
        try {
            this.outPacket.write(0, 1);
            this.outPacket.write(1, currentAccessToken);
            this.outPacket.write(2, currentCommand);
            this.outPacket.write(3, currentCommandText);
            this.outPacket.send(this.proxyAdminDataOut, (byte)0, 0);
            this.inPacket.receive(this.proxyAdminDataIn);
            if (this.inPacket.readInteger(0) == 0) {
                this.debugWriter.println("Proxy server successfully suspended.");
            } else {
                this.debugWriter.println("Command Failed!!!");
                this.debugWriter.println("   " + this.inPacket.readString(1));
            }
        }
        catch (UniRPCPacketException e) {
            throw new UniProxyException(e.getMessage(), e.getErrorCode());
        }
    }

    private static void parseCommandLine(String[] args) {
        boolean gotConfig = false;
        boolean gotPort = false;
        currentServer = "localhost";
        currentPort = 31458;
        currentConfigLocation = "";
        currentAccessToken = "";
        currentCommandText = "";
        currentCommand = 0;
        try {
            int i = 0;
            while (i < args.length) {
                if (args[i].toLowerCase().startsWith("-config=")) {
                    gotConfig = true;
                    currentConfigLocation = args[i].substring(8);
                } else if (args[i].toLowerCase().startsWith("-port=")) {
                    gotPort = true;
                    currentPort = Integer.valueOf(args[i].substring(6));
                } else if (args[i].toLowerCase().startsWith("-server=")) {
                    currentServer = args[i].substring(8);
                } else if (args[i].toLowerCase().startsWith("-access_token=")) {
                    currentAccessToken = args[i].substring(14);
                } else if (args[i].toLowerCase().startsWith("-command=")) {
                    currentCommandText = args[i].substring(9).toLowerCase();
                    if (currentCommandText.equals("suspend")) {
                        currentCommand = 2;
                    } else if (currentCommandText.equals("start")) {
                        currentCommand = 1;
                    } else if (currentCommandText.equals("shutdown")) {
                        currentCommand = 4;
                    } else if (currentCommandText.equals("shutdown:fast")) {
                        currentCommand = 5;
                    } else if (currentCommandText.equals("restart")) {
                        currentCommand = 3;
                    } else if (currentCommandText.equals("reconfigure")) {
                        currentCommand = 6;
                    } else if (currentCommandText.equals("status")) {
                        currentCommand = 7;
                    } else {
                        System.out.println("Error: Unsupported command: " + args[i]);
                        UniProxyAdminClient.printUsage();
                        System.exit(0);
                    }
                } else if (args[i].toLowerCase().startsWith("-help")) {
                    UniProxyAdminClient.printUsage();
                    System.exit(0);
                } else {
                    System.out.println("Error: Unsupported option: " + args[i]);
                    UniProxyAdminClient.printUsage();
                    System.exit(0);
                }
                ++i;
            }
            if (gotConfig && currentCommand != 1 || gotPort && gotConfig || !gotPort && !gotConfig || !gotConfig && currentCommand == 1) {
                System.out.println("Error: Invalid combination of -port, -config and -command.");
                UniProxyAdminClient.printUsage();
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            UniProxyAdminClient.printUsage();
            System.exit(0);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: UniProxyAdminClient -config=configPath -command=start [-access_token=xxxxxx]");
        System.out.println("       UniProxyAdminClient -port=xxxxx -command=xxxxxx [-server=xxxxxx] [-access_token=xxxxxx]");
        System.out.println("       UniProxyAdminClient -help");
        System.out.println();
        System.out.println("Currently supported commands are:");
        System.out.println("   start, suspend, restart, shutdown, shutdown:fast, reconfigure, status");
    }
}

