/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniobjects;

import asjava.uniclientlibs.UniConnection;
import asjava.uniclientlibs.UniDataSet;
import asjava.uniclientlibs.UniDynArray;
import asjava.uniclientlibs.UniString;
import asjava.uniobjects.UniBase;
import asjava.uniobjects.UniCommand;
import asjava.uniobjects.UniCommandException;
import asjava.uniobjects.UniDictionary;
import asjava.uniobjects.UniFile;
import asjava.uniobjects.UniSelectListException;
import asjava.uniobjects.UniSession;
import asjava.unirpc.UniRPCException;
import asjava.unirpc.UniRPCPacket;
import asjava.unirpc.UniRPCPacketException;

public class UniSelectList
extends UniBase {
    private final String emptyString = new String("");
    private String uniListName = new String("");
    private int uniSelectListNumber = -1;
    private int uniReturnCode = 0;
    private int numberOfSelectListItems = 0;
    private boolean bLastRecordRead = false;
    private boolean bIsSelectListActive = false;

    public UniSelectList() throws UniSelectListException {
        throw new UniSelectListException(88889);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniSelectList(UniSession aSession, int aSelectListNumber) throws UniSelectListException {
        UniSelectList uniSelectList = this;
        synchronized (uniSelectList) {
            if (aSession == null) {
                throw new UniSelectListException(39120);
            }
            if (aSelectListNumber < 0 || aSelectListNumber > 10) {
                throw new UniSelectListException("Select List Number must be between 0 and 10", 14022);
            }
            this.uniParentSession = aSession;
            this.uniConnection = this.uniParentSession.connection;
            this.uniSelectListNumber = aSelectListNumber;
            this.uniEncryptionType = aSession.getDefaultEncryptionType();
            this.bLastRecordRead = false;
            this.bIsSelectListActive = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearList() throws UniSelectListException {
        UniSelectList uniSelectList = this;
        synchronized (uniSelectList) {
            this.checkEntryConditions();
            try {
                this.outPacket.write(0, 4);
                this.outPacket.write(1, this.uniSelectListNumber);
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    throw new UniSelectListException(this.uniReturnCode);
                }
                this.bLastRecordRead = true;
                this.numberOfSelectListItems = 0;
            }
            catch (UniRPCException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniSelectListException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formList(Object aString) throws UniSelectListException {
        UniSelectList uniSelectList = this;
        synchronized (uniSelectList) {
            this.checkEntryConditions();
            if (aString.equals("")) {
                return;
            }
            try {
                this.outPacket.write(0, 23);
                this.outPacket.write(1, this.uniSelectListNumber);
                if (UniString.class.isInstance(aString)) {
                    this.outPacket.write(2, ((UniString)aString).getBytes());
                } else {
                    this.outPacket.write(2, this.encode(aString.toString()));
                }
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    throw new UniSelectListException(this.uniReturnCode);
                }
                this.bLastRecordRead = false;
            }
            catch (UniRPCException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniSelectListException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formList(UniDataSet aDataSet) throws UniSelectListException {
        UniSelectList uniSelectList = this;
        synchronized (uniSelectList) {
            if (aDataSet == null) {
                throw new UniSelectListException(14022);
            }
            UniDynArray fList = aDataSet.getIDSetUniDynArray();
            byte[] imbyte = new byte[]{fList.getMarkByte(0)};
            byte[] fmbyte = new byte[]{fList.getMarkByte(1)};
            fList.change(imbyte, fmbyte);
            this.formList(fList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getList(Object aListName) throws UniSelectListException {
        UniSelectList uniSelectList = this;
        synchronized (uniSelectList) {
            this.checkEntryConditions();
            if (aListName.equals("")) {
                return;
            }
            try {
                this.uniListName = aListName.toString();
                this.outPacket.write(0, 24);
                this.outPacket.write(1, this.uniSelectListNumber);
                this.outPacket.write(2, this.encode(this.uniListName));
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    throw new UniSelectListException(this.uniReturnCode);
                }
                this.bLastRecordRead = false;
            }
            catch (UniRPCException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniSelectListException(e.getErrorCode());
            }
        }
    }

    public boolean isLastRecordRead() {
        return this.bLastRecordRead;
    }

    public UniString next() throws UniSelectListException {
        UniSelectList uniSelectList = this;
        synchronized (uniSelectList) {
            this.checkEntryConditions();
            try {
                this.outPacket.write(0, 40);
                this.outPacket.write(1, this.uniSelectListNumber);
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode == 0) {
                    this.bLastRecordRead = false;
                    return new UniString((UniConnection)this.uniParentSession, this.inPacket.readBytes(1));
                }
                if (this.uniReturnCode == 22004) {
                    this.bLastRecordRead = true;
                    this.uniReturnCode = 0;
                    return new UniString(this.uniParentSession);
                }
                throw new UniSelectListException(this.uniReturnCode);
            }
            catch (UniRPCException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniSelectListException(e.getMessage(), e.getErrorCode());
            }
        }
    }

    public UniDynArray readList() throws UniSelectListException {
        UniSelectList uniSelectList = this;
        synchronized (uniSelectList) {
            this.checkEntryConditions();
            UniDynArray uniSelectList2 = null;
            this.numberOfSelectListItems = 0;
            try {
                this.outPacket.write(0, 39);
                this.outPacket.write(1, this.uniSelectListNumber);
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode == 0) {
                    this.numberOfSelectListItems = this.inPacket.readInteger(1);
                    if (this.numberOfSelectListItems > 0) {
                        uniSelectList2 = new UniDynArray((UniConnection)this.uniParentSession, this.inPacket.readBytes(2));
                        this.bLastRecordRead = false;
                    } else {
                        uniSelectList2 = new UniDynArray(this.uniParentSession);
                        this.bLastRecordRead = true;
                    }
                    return uniSelectList2;
                }
                if (this.uniReturnCode == 22004) {
                    this.bLastRecordRead = true;
                    this.uniReturnCode = 0;
                    uniSelectList2 = new UniDynArray(this.uniParentSession);
                    return uniSelectList2;
                }
                throw new UniSelectListException(this.uniReturnCode);
            }
            catch (UniRPCException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniSelectListException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveList(Object aListNameObj) throws UniSelectListException {
        UniSelectList uniSelectList = this;
        synchronized (uniSelectList) {
            this.checkEntryConditions();
            if (aListNameObj.equals("")) {
                return;
            }
            try {
                UniCommand unic = new UniCommand(this.uniParentSession);
                String uniCommand = "SAVE.LIST " + aListNameObj + " FROM " + this.uniSelectListNumber;
                unic.setCommand(uniCommand);
                unic.exec();
                if (unic.status() != 0) {
                    unic.reply("");
                }
            }
            catch (UniCommandException e) {
                throw new UniSelectListException(e.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(UniFile uniFile) throws UniSelectListException {
        UniSelectList uniSelectList = this;
        synchronized (uniSelectList) {
            this.checkEntryConditions();
            if (uniFile == null) {
                throw new UniSelectListException(14023);
            }
            if (!uniFile.isOpen()) {
                throw new UniSelectListException(45000, uniFile.getFileName());
            }
            try {
                this.outPacket.write(0, 48);
                this.outPacket.write(1, uniFile.uniFileHandle);
                this.outPacket.write(2, this.uniSelectListNumber);
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                if (this.uniReturnCode != 0) {
                    throw new UniSelectListException(this.uniReturnCode);
                }
                this.bLastRecordRead = false;
            }
            catch (UniRPCException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniSelectListException(e.getErrorCode());
            }
        }
    }

    public void select(UniDictionary uniFile) throws UniSelectListException {
        this.select((UniFile)uniFile);
    }

    public void selectAlternateKey(UniFile uniFile, Object aIndexName) throws UniSelectListException {
        this.doAKSelect(uniFile, aIndexName, -1, this.emptyString);
    }

    public void selectAlternateKey(UniDictionary unid, Object aIndexName) throws UniSelectListException {
        this.doAKSelect(unid, aIndexName, -1, this.emptyString);
    }

    public void selectMatchingAK(UniFile uniFile, Object aIndexName, Object aIndexValue) throws UniSelectListException {
        this.doAKSelect(uniFile, aIndexName, aIndexValue.toString().length(), aIndexValue);
    }

    public void selectMatchingAK(UniDictionary unid, Object aIndexName, Object aIndexValue) throws UniSelectListException {
        this.doAKSelect(unid, aIndexName, aIndexValue.toString().length(), aIndexValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAKSelect(UniFile uniFile, Object aIndexNameObj, int aIndexLen, Object aIndexValueObj) throws UniSelectListException {
        UniSelectList uniSelectList = this;
        synchronized (uniSelectList) {
            this.checkEntryConditions();
            if (uniFile == null) {
                throw new UniSelectListException(14023);
            }
            if (!uniFile.isOpen()) {
                throw new UniSelectListException(45000, uniFile.getFileName());
            }
            try {
                int uniStatus = 0;
                this.outPacket.write(0, 49);
                this.outPacket.write(1, uniFile.uniFileHandle);
                this.outPacket.write(2, this.uniSelectListNumber);
                this.outPacket.write(3, this.encode(aIndexNameObj.toString()));
                this.outPacket.write(4, aIndexLen);
                this.outPacket.write(5, this.encode(aIndexValueObj.toString()));
                this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                this.uniReturnCode = this.inPacket.readInteger(0);
                uniStatus = this.inPacket.readInteger(1);
                this.bLastRecordRead = uniStatus == 1;
            }
            catch (UniRPCException e) {
                this.uniParentSession.setRPCError(true);
                throw new UniSelectListException(e.getErrorCode());
            }
        }
    }

    private void checkEntryConditions() throws UniSelectListException {
        if (this.isCommandActive()) {
            throw new UniSelectListException(30114);
        }
        if (this.inPacket == null) {
            try {
                this.outPacket = new UniRPCPacket(this.uniConnection);
                this.inPacket = new UniRPCPacket(this.uniConnection);
                this.uniStatus = 0;
            }
            catch (UniRPCPacketException e) {
                throw new UniSelectListException(e.getErrorCode());
            }
        }
    }
}

