/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniobjects;

import asjava.uniobjects.UniBase;
import asjava.uniobjects.UniCommandException;
import asjava.uniobjects.UniSession;
import asjava.unirpc.UniRPCException;
import asjava.unirpc.UniRPCPacket;
import asjava.unirpc.UniRPCPacketException;

public class UniCommand
extends UniBase {
    private static final boolean SHOULD_THROW = true;
    private static final boolean NO_THROW = false;
    private static final boolean CHECK_STATE = true;
    private static final boolean NO_CHECK = false;
    private String command = null;
    private String commandOutput = null;
    private String nextBuffer = null;
    private int uniReturnCode = 0;
    private int uniBlockSize = 0;
    private int uniAtSystemReturnCode = 0;
    private int uniAtSelected = 0;

    UniCommand() throws UniCommandException {
        throw new UniCommandException(88889);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UniCommand(UniSession aSession) throws UniCommandException {
        UniCommand uniCommand = this;
        synchronized (uniCommand) {
            if (aSession == null) {
                throw new UniCommandException(39120);
            }
            this.uniParentSession = aSession;
            this.uniConnection = this.uniParentSession.connection;
            this.uniStatus = 0;
            this.uniBlockSize = 0;
            this.uniEncryptionType = this.uniParentSession.getDefaultEncryptionType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws UniCommandException {
        UniCommand uniCommand = this;
        synchronized (uniCommand) {
            this.checkEntryConditions(true, false);
            if (this.uniStatus == 2 || this.uniStatus == 1) {
                try {
                    this.outPacket.write(0, 68);
                    this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
                    this.uniReturnCode = this.inPacket.readInteger(0);
                    this.uniStatus = this.uniReturnCode == 0 ? 0 : this.uniReturnCode;
                }
                catch (UniRPCException e) {
                    throw new UniCommandException(e.getMessage(), e.getErrorCode());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec() throws UniCommandException {
        UniCommand uniCommand = this;
        synchronized (uniCommand) {
            this.checkEntryConditions(true, true);
            this.uniAtSystemReturnCode = 0;
            this.uniAtSelected = 0;
            this.commandOutput = null;
            int internalReadSize = this.getBlockSize();
            if (internalReadSize == 0) {
                internalReadSize = 8192;
            }
            int code = this.doExecute(15, internalReadSize, "");
            if (this.getBlockSize() == 0) {
                this.uniStatus = code;
                while (code == 2) {
                    code = this.doExecuteContinue(internalReadSize);
                    if (code == 2 || code == 0) {
                        this.commandOutput = String.valueOf(this.commandOutput) + this.nextBuffer;
                    }
                    this.uniStatus = code;
                }
            } else if (code == 2) {
                this.uniStatus = 2;
                code = 0;
            } else {
                this.uniStatus = code;
            }
        }
    }

    public int getAtSelected() {
        return this.uniAtSelected;
    }

    public int getBlockSize() {
        return this.uniBlockSize;
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public int status() {
        return this.uniStatus;
    }

    public int getSystemReturnCode() {
        return this.uniAtSystemReturnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBlock() throws UniCommandException {
        UniCommand uniCommand = this;
        synchronized (uniCommand) {
            int code = 0;
            this.checkEntryConditions(false, false);
            if (this.uniStatus != 2) {
                throw new UniCommandException(40005);
            }
            this.uniAtSystemReturnCode = 0;
            this.uniAtSelected = 0;
            this.commandOutput = null;
            int internalReadSize = this.getBlockSize();
            if (internalReadSize == 0) {
                internalReadSize = 8192;
            }
            code = this.doExecuteContinue(internalReadSize);
            this.commandOutput = this.nextBuffer;
            if (this.getBlockSize() == 0) {
                this.uniStatus = code;
                while (code == 2) {
                    code = this.doExecuteContinue(internalReadSize);
                    if (code == 2 || code == 0) {
                        this.commandOutput = String.valueOf(this.commandOutput) + this.nextBuffer;
                    }
                    this.uniStatus = code;
                }
            } else if (code == 2) {
                this.uniStatus = 2;
                code = 0;
            } else {
                this.uniStatus = code;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reply(String aReplyString) throws UniCommandException {
        UniCommand uniCommand = this;
        synchronized (uniCommand) {
            this.checkEntryConditions(false, false);
            if (this.uniStatus != 1) {
                throw new UniCommandException(40006);
            }
            this.uniStatus = 0;
            int internalReadSize = this.getBlockSize();
            int code = 0;
            if (internalReadSize == 0) {
                internalReadSize = 8192;
            }
            code = this.doInputReply(internalReadSize, aReplyString);
            if (this.getBlockSize() == 0) {
                this.uniStatus = code;
                while (code == 2) {
                    code = this.doExecuteContinue(internalReadSize);
                    if (code != 2 && code != 0) continue;
                    this.commandOutput = String.valueOf(this.commandOutput) + this.nextBuffer;
                }
                this.uniStatus = 0;
            } else if (code == 2) {
                this.uniStatus = 2;
                code = 0;
            }
            if (code == 1) {
                this.uniStatus = 1;
                code = 0;
            }
        }
    }

    public String response() {
        return this.commandOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockSize(int aBlockSize) {
        UniCommand uniCommand = this;
        synchronized (uniCommand) {
            if (aBlockSize < 0) {
                aBlockSize = 0;
            }
            this.uniBlockSize = aBlockSize;
        }
    }

    public void setCommand(String aCommand) {
        this.command = aCommand;
    }

    private int doExecute(int serverCommand, int internalReadSize, String inputReply) throws UniCommandException {
        int retCode = 0;
        try {
            this.outPacket.write(0, serverCommand);
            switch (serverCommand) {
                case 15: {
                    this.outPacket.write(1, internalReadSize);
                    this.outPacket.write(2, this.encode(this.command));
                    this.commandOutput = null;
                    break;
                }
                case 66: {
                    this.outPacket.write(1, internalReadSize);
                    this.nextBuffer = null;
                    break;
                }
                case 67: {
                    this.commandOutput = null;
                    String replyString = String.valueOf(inputReply) + "\n";
                    this.outPacket.write(1, this.encode(replyString));
                    this.outPacket.write(2, internalReadSize);
                    break;
                }
                default: {
                    throw new UniCommandException("Illegal doExecute() serverCommand", 14022);
                }
            }
            this.uniConnection.call(this.outPacket, this.inPacket, (byte)this.uniEncryptionType);
            int response = this.inPacket.readInteger(0);
            String tmpOutput = null;
            switch (response) {
                case 1: {
                    tmpOutput = this.uniParentSession.decode(this.inPacket.readBytes(1));
                    this.uniConnection.readPacketSpoofProxy(this.inPacket);
                    this.uniAtSystemReturnCode = this.inPacket.readInteger(1);
                    this.uniAtSelected = this.inPacket.readInteger(2);
                    break;
                }
                case 22002: {
                    tmpOutput = this.uniParentSession.decode(this.inPacket.readBytes(1));
                    retCode = 2;
                    break;
                }
                case 39119: {
                    tmpOutput = this.uniParentSession.decode(this.inPacket.readBytes(1));
                    retCode = 1;
                    break;
                }
                default: {
                    retCode = response;
                }
            }
            if (serverCommand == 66) {
                this.nextBuffer = tmpOutput;
            } else {
                this.commandOutput = tmpOutput;
            }
            return retCode;
        }
        catch (UniRPCException e) {
            this.uniParentSession.setRPCError(true);
            throw new UniCommandException(e.getMessage(), e.getErrorCode());
        }
    }

    private int doExecuteContinue(int internalReadSize) throws UniCommandException {
        return this.doExecute(66, internalReadSize, "");
    }

    private int doInputReply(int internalReadSize, String aInputReply) throws UniCommandException {
        return this.doExecute(67, internalReadSize, aInputReply);
    }

    private void checkEntryConditions(boolean checkState, boolean shouldThrow) throws UniCommandException {
        if (checkState && this.isCommandActive() && shouldThrow) {
            throw new UniCommandException(30114);
        }
        if (this.inPacket == null) {
            try {
                this.outPacket = new UniRPCPacket(this.uniConnection);
                this.inPacket = new UniRPCPacket(this.uniConnection);
                this.uniStatus = 0;
            }
            catch (UniRPCPacketException e) {
                throw new UniCommandException(e.getErrorCode());
            }
        }
    }
}

