/*
 * Decompiled with CFR 0.152.
 */
package asjava.uniclientlibs;

import asjava.uniclientlibs.UniErrorMessage;

public class UniException
extends Exception {
    public static final int UNICLIENTLIBS_EXCEPTION = 0;
    public static final int UNISTRING_EXCEPTION = 1;
    public static final int UNIDYNARRAY_EXCEPTION = 2;
    public static final int UNICOMMAND_EXCEPTION = 3;
    public static final int UNIFILE_EXCEPTION = 4;
    public static final int UNINLS_EXCEPTION = 5;
    public static final int UNISELECTLIST_EXCEPTION = 6;
    public static final int UNISEQUENTIALFILE_EXCEPTION = 7;
    public static final int UNISESSION_EXCEPTION = 8;
    public static final int UNISUBROUTINE_EXCEPTION = 9;
    public static final int UNITRANSACTION_EXCEPTION = 10;
    public static final int UNICONNECTION_EXCEPTION = 11;
    public static final int UNIDATASET_EXCEPTION = 12;
    public static final int UNIXML_EXCEPTION = 13;
    private static final String U2_BANNER = "[ROCKET U2]";
    private static final String UNIOBJECT_BANNER = "[UniObjects for Java]";
    private int errorCode = 0;
    private String uniClassName = null;
    protected int errorType = 0;

    public UniException() {
    }

    public UniException(int aErrorCode) {
        super(UniErrorMessage.getErrorMessage(aErrorCode));
        this.errorCode = aErrorCode;
    }

    public UniException(String aError, int aErrorCode) {
        super(aError);
        this.errorCode = aErrorCode;
    }

    public UniException(int aErrorCode, String aExtraInfo) {
        super(UniErrorMessage.getErrorMessage(aErrorCode, aExtraInfo));
        this.errorCode = aErrorCode;
    }

    public UniException(String aClassName, String aError, int aErrorCode) {
        this(aError, aErrorCode);
        this.uniClassName = aClassName;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getExtendedMessage() {
        String returnString = "[ROCKET U2][UniObjects for Java][" + this.getErrorTypeText() + "]" + "[ErrorCode: " + this.getErrorCode() + "]" + this.getMessage();
        return returnString;
    }

    public int getErrorType() {
        return this.errorType;
    }

    public String getErrorTypeText() {
        switch (this.getErrorType()) {
            case 0: {
                return new String("UniClientLibs Generic Exception");
            }
            case 1: {
                return new String("UniString Exception");
            }
            case 2: {
                return new String("UniDynArray Exception");
            }
            case 3: {
                return new String("UniCommand Exception");
            }
            case 4: {
                return new String("UniFile Exception");
            }
            case 5: {
                return new String("UniNLS Exception");
            }
            case 6: {
                return new String("UniSelectList Exception");
            }
            case 7: {
                return new String("UniSequentialFile Exception");
            }
            case 8: {
                return new String("UniSession Exception");
            }
            case 9: {
                return new String("UniSubroutine Exception");
            }
            case 10: {
                return new String("UniTransaction Exception");
            }
            case 11: {
                return new String("UniConnection Exception");
            }
            case 12: {
                return new String("UniDataSet Exception");
            }
            case 13: {
                return new String("UniXML Exception");
            }
        }
        return new String("Unknown Error Type");
    }
}

