/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.test;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.EventObject;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.util.EventDispatch;
import org.lobobrowser.util.GenericEventListener;
import org.lobobrowser.util.Urls;
import org.lobobrowser.util.io.IORoutines;
import org.w3c.dom.Document;

public class SimpleHttpRequest
implements HttpRequest {
    private static final Logger logger = Logger.getLogger(SimpleHttpRequest.class.getName());
    private int readyState;
    private int status;
    private String statusText;
    private byte[] responseBytes;
    private final UserAgentContext context;
    private final Proxy proxy;
    private boolean isAsync;
    private URL requestURL;
    protected String requestMethod;
    protected String requestUserName;
    protected String requestPassword;
    protected URLConnection connection;
    protected Map responseHeadersMap;
    protected String responseHeaders;
    private final EventDispatch readyEvent = new EventDispatch();

    public SimpleHttpRequest(UserAgentContext context, Proxy proxy) {
        this.context = context;
        this.proxy = proxy;
    }

    @Override
    public synchronized int getReadyState() {
        return this.readyState;
    }

    @Override
    public synchronized String getResponseText() {
        String encoding;
        byte[] bytes = this.responseBytes;
        URLConnection connection = this.connection;
        String string = encoding = connection == null ? "ISO-8859-1" : Urls.getCharset(connection);
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        try {
            return bytes == null ? null : new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException uee) {
            logger.log(Level.WARNING, "getResponseText(): Charset '" + encoding + "' did not work. Retrying with ISO-8859-1.", uee);
            try {
                return new String(bytes, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee2) {
                return null;
            }
        }
    }

    @Override
    public synchronized Document getResponseXML() {
        byte[] bytes = this.responseBytes;
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "Unable to parse response as XML.", err);
            return null;
        }
    }

    @Override
    public synchronized byte[] getResponseBytes() {
        return this.responseBytes;
    }

    @Override
    public synchronized Image getResponseImage() {
        byte[] bytes = this.responseBytes;
        if (bytes == null) {
            return null;
        }
        return Toolkit.getDefaultToolkit().createImage(bytes);
    }

    @Override
    public synchronized int getStatus() {
        return this.status;
    }

    @Override
    public synchronized String getStatusText() {
        return this.statusText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        URLConnection c;
        SimpleHttpRequest simpleHttpRequest = this;
        synchronized (simpleHttpRequest) {
            c = this.connection;
        }
        if (c instanceof HttpURLConnection) {
            ((HttpURLConnection)c).disconnect();
        } else if (c != null) {
            try {
                c.getInputStream().close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    @Override
    public synchronized String getAllResponseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public synchronized String getResponseHeader(String headerName) {
        Map headers = this.responseHeadersMap;
        return headers == null ? null : (String)headers.get(headerName);
    }

    @Override
    public void open(String method, String url) throws IOException {
        this.open(method, url, true);
    }

    @Override
    public void open(String method, URL url) throws IOException {
        this.open(method, url, true, null, null);
    }

    @Override
    public void open(String method, URL url, boolean asyncFlag) throws IOException {
        this.open(method, url, asyncFlag, null, null);
    }

    @Override
    public void open(String method, String url, boolean asyncFlag) throws IOException {
        URL urlObj = Urls.createURL(null, url);
        this.open(method, urlObj, asyncFlag, null);
    }

    @Override
    public void open(String method, URL url, boolean asyncFlag, String userName) throws IOException {
        this.open(method, url, asyncFlag, userName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(String method, URL url, boolean asyncFlag, String userName, String password) throws IOException {
        this.abort();
        Proxy proxy = this.proxy;
        URLConnection c = proxy == null || proxy == Proxy.NO_PROXY ? url.openConnection() : url.openConnection(proxy);
        SimpleHttpRequest simpleHttpRequest = this;
        synchronized (simpleHttpRequest) {
            this.connection = c;
            this.isAsync = asyncFlag;
            this.requestMethod = method;
            this.requestURL = url;
            this.requestUserName = userName;
            this.requestPassword = password;
        }
        this.changeState(1, 0, null, null);
    }

    @Override
    public void send(final String content) throws IOException {
        final URL url = this.requestURL;
        if (url == null) {
            throw new IOException("No URL has been provided.");
        }
        if (this.isAsync) {
            new Thread("SimpleHttpRequest-" + url.getHost()){

                @Override
                public void run() {
                    try {
                        SimpleHttpRequest.this.sendSync(content);
                    }
                    catch (Throwable thrown) {
                        logger.log(Level.WARNING, "send(): Error in asynchronous request on " + url, thrown);
                    }
                }
            }.start();
        } else {
            this.sendSync(content);
        }
    }

    protected String getPostCharset() {
        return "UTF-8";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendSync(String content) throws IOException {
        try {
            InputStream err;
            String istatusText;
            int istatus;
            Object hc;
            URLConnection c;
            this.changeState(1, 0, null, null);
            SimpleHttpRequest simpleHttpRequest = this;
            synchronized (simpleHttpRequest) {
                c = this.connection;
            }
            c.setRequestProperty("User-Agent", this.context.getUserAgent());
            if (c instanceof HttpURLConnection) {
                hc = (HttpURLConnection)c;
                String method = this.requestMethod;
                if (method == null) {
                    throw new IOException("Null method.");
                }
                method = method.toUpperCase();
                ((HttpURLConnection)hc).setRequestMethod(method);
                if ("POST".equals(method) && content != null) {
                    ((URLConnection)hc).setDoOutput(true);
                    byte[] contentBytes = content.getBytes(this.getPostCharset());
                    ((HttpURLConnection)hc).setFixedLengthStreamingMode(contentBytes.length);
                    OutputStream out = ((URLConnection)hc).getOutputStream();
                    try {
                        out.write(contentBytes);
                    }
                    finally {
                        out.flush();
                    }
                }
                istatus = ((HttpURLConnection)hc).getResponseCode();
                istatusText = ((HttpURLConnection)hc).getResponseMessage();
                err = ((HttpURLConnection)hc).getErrorStream();
            } else {
                istatus = 0;
                istatusText = "";
                err = null;
            }
            hc = this;
            synchronized (hc) {
                this.responseHeaders = this.getAllResponseHeaders(c);
                this.responseHeadersMap = c.getHeaderFields();
            }
            this.changeState(2, istatus, istatusText, null);
            InputStream in = err == null ? c.getInputStream() : err;
            int contentLength = c.getContentLength();
            this.changeState(3, istatus, istatusText, null);
            byte[] bytes = IORoutines.load(in, contentLength == -1 ? 4096 : contentLength);
            this.changeState(4, istatus, istatusText, bytes);
        }
        catch (Throwable throwable) {
            SimpleHttpRequest simpleHttpRequest = this;
            synchronized (simpleHttpRequest) {
                this.connection = null;
            }
            throw throwable;
        }
        SimpleHttpRequest simpleHttpRequest = this;
        synchronized (simpleHttpRequest) {
            this.connection = null;
        }
    }

    @Override
    public void addReadyStateChangeListener(final ReadyStateChangeListener listener) {
        this.readyEvent.addListener(new GenericEventListener(){

            @Override
            public void processEvent(EventObject event) {
                listener.readyStateChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(int readyState, int status, String statusMessage, byte[] bytes) {
        SimpleHttpRequest simpleHttpRequest = this;
        synchronized (simpleHttpRequest) {
            this.readyState = readyState;
            this.status = status;
            this.statusText = statusMessage;
            this.responseBytes = bytes;
        }
        this.readyEvent.fireEvent(null);
    }

    private String getAllResponseHeaders(URLConnection c) {
        String value;
        int idx = 0;
        StringBuffer buf = new StringBuffer();
        while ((value = c.getHeaderField(idx)) != null) {
            String key = c.getHeaderFieldKey(idx);
            buf.append(key);
            buf.append(": ");
            buf.append(value);
            ++idx;
        }
        return buf.toString();
    }
}

