/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.js;

import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;

public class SecurityControllerImpl
extends SecurityController {
    private final URL url;
    private final Policy policy;
    private final CodeSource codesource;

    public SecurityControllerImpl(URL url, Policy policy) {
        this.url = url;
        this.policy = policy;
        this.codesource = new CodeSource(this.url, null);
    }

    public Object callWithDomain(Object securityDomain, final Context ctx, final Callable callable, final Scriptable scope, final Scriptable thisObj, final Object[] args) {
        if (securityDomain == null) {
            return callable.call(ctx, scope, thisObj, args);
        }
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                return callable.call(ctx, scope, thisObj, args);
            }
        };
        AccessControlContext acctx = new AccessControlContext(new ProtectionDomain[]{(ProtectionDomain)securityDomain});
        return AccessController.doPrivileged(action, acctx);
    }

    public GeneratedClassLoader createClassLoader(ClassLoader parent, Object staticDomain) {
        return new LocalSecureClassLoader(parent);
    }

    public Object getDynamicSecurityDomain(Object securityDomain) {
        Policy policy = this.policy;
        if (policy == null) {
            return null;
        }
        PermissionCollection permissions = this.policy.getPermissions(this.codesource);
        return new ProtectionDomain(this.codesource, permissions);
    }

    private class LocalSecureClassLoader
    extends SecureClassLoader
    implements GeneratedClassLoader {
        public LocalSecureClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length, SecurityControllerImpl.this.codesource);
        }

        public void linkClass(Class clazz) {
            super.resolveClass(clazz);
        }
    }
}

