/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.gui.DocumentNotification;
import org.lobobrowser.html.renderer.BaseRCollection;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.NodeRenderer;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.Renderable;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.util.Nodes;
import org.lobobrowser.util.Objects;
import org.lobobrowser.util.gui.ColorFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HtmlBlockPanel
extends JComponent
implements NodeRenderer,
RenderableContainer,
ClipboardOwner {
    private static final Logger logger = Logger.getLogger(HtmlBlockPanel.class.getName());
    private static final boolean loggableInfo = logger.isLoggable(Level.INFO);
    protected final FrameContext frameContext;
    protected final UserAgentContext ucontext;
    protected final HtmlRendererContext rcontext;
    protected RenderableSpot startSelection;
    protected RenderableSpot endSelection;
    protected RBlock rblock;
    protected int preferredWidth = -1;
    protected Insets defaultMarginInsets = null;
    protected int defaultOverflowX = 2;
    protected int defaultOverflowY = 1;
    private BoundableRenderable mousePressTarget;
    private boolean processingDocumentNotification = false;
    private Set components;

    public HtmlBlockPanel(UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext) {
        this(ColorFactory.TRANSPARENT, false, pcontext, rcontext, frameContext);
    }

    public HtmlBlockPanel(Color background, boolean opaque, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext) {
        this.setLayout(null);
        this.setAutoscrolls(true);
        this.frameContext = frameContext;
        this.ucontext = pcontext;
        this.rcontext = rcontext;
        this.setOpaque(opaque);
        this.setBackground(background);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if ("copy".equals(command)) {
                    HtmlBlockPanel.this.copy();
                }
            }
        };
        if (!GraphicsEnvironment.isHeadless()) {
            this.registerKeyboardAction(actionListener, "copy", KeyStroke.getKeyStroke(65485, 0), 0);
            this.registerKeyboardAction(actionListener, "copy", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), 0);
        }
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HtmlBlockPanel.this.onMouseClick(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HtmlBlockPanel.this.onMouseExited(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                HtmlBlockPanel.this.onMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                HtmlBlockPanel.this.onMouseReleased(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                HtmlBlockPanel.this.onMouseDragged(e);
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
                HtmlBlockPanel.this.onMouseMoved(arg0);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                HtmlBlockPanel.this.onMouseWheelMoved(e);
            }
        });
    }

    public void scrollTo(Rectangle bounds, boolean xIfNeeded, boolean yIfNeeded) {
        RBlock block = this.rblock;
        if (block != null) {
            block.scrollTo(bounds, xIfNeeded, yIfNeeded);
        }
    }

    public void scrollBy(int xOffset, int yOffset) {
        RBlock block = this.rblock;
        if (block != null) {
            if (xOffset != 0) {
                block.scrollBy(0, xOffset);
            }
            if (yOffset != 0) {
                block.scrollBy(1, yOffset);
            }
        }
    }

    public void scrollTo(Node node) {
        Rectangle bounds = this.getNodeBounds(node, true);
        if (bounds == null) {
            return;
        }
        this.scrollTo(bounds, true, false);
    }

    public Rectangle getNodeBounds(Node node, boolean relativeToScrollable) {
        BaseRCollection relativeTo;
        RBlock block = this.rblock;
        if (block == null) {
            return null;
        }
        Node currentNode = node;
        UINode uiNode = null;
        while (currentNode != null) {
            HTMLElementImpl element;
            if (currentNode instanceof HTMLElementImpl && (uiNode = (element = (HTMLElementImpl)currentNode).getUINode()) != null) break;
            currentNode = currentNode.getParentNode();
        }
        if (uiNode == null) {
            return null;
        }
        BaseRCollection baseRCollection = relativeTo = relativeToScrollable ? block.getRBlockViewport() : block;
        if (node == currentNode) {
            BoundableRenderable br = (BoundableRenderable)((Object)uiNode);
            Point guiPoint = br.getOriginRelativeTo(relativeTo);
            Dimension size = br.getSize();
            return new Rectangle(guiPoint, size);
        }
        return this.scanNodeBounds((RCollection)((Object)uiNode), node, relativeTo);
    }

    private Rectangle scanNodeBounds(RCollection root, Node node, RCollection relativeTo) {
        Iterator i = root.getRenderables();
        Rectangle resultBounds = null;
        BoundableRenderable prevBoundable = null;
        if (i != null) {
            while (i.hasNext()) {
                Renderable r = (Renderable)i.next();
                Rectangle subBounds = null;
                if (r instanceof RCollection) {
                    RCollection rc = (RCollection)r;
                    prevBoundable = rc;
                    subBounds = this.scanNodeBounds(rc, node, relativeTo);
                } else if (r instanceof BoundableRenderable) {
                    BoundableRenderable br;
                    prevBoundable = br = (BoundableRenderable)r;
                    if (Nodes.isSameOrAncestorOf(node, (Node)((Object)r.getModelNode()))) {
                        Point origin = br.getOriginRelativeTo(relativeTo);
                        Dimension size = br.getSize();
                        subBounds = new Rectangle(origin, size);
                    }
                } else if (Nodes.isSameOrAncestorOf(node, (Node)((Object)r.getModelNode()))) {
                    int xInRoot = prevBoundable == null ? 0 : prevBoundable.getX() + prevBoundable.getWidth();
                    Point rootOrigin = root.getOriginRelativeTo(relativeTo);
                    subBounds = new Rectangle(rootOrigin.x + xInRoot, rootOrigin.y, 0, root.getHeight());
                }
                if (subBounds == null) continue;
                resultBounds = resultBounds == null ? subBounds : subBounds.union(resultBounds);
            }
        }
        return resultBounds;
    }

    public BoundableRenderable getRootRenderable() {
        return this.rblock;
    }

    public void setPreferredWidth(int width) {
        this.preferredWidth = width;
    }

    @Override
    public Dimension getPreferredSize() {
        RBlock block;
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        final int pw = this.preferredWidth;
        if (pw != -1 && (block = this.rblock) != null) {
            if (EventQueue.isDispatchThread()) {
                block.layout(pw, 0, false, false, 4, 4, true);
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            block.layout(pw, 0, false, false, 4, 4, true);
                        }
                    });
                }
                catch (Exception err) {
                    logger.log(Level.SEVERE, "Unable to do preferred size layout.", err);
                }
            }
            int newPw = Math.max(block.width + block.getVScrollBarWidth(), pw);
            return new Dimension(newPw, block.height);
        }
        return new Dimension(600, 400);
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public boolean copy() {
        String selection = this.getSelectionText();
        if (selection != null) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(selection), this);
            return true;
        }
        return false;
    }

    public int getFirstLineHeight() {
        RBlock block = this.rblock;
        return block == null ? 0 : block.getFirstLineHeight();
    }

    public void setSelectionEnd(RenderableSpot rpoint) {
        this.endSelection = rpoint;
    }

    public void setSelectionStart(RenderableSpot rpoint) {
        this.startSelection = rpoint;
    }

    public boolean isSelectionAvailable() {
        RenderableSpot start = this.startSelection;
        RenderableSpot end = this.endSelection;
        return start != null && end != null && !start.equals(end);
    }

    public Node getSelectionNode() {
        RenderableSpot start = this.startSelection;
        RenderableSpot end = this.endSelection;
        if (start != null && end != null) {
            return Nodes.getCommonAncestor((Node)((Object)start.renderable.getModelNode()), (Node)((Object)end.renderable.getModelNode()));
        }
        return null;
    }

    @Override
    public void setRootNode(NodeImpl node) {
        if (node != null) {
            RBlock block = new RBlock(node, 0, this.ucontext, this.rcontext, this.frameContext, this);
            block.setDefaultMarginInsets(this.defaultMarginInsets);
            block.setDefaultOverflowX(this.defaultOverflowX);
            block.setDefaultOverflowY(this.defaultOverflowY);
            node.setUINode(block);
            this.rblock = block;
        } else {
            this.rblock = null;
        }
        this.invalidate();
        this.validateAll();
        this.repaint();
    }

    protected void validateAll() {
        Container parent;
        Container toValidate = this;
        while ((parent = toValidate.getParent()) != null && !parent.isValid()) {
            toValidate = parent;
        }
        ((Component)toValidate).validate();
    }

    protected void revalidatePanel() {
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public NodeImpl getRootNode() {
        RBlock block = this.rblock;
        return block == null ? null : (NodeImpl)block.getModelNode();
    }

    private void onMouseClick(MouseEvent event) {
        RBlock block = this.rblock;
        if (block != null) {
            int button = event.getButton();
            int clickCount = event.getClickCount();
            if (button == 1 && clickCount > 1) {
                Point point = event.getPoint();
                block.onDoubleClick(event, point.x, point.y);
            } else if (button == 3 && clickCount == 1) {
                block.onRightClick(event, event.getX(), event.getY());
            }
        }
    }

    private void onMousePressed(MouseEvent event) {
        this.requestFocus();
        RBlock block = this.rblock;
        if (block != null) {
            Point point = event.getPoint();
            this.mousePressTarget = block;
            int rx = point.x;
            int ry = point.y;
            block.onMousePressed(event, point.x, point.y);
            RenderableSpot rp = block.getLowestRenderableSpot(rx, ry);
            if (rp != null) {
                this.frameContext.resetSelection(rp);
            } else {
                this.frameContext.resetSelection(null);
            }
        }
    }

    private void onMouseReleased(MouseEvent event) {
        RBlock block = this.rblock;
        if (block != null) {
            Point point = event.getPoint();
            int rx = point.x;
            int ry = point.y;
            if (event.getButton() == 1) {
                block.onMouseClick(event, rx, ry);
            }
            block.onMouseReleased(event, rx, ry);
            BoundableRenderable oldTarget = this.mousePressTarget;
            if (oldTarget != null) {
                this.mousePressTarget = null;
                if (oldTarget != block) {
                    oldTarget.onMouseDisarmed(event);
                }
            }
        } else {
            this.mousePressTarget = null;
        }
    }

    private void onMouseExited(MouseEvent event) {
        BoundableRenderable oldTarget = this.mousePressTarget;
        if (oldTarget != null) {
            this.mousePressTarget = null;
            oldTarget.onMouseDisarmed(event);
        }
    }

    private void onMouseWheelMoved(MouseWheelEvent mwe) {
        RBlockViewport viewport = this.rblock.getRBlockViewport();
        RenderableSpot spot = viewport.getLowestRenderableSpot(mwe.getX(), mwe.getY());
        RBlock block = this.rblock;
        BoundableRenderable r = spot.renderable;
        while (r != null) {
            if (r instanceof RBlock) {
                block = (RBlock)r;
                RBlockViewport blockViewport = block.getRBlockViewport();
                if (mwe.getWheelRotation() < 0 ? blockViewport.getY() < 0 : blockViewport.getY() + blockViewport.getHeight() > block.getHeight()) break;
            }
            r = r.getParent();
        }
        if (block != null) {
            switch (mwe.getScrollType()) {
                case 0: {
                    int units = mwe.getWheelRotation() * mwe.getScrollAmount();
                    block.scrollByUnits(1, units);
                }
            }
        }
    }

    private void onMouseDragged(MouseEvent event) {
        RBlock block = this.rblock;
        if (block != null) {
            Point point = event.getPoint();
            RenderableSpot rp = block.getLowestRenderableSpot(point.x, point.y);
            if (rp != null) {
                this.frameContext.expandSelection(rp);
            }
            block.ensureVisible(point);
        }
    }

    private void onMouseMoved(MouseEvent event) {
        RBlock block = this.rblock;
        if (block != null) {
            Point point = event.getPoint();
            block.onMouseMoved(event, point.x, point.y, false, null);
        }
    }

    @Override
    public void paint(Graphics g) {
        RBlock block;
        if (this.isOpaque()) {
            Rectangle clipBounds = g.getClipBounds();
            g.setColor(this.getBackground());
            g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        }
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if ((block = this.rblock) != null) {
            boolean liflag = loggableInfo;
            long time1 = liflag ? System.currentTimeMillis() : 0L;
            block.paint(g);
            if (liflag) {
                long time2 = System.currentTimeMillis();
                NodeImpl rootNode = this.getRootNode();
                String uri = rootNode instanceof Document ? ((Document)((Object)rootNode)).getDocumentURI() : "";
                logger.info("paintComponent(): URI=[" + uri + "]. Block paint elapsed: " + (time2 - time1) + " ms.");
            }
            RenderableSpot start = this.startSelection;
            RenderableSpot end = this.endSelection;
            if (start != null && end != null && !start.equals(end)) {
                block.paintSelection(g, false, start, end);
            }
        }
    }

    @Override
    public void doLayout() {
        try {
            Dimension size = this.getSize();
            boolean liflag = loggableInfo;
            long time1 = 0L;
            if (liflag) {
                time1 = System.currentTimeMillis();
            }
            this.clearComponents();
            RBlock block = this.rblock;
            if (block != null) {
                ModelNode rootNode = block.getModelNode();
                block.layout(size.width, size.height, true, true, null, false);
                block.setOrigin(0, 0);
                block.updateWidgetBounds(0, 0);
                this.updateGUIComponents();
                if (liflag) {
                    long time2 = System.currentTimeMillis();
                    String uri = rootNode instanceof Document ? ((Document)((Object)rootNode)).getDocumentURI() : "";
                    logger.info("doLayout(): URI=[" + uri + "]. Block layout elapsed: " + (time2 - time1) + " ms. Component count: " + this.getComponentCount() + ".");
                }
            } else if (this.getComponentCount() > 0) {
                this.removeAll();
            }
        }
        catch (Throwable thrown) {
            logger.log(Level.SEVERE, "Unexpected error in layout engine. Document is " + this.getRootNode(), thrown);
        }
    }

    public void repaint(ModelNode modelNode) {
        this.repaint();
    }

    public String getSelectionText() {
        RenderableSpot start = this.startSelection;
        RenderableSpot end = this.endSelection;
        if (start != null && end != null) {
            StringBuffer buffer = new StringBuffer();
            this.rblock.extractSelectionText(buffer, false, start, end);
            return buffer.toString();
        }
        return null;
    }

    public boolean hasSelection() {
        RenderableSpot start = this.startSelection;
        RenderableSpot end = this.endSelection;
        return start != null && end != null && !start.equals(end);
    }

    @Override
    protected void paintChildren(Graphics g) {
    }

    @Override
    public Color getPaintedBackgroundColor() {
        return this.isOpaque() ? this.getBackground() : null;
    }

    @Override
    public void lostOwnership(Clipboard arg0, Transferable arg1) {
    }

    @Override
    public void relayout() {
        this.revalidatePanel();
    }

    @Override
    public void invalidateLayoutUpTree() {
    }

    @Override
    public void updateAllWidgetBounds() {
        this.rblock.updateWidgetBounds(0, 0);
    }

    @Override
    public Point getGUIPoint(int clientX, int clientY) {
        return new Point(clientX, clientY);
    }

    @Override
    public void focus() {
        this.grabFocus();
    }

    void processDocumentNotifications(DocumentNotification[] notifications) {
        if (this.processingDocumentNotification) {
            throw new IllegalStateException("Recursive");
        }
        this.processingDocumentNotification = true;
        try {
            boolean topLayout = false;
            ArrayList<RElement> repainters = null;
            int length = notifications.length;
            int i = 0;
            while (i < length) {
                DocumentNotification dn = notifications[i];
                int type = dn.type;
                switch (type) {
                    case 2: 
                    case 3: {
                        RElement relement;
                        UINode uiNode;
                        NodeImpl node = dn.node;
                        if (node == null) {
                            if (loggableInfo) {
                                logger.info("processDocumentNotifications(): Calling invalidateLayoutDeep().");
                            }
                            this.rblock.invalidateLayoutDeep();
                        } else {
                            uiNode = node.findUINode();
                            if (uiNode != null) {
                                relement = (RElement)uiNode;
                                relement.invalidateLayoutUpTree();
                            } else if (loggableInfo) {
                                logger.info("processDocumentNotifications(): Unable to find UINode for " + node);
                            }
                        }
                        topLayout = true;
                        break;
                    }
                    case 1: {
                        UINode uiNode;
                        NodeImpl node = dn.node;
                        NodeImpl parent = (NodeImpl)node.getParentNode();
                        if (parent != null && (uiNode = parent.findUINode()) != null) {
                            RElement relement = (RElement)uiNode;
                            relement.invalidateLayoutUpTree();
                        }
                        topLayout = true;
                        break;
                    }
                    case 0: {
                        NodeImpl node = dn.node;
                        UINode uiNode = node.findUINode();
                        if (uiNode == null) break;
                        if (repainters == null) {
                            repainters = new ArrayList<RElement>(1);
                        }
                        RElement relement = (RElement)uiNode;
                        repainters.add(relement);
                        break;
                    }
                }
                ++i;
            }
            if (topLayout) {
                this.revalidatePanel();
            } else if (repainters != null) {
                for (RElement element : repainters) {
                    element.repaint();
                }
            }
        }
        finally {
            this.processingDocumentNotification = false;
        }
    }

    @Override
    public void addDelayedPair(DelayedPair pair) {
    }

    @Override
    public RenderableContainer getParentContainer() {
        return null;
    }

    @Override
    public Collection getDelayedPairs() {
        return null;
    }

    @Override
    public void clearDelayedPairs() {
    }

    private void clearComponents() {
        Set c = this.components;
        if (c != null) {
            c.clear();
        }
    }

    @Override
    public Component addComponent(Component component) {
        HashSet<Component> c = this.components;
        if (c == null) {
            this.components = c = new HashSet<Component>();
        }
        if (c.add(component)) {
            return component;
        }
        return null;
    }

    private void updateGUIComponents() {
        Set c = this.components;
        if (c == null) {
            if (this.getComponentCount() != 0) {
                this.removeAll();
            }
        } else {
            HashSet workingSet = new HashSet();
            workingSet.addAll(c);
            int count = this.getComponentCount();
            int i = 0;
            while (i < count) {
                Component component = this.getComponent(i);
                if (!c.contains(component)) {
                    this.remove(i);
                    count = this.getComponentCount();
                    continue;
                }
                ++i;
                workingSet.remove(component);
            }
            for (Component component : workingSet) {
                this.add(component);
            }
        }
    }

    public Insets getDefaultMarginInsets() {
        return this.defaultMarginInsets;
    }

    public void setDefaultMarginInsets(Insets defaultMarginInsets) {
        if (!Objects.equals(this.defaultMarginInsets, defaultMarginInsets)) {
            this.defaultMarginInsets = defaultMarginInsets;
            RBlock block = this.rblock;
            if (block != null) {
                block.setDefaultMarginInsets(defaultMarginInsets);
                block.relayoutIfValid();
            }
        }
    }

    public int getDefaultOverflowX() {
        return this.defaultOverflowX;
    }

    public void setDefaultOverflowX(int defaultOverflowX) {
        if (defaultOverflowX != this.defaultOverflowX) {
            this.defaultOverflowX = defaultOverflowX;
            RBlock block = this.rblock;
            if (block != null) {
                block.setDefaultOverflowX(defaultOverflowX);
                block.relayoutIfValid();
            }
        }
    }

    public int getDefaultOverflowY() {
        return this.defaultOverflowY;
    }

    public void setDefaultOverflowY(int defaultOverflowY) {
        if (this.defaultOverflowY != defaultOverflowY) {
            this.defaultOverflowY = defaultOverflowY;
            RBlock block = this.rblock;
            if (block != null) {
                block.setDefaultOverflowY(defaultOverflowY);
                block.relayoutIfValid();
            }
        }
    }
}

