/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLFormElementImpl;
import org.lobobrowser.html.domimpl.ImageEvent;
import org.lobobrowser.html.domimpl.ImageListener;
import org.lobobrowser.html.domimpl.InputContext;
import org.lobobrowser.html.js.Executor;
import org.mozilla.javascript.Function;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLFormElement;

public abstract class HTMLBaseInputElement
extends HTMLAbstractUIElement {
    protected InputContext inputContext;
    protected String deferredValue;
    private Function onload;
    private Image image = null;
    private String imageSrc;
    private final ArrayList imageListeners = new ArrayList(1);

    public HTMLBaseInputElement(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputContext(InputContext ic) {
        String dv = null;
        HTMLBaseInputElement hTMLBaseInputElement = this;
        synchronized (hTMLBaseInputElement) {
            this.inputContext = ic;
            if (ic != null) {
                dv = this.deferredValue;
            }
        }
        if (dv != null) {
            ic.setValue(dv);
        }
    }

    public String getDefaultValue() {
        return this.getAttribute("defaultValue");
    }

    public void setDefaultValue(String defaultValue) {
        this.setAttribute("defaultValue", defaultValue);
    }

    public HTMLFormElement getForm() {
        Node parent = this.getParentNode();
        while (parent != null && !(parent instanceof HTMLFormElement)) {
            parent = parent.getParentNode();
        }
        return (HTMLFormElement)parent;
    }

    public void submitForm(FormInput[] extraFormInputs) {
        HTMLFormElementImpl form = (HTMLFormElementImpl)this.getForm();
        if (form != null) {
            form.submit(extraFormInputs);
        }
    }

    public void resetForm() {
        HTMLFormElement form = this.getForm();
        if (form != null) {
            form.reset();
        }
    }

    public String getAccept() {
        return this.getAttribute("accept");
    }

    public void setAccept(String accept) {
        this.setAttribute("accept", accept);
    }

    public String getAccessKey() {
        return this.getAttribute("accessKey");
    }

    public void setAccessKey(String accessKey) {
        this.setAttribute("accessKey", accessKey);
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    public String getAlt() {
        return this.getAttribute("alit");
    }

    public void setAlt(String alt) {
        this.setAttribute("alt", alt);
    }

    public boolean getDisabled() {
        InputContext ic = this.inputContext;
        return ic == null ? false : ic.getDisabled();
    }

    public void setDisabled(boolean disabled) {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.setDisabled(disabled);
        }
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public boolean getReadOnly() {
        InputContext ic = this.inputContext;
        return ic == null ? false : ic.getReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.setReadOnly(readOnly);
        }
    }

    public int getTabIndex() {
        InputContext ic = this.inputContext;
        return ic == null ? 0 : ic.getTabIndex();
    }

    public void setTabIndex(int tabIndex) {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.setTabIndex(tabIndex);
        }
    }

    public String getValue() {
        InputContext ic = this.inputContext;
        if (ic != null) {
            return ic.getValue();
        }
        String dv = this.deferredValue;
        if (dv != null) {
            return dv;
        }
        String val = this.getAttribute("value");
        return val == null ? "" : val;
    }

    protected File getFileValue() {
        InputContext ic = this.inputContext;
        if (ic != null) {
            return ic.getFileValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String value) {
        InputContext ic = null;
        HTMLBaseInputElement hTMLBaseInputElement = this;
        synchronized (hTMLBaseInputElement) {
            ic = this.inputContext;
            if (ic == null) {
                this.deferredValue = value;
            }
        }
        if (ic != null) {
            ic.setValue(value);
        }
    }

    @Override
    public void blur() {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.blur();
        }
    }

    @Override
    public void focus() {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.focus();
        }
    }

    public void select() {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.select();
        }
    }

    @Override
    protected void assignAttributeField(String normalName, String value) {
        if ("value".equals(normalName)) {
            InputContext ic = this.inputContext;
            if (ic != null) {
                ic.setValue(value);
            }
        } else if ("src".equals(normalName)) {
            this.loadImage(value);
        } else {
            super.assignAttributeField(normalName, value);
        }
    }

    public Function getOnload() {
        return this.getEventFunction(this.onload, "onload");
    }

    public void setOnload(Function onload) {
        this.onload = onload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImage(String src) {
        HTMLDocumentImpl document = (HTMLDocumentImpl)this.document;
        if (document != null) {
            ArrayList arrayList = this.imageListeners;
            synchronized (arrayList) {
                this.imageSrc = src;
                this.image = null;
            }
            if (src != null) {
                document.loadImage(src, new LocalImageListener(src));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Image getImage() {
        ArrayList arrayList = this.imageListeners;
        synchronized (arrayList) {
            return this.image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageListener(ImageListener listener) {
        Image currentImage;
        ArrayList l;
        ArrayList arrayList = l = this.imageListeners;
        synchronized (arrayList) {
            currentImage = this.image;
            l.add(listener);
        }
        if (currentImage != null) {
            listener.imageLoaded(new ImageEvent(this, currentImage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageListener(ImageListener listener) {
        ArrayList l;
        ArrayList arrayList = l = this.imageListeners;
        synchronized (arrayList) {
            l.remove(l);
        }
    }

    void resetInput() {
        InputContext ic = this.inputContext;
        if (ic != null) {
            ic.resetInput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(String expectedImgSrc, ImageEvent event) {
        ImageListener[] listenerArray;
        ArrayList l;
        ArrayList arrayList = l = this.imageListeners;
        synchronized (arrayList) {
            if (!expectedImgSrc.equals(this.imageSrc)) {
                return;
            }
            this.image = event.image;
            listenerArray = l.toArray(ImageListener.EMPTY_ARRAY);
        }
        int llength = listenerArray.length;
        int i = 0;
        while (i < llength) {
            listenerArray[i].imageLoaded(event);
            ++i;
        }
        Function onload = this.getOnload();
        if (onload != null) {
            Executor.executeFunction(this, onload, null);
        }
    }

    private class LocalImageListener
    implements ImageListener {
        private final String expectedImgSrc;

        public LocalImageListener(String imgSrc) {
            this.expectedImgSrc = imgSrc;
        }

        @Override
        public void imageLoaded(ImageEvent event) {
            HTMLBaseInputElement.this.dispatchEvent(this.expectedImgSrc, event);
        }
    }
}

