/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.webserver.paye;

import com.selima.fbi.util.NetUtil;
import com.selima.fbi.webserver.PagePart;
import com.selima.fbi.webserver.paye.CuttingRule;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class MetadataParser {
    static final String DEFAULT_RULESET = "default";

    public static void parseMetadata(Reader reader, URL baseURL, Map<String, Set<CuttingRule>> rules, List<PagePart> pageParts) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader xmlReader = factory.createXMLEventReader(reader);
        MetadataParser.parse(xmlReader, new QName("pages"), baseURL, rules, pageParts);
    }

    static void parse(XMLEventReader xmlReader, QName endTag, URL baseUrl, Map<String, Set<CuttingRule>> rules, List<PagePart> pageParts) throws XMLStreamException {
        String currentPage = null;
        String excludePath = null;
        String defaultSearchKey = null;
        LinkedList<String> exceptionPath = new LinkedList<String>();
        HashMap<String, String> keys = new HashMap<String, String>();
        XMLEvent evt = xmlReader.nextEvent();
        while (xmlReader.hasNext()) {
            if (evt.isStartElement()) {
                Attribute name;
                Attribute attribute;
                if ("exception".equals(evt.asStartElement().getName().getLocalPart())) {
                    attribute = evt.asStartElement().getAttributeByName(new QName("path"));
                    if (attribute == null) {
                        throw new XMLStreamException("Missing path attribute (" + String.valueOf(evt.getLocation() + ")"));
                    }
                    exceptionPath.add(attribute.getValue());
                } else if ("exclude".equals(evt.asStartElement().getName().getLocalPart())) {
                    attribute = evt.asStartElement().getAttributeByName(new QName("path"));
                    if (attribute == null) {
                        throw new XMLStreamException("Missing path attribute (" + String.valueOf(evt.getLocation() + ")"));
                    }
                    excludePath = attribute.getValue();
                } else if ("page".equals(evt.asStartElement().getName().getLocalPart())) {
                    attribute = evt.asStartElement().getAttributeByName(new QName("id"));
                    if (attribute == null) {
                        throw new XMLStreamException("Missing id attribute (" + String.valueOf(evt.getLocation() + ")"));
                    }
                    currentPage = attribute.getValue();
                } else if ("key".equals(evt.asStartElement().getName().getLocalPart()) && (name = evt.asStartElement().getAttributeByName(new QName("name"))) != null) {
                    keys.put(name.getValue(), xmlReader.getElementText());
                    Attribute isdef = evt.asStartElement().getAttributeByName(new QName(DEFAULT_RULESET));
                    if (isdef != null && Boolean.parseBoolean(isdef.getValue())) {
                        defaultSearchKey = name.getValue();
                    }
                }
            } else if (evt.isEndElement()) {
                if ("exclude".equals(evt.asEndElement().getName().getLocalPart())) {
                    String rulesId = currentPage != null ? currentPage : DEFAULT_RULESET;
                    Set<CuttingRule> set = rules.get(rulesId);
                    if (set == null) {
                        set = new HashSet<CuttingRule>();
                        rules.put(rulesId, set);
                    }
                    set.add(new CuttingRule(excludePath, exceptionPath));
                    exceptionPath.clear();
                } else if ("page".equals(evt.asEndElement().getName().getLocalPart())) {
                    pageParts.add(new PagePart(new HashMap<String, String>(keys), defaultSearchKey, currentPage, NetUtil.addURL(baseUrl, "page", currentPage)));
                    currentPage = null;
                    keys.clear();
                } else if (evt.asEndElement().getName().equals(endTag)) break;
            }
            evt = xmlReader.nextEvent();
        }
    }
}

