/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.webserver.paye;

import com.selima.fbi.webserver.PagePart;
import com.selima.fbi.webserver.paye.CuttingRule;
import com.selima.fbi.webserver.paye.RenderingMetadata;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultRenderingMetadata
implements RenderingMetadata {
    final List<PagePart> pageParts;
    final Map<String, Set<CuttingRule>> cuttingRules;
    final String rewriteFromNS;
    final String rewriteToNS;

    public DefaultRenderingMetadata(String name, URL url) {
        this.rewriteToNS = null;
        this.rewriteFromNS = null;
        this.pageParts = new ArrayList<PagePart>(Collections.singletonList(new PagePart(name, "1", url)));
        this.cuttingRules = Collections.emptyMap();
    }

    public DefaultRenderingMetadata(String name, URL url, String fromNS, String toNS) {
        this.rewriteFromNS = fromNS;
        this.rewriteToNS = toNS;
        this.pageParts = new ArrayList<PagePart>(Collections.singletonList(new PagePart(name, "1", url)));
        this.cuttingRules = Collections.emptyMap();
    }

    public DefaultRenderingMetadata(String fromNS, String toNS, List<PagePart> pageParts, Map<String, Set<CuttingRule>> cuttingRules) {
        this.cuttingRules = cuttingRules;
        this.pageParts = pageParts;
        this.rewriteFromNS = fromNS;
        this.rewriteToNS = toNS;
    }

    @Override
    public Set<CuttingRule> getCuttingRules(String page) {
        return this.cuttingRules.get(page);
    }

    @Override
    public List<PagePart> getPageParts() {
        return this.pageParts;
    }

    @Override
    public String getRewriteFromNS() {
        return this.rewriteFromNS;
    }

    @Override
    public String getRewriteToNS() {
        return this.rewriteToNS;
    }

    @Override
    public boolean isCuttingXML() {
        return !this.cuttingRules.isEmpty();
    }

    @Override
    public boolean isRewritingNS() {
        return this.rewriteFromNS != null && this.rewriteFromNS != null;
    }
}

