/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.webserver;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.apache.xpath.NodeSet;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XalanExtension {
    static Document document;

    public static DocumentFragment annotation(XSLProcessorContext context, ElemExtensionCall element) throws TransformerException {
        return document.createDocumentFragment();
    }

    public static DocumentFragment cuttingRules(XSLProcessorContext context, ElemExtensionCall element) throws TransformerException {
        return document.createDocumentFragment();
    }

    public static DocumentFragment boxText(XSLProcessorContext context, ElemExtensionCall element) throws TransformerException {
        String text = element.getAttribute("text", context.getContextNode(), context.getTransformer());
        float size = Float.parseFloat(element.getAttribute("size"));
        int x = 0;
        boolean leftToRight = true;
        if (element.getAttribute("left").length() > 0) {
            x = Integer.parseInt(element.getAttribute("left"));
        }
        int y = Integer.parseInt(element.getAttribute("top"));
        if (element.getAttribute("right").length() > 0) {
            x = Integer.parseInt(element.getAttribute("right"));
            leftToRight = false;
        }
        DocumentFragment fragment = document.createDocumentFragment();
        fragment.appendChild(document.createTextNode("\n"));
        for (int i = 0; i < text.length(); ++i) {
            int left;
            int n = left = leftToRight ? x + (int)((float)i * size) : x - (int)((float)(text.length() - i) * size);
            if (Character.isWhitespace(text.charAt(i))) continue;
            Element div = document.createElementNS("http://www.w3.org/1999/xhtml", "div");
            div.setAttribute("style", "left:" + left + "px;top:" + y + "px;width:" + (int)size + "px;text-align:center;text-transform:capitalize");
            div.appendChild(document.createTextNode(String.valueOf(text.charAt(i))));
            fragment.appendChild(div);
        }
        return fragment;
    }

    public static NodeList multiLineBoxes(ExpressionContext context, NodeList nList, int left, int top, float height, float width, int rowCount, int rowLength, int remainder) throws TransformerException, XPathExpressionException {
        TextDocument text = new TextDocument(rowLength);
        for (int i = 0; i < nList.getLength(); ++i) {
            StringBuilder line = new StringBuilder();
            NodeList children = nList.item(i).getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                line.append(children.item(j).getNodeValue());
            }
            text.add(line.toString());
        }
        text.doLayout(rowCount, remainder);
        NodeSet result = new NodeSet();
        text.generateHTML(left, top, width, height, result);
        return result;
    }

    public static String dateFormat(ExpressionContext context, NodeList nList) {
        StringBuilder buffer = new StringBuilder();
        block6: for (int j = 0; j < nList.getLength(); ++j) {
            Node node = nList.item(j);
            switch (node.getNodeType()) {
                case 1: {
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        buffer.append(children.item(i).getTextContent());
                    }
                    continue block6;
                }
                case 3: {
                    buffer.append(node.getTextContent());
                }
            }
        }
        if (buffer.length() > 0) {
            try {
                Date date = new SimpleDateFormat("yyyy-MM-dd").parse(buffer.toString());
                return new SimpleDateFormat("dd/MM/yyyy").format(date);
            }
            catch (ParseException e) {
                return buffer.toString();
            }
        }
        return "";
    }

    public static NodeList splitLines(ExpressionContext context, NodeList nList) {
        NodeSet result = new NodeSet();
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < nList.getLength(); ++i) {
            text.append(context.toString(nList.item(i)));
        }
        for (String line : text.toString().split("\n")) {
            result.addNode((Node)document.createTextNode(line));
        }
        return result;
    }

    static {
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    static class IdentitySet<K>
    implements Set<K> {
        IdentityHashMap<K, Object> map = new IdentityHashMap();

        IdentitySet() {
        }

        @Override
        public boolean add(K e) {
            return this.map.put(e, this) != null;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            boolean result = false;
            for (K key : collection) {
                result = this.add(key) || result;
            }
            return result;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object key : c) {
                if (this.contains(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<K> iterator() {
            return this.map.keySet().iterator();
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(o) != null;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean result = false;
            for (Object key : collection) {
                result = this.remove(key) || result;
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean result = false;
            Iterator<K> it = this.map.keySet().iterator();
            while (it.hasNext()) {
                if (c.contains(it.next())) continue;
                it.remove();
                result = true;
            }
            return result;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Object[] toArray() {
            return this.map.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.map.keySet().toArray(a);
        }
    }

    static class Paragraph {
        LinkedList<LinkedList<String>> linesOfWords = new LinkedList();
        IdentitySet<String> wordFragments = new IdentitySet();
        int rowLenght;

        Paragraph(String line, int rowLength) {
            this.rowLenght = rowLength;
            int currentLength = -1;
            LinkedList<String> currentLine = new LinkedList<String>();
            StringTokenizer tok = new StringTokenizer(line);
            while (tok.hasMoreTokens()) {
                String word = tok.nextToken();
                if (currentLength + 1 + word.length() <= rowLength) {
                    currentLine.add(word);
                    currentLength += word.length() + 1;
                    continue;
                }
                while (word.length() >= rowLength) {
                    if (!currentLine.isEmpty()) {
                        this.linesOfWords.add(currentLine);
                        currentLine = new LinkedList();
                    }
                    currentLine.add(word.substring(0, rowLength));
                    word = word.substring(rowLength);
                }
                this.linesOfWords.add(currentLine);
                currentLine = new LinkedList();
                if (word.length() > 0) {
                    currentLine.add(word);
                    currentLength = word.length();
                    continue;
                }
                currentLength = -1;
            }
            if (!currentLine.isEmpty()) {
                this.linesOfWords.add(currentLine);
            }
        }

        int numOfLines() {
            return this.linesOfWords.size();
        }

        int lastLineLength() {
            return this.lineLength((List<String>)this.linesOfWords.getLast());
        }

        private int lineLength(List<String> line) {
            int result = line.size() - 1;
            for (String word : line) {
                result += word.length();
            }
            return result;
        }

        boolean canWrap() {
            if (this.linesOfWords.size() > 1) {
                ListIterator<LinkedList<String>> it = this.linesOfWords.listIterator(this.linesOfWords.size() - 1);
                while (it.hasPrevious()) {
                    if (this.lineLength((List<String>)it.previous()) >= this.rowLenght - 1) continue;
                    return true;
                }
            }
            return false;
        }

        void wrap() {
            if (this.linesOfWords.size() > 1) {
                ListIterator<LinkedList<String>> it = this.linesOfWords.listIterator(this.linesOfWords.size() - 1);
                while (it.hasPrevious()) {
                    int originalLenght = this.lineLength((List<String>)it.previous());
                    if (originalLenght >= this.rowLenght - 1) continue;
                    LinkedList<String> wrappingLine = it.next();
                    LinkedList<String> followingLine = it.next();
                    int capacity = this.rowLenght - originalLenght;
                    while (capacity > 1 && !followingLine.isEmpty()) {
                        String prefix;
                        String word = followingLine.removeFirst();
                        if (this.wordFragments.contains(wrappingLine.getLast())) {
                            if (word.length() > capacity) {
                                prefix = word.substring(0, capacity);
                                String mergedWord = wrappingLine.removeLast() + prefix;
                                this.wordFragments.add(mergedWord);
                                followingLine.addFirst(word.substring(capacity));
                                break;
                            }
                            String mergedWord = wrappingLine.removeLast() + word;
                            wrappingLine.addLast(mergedWord);
                            if (this.wordFragments.contains(word)) {
                                this.wordFragments.add(mergedWord);
                            }
                            capacity -= word.length();
                            continue;
                        }
                        if (word.length() + 1 > capacity) {
                            prefix = word.substring(0, capacity - 1);
                            wrappingLine.add(prefix);
                            String postfix = word.substring(capacity - 1);
                            followingLine.addFirst(postfix);
                            this.wordFragments.add(prefix);
                            break;
                        }
                        wrappingLine.add(word);
                        capacity -= word.length() + 1;
                    }
                    if (followingLine.isEmpty()) {
                        it.remove();
                    }
                    return;
                }
            }
            throw new IllegalStateException();
        }

        boolean canJoin() {
            return this.lineLength((List<String>)this.linesOfWords.getLast()) < this.rowLenght - 1;
        }

        void join(Paragraph paragraph) {
            for (LinkedList linkedList : paragraph.linesOfWords) {
                this.linesOfWords.add(linkedList);
            }
            this.wordFragments.addAll((Collection<String>)paragraph.wordFragments);
            this.wrap();
        }

        void trunc(int numOfLines, int numOfLastLineChars) {
            LinkedList<String> lastRow;
            if (numOfLines + 1 < this.linesOfWords.size()) {
                this.linesOfWords = new LinkedList(this.linesOfWords.subList(0, numOfLines + 1));
            }
            if (this.lineLength(lastRow = this.linesOfWords.getLast()) > numOfLastLineChars) {
                int currentLength = -1;
                ListIterator<String> it = lastRow.listIterator();
                while (it.hasNext()) {
                    String word = (String)it.next();
                    if (currentLength + 1 + word.length() <= numOfLastLineChars) {
                        currentLength += 1 + word.length();
                        continue;
                    }
                    if (currentLength + 1 < numOfLastLineChars) {
                        it.set(word.substring(0, numOfLastLineChars - currentLength - 1));
                    } else {
                        it.remove();
                    }
                    while (it.hasNext()) {
                        it.next();
                        it.remove();
                    }
                    break block0;
                }
            }
        }

        void generateHTML(int x, int y, float width, float height, NodeSet nodeSet) {
            ListIterator it = this.linesOfWords.listIterator();
            while (it.hasNext()) {
                int inlineOffset = 0;
                for (String word : (LinkedList)it.next()) {
                    for (int i = 0; i < word.length(); ++i) {
                        Element div = document.createElementNS("http://www.w3.org/1999/xhtml", "div");
                        div.appendChild(document.createTextNode(String.valueOf(word.charAt(i))));
                        div.setAttribute("style", "left:" + (x + (int)((float)(inlineOffset + i) * width)) + "px;top:" + (y + (int)((float)it.previousIndex() * height)) + "px;width:" + (int)width + "px;text-align:center;text-transform:capitalize");
                        nodeSet.addNode((Node)div);
                    }
                    inlineOffset += word.length() + 1;
                }
            }
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            for (LinkedList linkedList : this.linesOfWords) {
                result.append('(');
                for (String word : linkedList) {
                    result.append(word).append(' ');
                }
                result.setCharAt(result.length() - 1, ')');
            }
            return result.toString();
        }
    }

    static class TextDocument {
        LinkedList<Paragraph> paragraphs = new LinkedList();
        int rowLength;

        TextDocument(int rowLenght) {
            this.rowLength = rowLenght;
        }

        void add(String paragraph) {
            this.paragraphs.add(new Paragraph(paragraph, this.rowLength));
        }

        int numOfLines() {
            int result = 0;
            for (Paragraph paragraph : this.paragraphs) {
                result += paragraph.numOfLines();
            }
            return result;
        }

        int lastLineLength() {
            if (!this.paragraphs.isEmpty()) {
                return this.paragraphs.getLast().lastLineLength();
            }
            return 0;
        }

        boolean canWrapParagraph() {
            for (Paragraph paragraph : this.paragraphs) {
                if (!paragraph.canWrap()) continue;
                return true;
            }
            return false;
        }

        void wrapParagraph() {
            ListIterator<Paragraph> it = this.paragraphs.listIterator(this.paragraphs.size());
            while (it.hasPrevious()) {
                Paragraph paragraph = it.previous();
                if (!paragraph.canWrap()) continue;
                paragraph.wrap();
                return;
            }
            throw new IllegalStateException();
        }

        boolean canJoinParagraphs() {
            if (this.paragraphs.size() > 1) {
                ListIterator<Paragraph> it = this.paragraphs.listIterator(this.paragraphs.size() - 1);
                while (it.hasPrevious()) {
                    if (!it.previous().canJoin()) continue;
                    return true;
                }
            }
            return false;
        }

        void joinParagraphs() {
            if (this.paragraphs.size() > 1) {
                ListIterator<Paragraph> it = this.paragraphs.listIterator(this.paragraphs.size() - 1);
                while (it.hasPrevious()) {
                    if (!it.previous().canJoin()) continue;
                    it.next().join(it.next());
                    it.remove();
                    return;
                }
            }
            throw new IllegalStateException();
        }

        void trunc(int numOfLines, int numOfLastLineChars) {
            ListIterator it = this.paragraphs.listIterator();
            while (it.hasNext()) {
                int index = it.nextIndex();
                Paragraph paragraph = (Paragraph)it.next();
                if (paragraph.numOfLines() > numOfLines + 1) {
                    paragraph.trunc(numOfLines, numOfLastLineChars);
                    this.paragraphs = new LinkedList(this.paragraphs.subList(0, index + 1));
                    break;
                }
                if (paragraph.numOfLines() == numOfLines + 1) {
                    if (paragraph.lastLineLength() > numOfLastLineChars) {
                        paragraph.trunc(numOfLines, numOfLastLineChars);
                    }
                    this.paragraphs = new LinkedList(this.paragraphs.subList(0, index + 1));
                    break;
                }
                numOfLines -= paragraph.numOfLines();
            }
        }

        void doLayout(int rowCount, int remainder) {
            while (this.numOfLines() > rowCount + 1 || this.numOfLines() == rowCount + 1 && this.lastLineLength() > remainder) {
                if (this.canWrapParagraph()) {
                    this.wrapParagraph();
                    continue;
                }
                if (this.canJoinParagraphs()) {
                    this.joinParagraphs();
                    continue;
                }
                this.trunc(rowCount, remainder);
                break;
            }
        }

        void generateHTML(int x, int y, float width, float height, NodeSet nodeSet) {
            ListIterator it = this.paragraphs.listIterator();
            while (it.hasNext()) {
                Paragraph paragraph = (Paragraph)it.next();
                paragraph.generateHTML(x, y, width, height, nodeSet);
                y = (int)((float)y + (float)paragraph.numOfLines() * height);
            }
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            for (Paragraph paragraph : this.paragraphs) {
                result.append('[').append(paragraph).append(']');
            }
            return result.toString();
        }
    }
}

