/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.webserver;

import com.selima.fbi.util.RewritingOutputStream;
import com.selima.fbi.webserver.ResourceResolver;
import com.selima.framework.util.logging.LogAPI;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTExecutor {
    public static final boolean USE_STYLESHEET = true;
    final TransformerFactory transformerFactory;
    final ResourceResolver resourceResolver;

    public XSLTExecutor(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        this.transformerFactory = TransformerFactory.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderXML(Reader data, String stylesheet, Writer out) throws IOException {
        try (StylesheetURIResolver resolver = new StylesheetURIResolver(stylesheet);){
            this.transformerFactory.setURIResolver(resolver);
            try (InputStream stylesheetStream = this.resourceResolver.resourceStream(stylesheet);){
                System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
                Transformer tf = this.transformerFactory.newTransformer(new StreamSource(stylesheetStream));
                try {
                    tf.transform(new StreamSource(data), new StreamResult(out));
                }
                finally {
                    out.flush();
                }
            }
        }
        catch (TransformerException e) {
            LogAPI.logSevere((Throwable)e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderHTML(Reader data, String stylesheet, Writer out, Map<String, Object> params) throws IOException {
        try (StylesheetURIResolver resolver = new StylesheetURIResolver(stylesheet);){
            this.transformerFactory.setURIResolver(resolver);
            InputStream stylesheetStream = this.resourceResolver.resourceStream(stylesheet);
            RewritingOutputStream stream = new RewritingOutputStream(out);
            stream.setPath(this.relativePath(stylesheet));
            try {
                System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
                Transformer tf = this.transformerFactory.newTransformer(new StreamSource(stylesheetStream));
                if (params != null) {
                    for (Map.Entry<String, Object> entry : params.entrySet()) {
                        tf.setParameter(entry.getKey(), entry.getValue());
                    }
                }
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");){
                    this.transform(tf, data, writer);
                }
                finally {
                    stream.close();
                }
            }
            finally {
                stylesheetStream.close();
            }
        }
        catch (TransformerConfigurationException e) {
            this.copy(data, out);
            LogAPI.logSevere((Throwable)e.getCause());
        }
        catch (XSLTException e) {
            this.copy(data, out);
            LogAPI.logSevere((Throwable)e.getCause());
        }
        catch (IOException e) {
            this.copy(data, out);
            LogAPI.logSevere((Throwable)e);
        }
        finally {
            data.close();
        }
    }

    protected void transform(Transformer transformer, Reader input, Writer output) throws XSLTException, IOException {
        try {
            transformer.transform(new StreamSource(input), new StreamResult(output));
        }
        catch (TransformerException ex) {
            throw new XSLTException(ex);
        }
    }

    private String relativePath(String stylesheet) {
        return "/classpath" + stylesheet.substring(0, stylesheet.lastIndexOf(47) + 1);
    }

    private void copy(Reader reader, Writer out) throws IOException {
        int count;
        char[] chars = new char[2048];
        while ((count = reader.read(chars)) > 0) {
            out.write(chars, 0, count);
        }
    }

    static class XSLTException
    extends Exception {
        XSLTException(Exception cause) {
            super(cause);
        }
    }

    class StylesheetURIResolver
    implements URIResolver {
        final List<InputStream> resources = new LinkedList<InputStream>();
        String styleSheet;

        StylesheetURIResolver(String styleSheet) {
            this.styleSheet = styleSheet;
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            try {
                StringBuilder text = new StringBuilder(this.styleSheet);
                text.setLength(text.lastIndexOf("/") + 1);
                text.append(href);
                InputStream resourceStream = XSLTExecutor.this.resourceResolver.resourceStream(text.toString());
                this.resources.add(resourceStream);
                return new StreamSource(resourceStream);
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
        }

        void close() {
            for (InputStream stream : this.resources) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

