/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.webserver;

import com.selima.fbi.FormType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

class StylesheetRepository {
    StylesheetRepository() {
    }

    static List<String> get(FormType type, String namespace, int taxYearEnd, Date issueDate) {
        switch (type) {
            case P6: 
            case P6B: {
                if (issueDate.after(new GregorianCalendar(2015, 3, 19).getTime())) {
                    return Collections.singletonList("/templates/DPS/p6_dps_2007_19.4.2015.xsl");
                }
                return Collections.singletonList("/templates/DPS/p6_dps_2007.xsl");
            }
            case P9: {
                if (issueDate.after(new GregorianCalendar(2015, 3, 19).getTime())) {
                    return Collections.singletonList("/templates/DPS/p9_dps_2007_19.4.2015.xsl");
                }
                return Collections.singletonList("/templates/DPS/p9_dps_2007.xsl");
            }
            case AR1n: 
            case AR2n: 
            case AR6: 
            case ARmn: 
            case AR1mn: 
            case AR2mn: {
                if (issueDate.after(new GregorianCalendar(2015, 3, 19).getTime())) {
                    return Collections.singletonList("/templates/DPS/reminders_dps_2006_19.4.2015.xsl");
                }
                if (issueDate.after(new GregorianCalendar(2008, 7, 12).getTime())) {
                    return Collections.singletonList("/templates/DPS/reminders_dps_2006_12.8.2008.xsl");
                }
                return Collections.singletonList("/templates/DPS/reminders_dps_2006.xsl");
            }
            case ILEA: 
            case ILEB: 
            case ILEC: 
            case ILED: 
            case P11Db: 
            case P35Not: {
                if (issueDate.after(new GregorianCalendar(2015, 3, 19).getTime())) {
                    return Collections.singletonList("/templates/DPS/notifications_dps_2006_19.4.2015.xsl");
                }
                if (issueDate.after(new GregorianCalendar(2008, 7, 12).getTime())) {
                    return Collections.singletonList("/templates/DPS/notifications_dps_2006_12.8.2008.xsl");
                }
                return Collections.singletonList("/templates/DPS/notifications_dps_2006.xsl");
            }
            case SL1: {
                if (issueDate.after(new GregorianCalendar(2019, 3, 19).getTime())) {
                    return Collections.singletonList("/templates/DPS/sl1_dps_19.4.2019.xsl");
                }
                if (issueDate.after(new GregorianCalendar(2015, 3, 19).getTime())) {
                    return Collections.singletonList("/templates/DPS/sl1_dps_19.4.2015.xsl");
                }
                return Collections.singletonList("/templates/DPS/sl1_dps.xsl");
            }
            case PGL1: {
                return Collections.singletonList("/templates/DPS/pgl1_dps.xsl");
            }
            case PGL2: {
                return Collections.singletonList("/templates/DPS/pgl2_dps.xsl");
            }
            case SL2: {
                if (issueDate.after(new GregorianCalendar(2019, 3, 19).getTime())) {
                    return Collections.singletonList("/templates/DPS/sl2_dps_19.4.2019.xsl");
                }
                if (issueDate.after(new GregorianCalendar(2015, 3, 19).getTime())) {
                    return Collections.singletonList("/templates/DPS/sl2_dps_19.4.2015.xsl");
                }
                return Collections.singletonList("/templates/DPS/sl2_dps.xsl");
            }
            case NOT: 
            case NVR: {
                return Collections.singletonList("/templates/DPS/rtinot_dps.xsl");
            }
            case GEN: {
                return Collections.singletonList("/templates/DPS/gen_dps.xsl");
            }
            case P14Part: {
                if (taxYearEnd > 2013) {
                    taxYearEnd = 2013;
                }
                return Collections.singletonList("/templates/PAYE/P14(" + taxYearEnd + ").xsl");
            }
            case EOY: {
                if (taxYearEnd > 2013) {
                    taxYearEnd = 2013;
                }
                return Arrays.asList("/templates/PAYE/P35(" + taxYearEnd + ").xsl", "/templates/PAYE/P14(" + taxYearEnd + ").xsl");
            }
            case P35Part: {
                if (taxYearEnd > 2013) {
                    taxYearEnd = 2013;
                }
                return Collections.singletonList("/templates/PAYE/P35(" + taxYearEnd + ").xsl");
            }
            case P46: {
                if ("http://www.govtalk.gov.uk/taxation/MOV".equals(namespace)) {
                    return Collections.singletonList("/templates/PAYE/P46(2006).xsl");
                }
                if ("http://www.govtalk.gov.uk/taxation/PAYE/MOV/08-09/1".equals(namespace)) {
                    return Collections.singletonList("/templates/PAYE/P46(2009).xsl");
                }
                if ("http://www.govtalk.gov.uk/taxation/PAYE/MOV/09-10/1".equals(namespace)) {
                    return Collections.singletonList("/templates/PAYE/P46(2010).xsl");
                }
            }
            case P45Part1: {
                if ("http://www.govtalk.gov.uk/taxation/MOV".equals(namespace)) {
                    return Collections.singletonList("/templates/PAYE/P45Part1(2006).xsl");
                }
                if ("http://www.govtalk.gov.uk/taxation/PAYE/MOV/08-09/1".equals(namespace)) {
                    return Collections.singletonList("/templates/PAYE/P45Part1(2009).xsl");
                }
                if ("http://www.govtalk.gov.uk/taxation/PAYE/MOV/09-10/1".equals(namespace)) {
                    return Collections.singletonList("/templates/PAYE/P45Part1(2010).xsl");
                }
            }
            case P45Part3: {
                if ("http://www.govtalk.gov.uk/taxation/MOV".equals(namespace)) {
                    return Collections.singletonList("/templates/PAYE/P45Part3(2006).xsl");
                }
                if ("http://www.govtalk.gov.uk/taxation/PAYE/MOV/08-09/1".equals(namespace)) {
                    return Collections.singletonList("/templates/PAYE/P45Part3(2009).xsl");
                }
                if ("http://www.govtalk.gov.uk/taxation/PAYE/MOV/09-10/1".equals(namespace)) {
                    return Collections.singletonList("/templates/PAYE/P45Part3(2010).xsl");
                }
            }
            case PENNOT: {
                return Collections.singletonList("/templates/PAYE/PENNOT(2006).xsl");
            }
            case WNU: {
                return Collections.singletonList("/templates/PAYE/WNU(Anthony).xsl");
            }
            case EAS: {
                if ("http://www.govtalk.gov.uk/taxation/PAYE/RTI/EmployerAlignmentSubmission/3".equals(namespace)) {
                    return Collections.singletonList("/templates/PAYE/EAS(2014).xsl");
                }
                if ("http://www.govtalk.gov.uk/taxation/PAYE/RTI/EmployerAlignmentSubmission/2".equals(namespace)) {
                    return Collections.singletonList("/templates/PAYE/EAS(2013).xsl");
                }
                throw new IllegalArgumentException("No rendering for EAS (" + namespace + ")");
            }
            case EPS: {
                if ("http://www.govtalk.gov.uk/taxation/PAYE/RTI/2".equals(namespace)) {
                    return Collections.singletonList("/templates/PAYE/EPS(2013).xsl");
                }
                return Collections.singletonList("/templates/PAYE/EPS(" + taxYearEnd + ").xsl");
            }
            case FPS: {
                return Collections.singletonList("/templates/PAYE/FPS(" + taxYearEnd + ").xsl");
            }
            case NINOVR: {
                if ("http://www.govtalk.gov.uk/taxation/PAYE/RTI/NINOverificationRequest/1".equals(namespace)) {
                    return Collections.singletonList("/templates/PAYE/NINOVR(2014).xsl");
                }
                if ("http://www.govtalk.gov.uk/taxation/PAYE/RTI/2".equals(namespace)) {
                    return Collections.singletonList("/templates/PAYE/NINOVR(2013).xsl");
                }
                throw new IllegalArgumentException("No rendering for NINOVR (" + namespace + ")");
            }
            case EYU: {
                return Collections.singletonList("/templates/PAYE/EYU(" + taxYearEnd + ").xsl");
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)type));
    }
}

