/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.webserver;

import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.webserver.BasicResource;
import com.selima.fbi.webserver.ClasspathResourceResolver;
import com.selima.fbi.webserver.PagePart;
import com.selima.fbi.webserver.ResourceResolver;
import com.selima.fbi.webserver.WebServerException;
import com.selima.fbi.webserver.XSLTExecutor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import java.util.Map;

abstract class MailMessageResource
extends BasicResource {
    int refCount;
    byte[] bytes;
    IMailMessage message;
    XSLTExecutor executor;
    ResourceResolver resourceResolver;

    MailMessageResource(IMailMessage message) throws WebServerException {
        this(message, new ClasspathResourceResolver());
    }

    MailMessageResource(IMailMessage message, ResourceResolver resourceResolver) {
        this.message = message;
        this.resourceResolver = resourceResolver;
        this.executor = new XSLTExecutor(resourceResolver);
    }

    abstract Map<String, List<PagePart>> getPages() throws IOException;

    void incrementRefCount() {
        ++this.refCount;
    }

    int decrementRefCount() {
        return --this.refCount;
    }

    @Override
    public void writeContent(Map<String, Object> params, Writer out) throws IOException {
        this.executor.renderHTML(this.getReader(params), this.getStylesheetPath(params), out, params);
    }

    abstract String getStylesheetPath(Map<String, Object> var1) throws IOException;

    IMailMessage getMessage() {
        return this.message;
    }

    Reader getReader(Map<String, Object> params) throws IOException {
        try {
            if (this.bytes == null) {
                this.bytes = this.message.getBytes();
            }
            return new InputStreamReader((InputStream)new ByteArrayInputStream(this.bytes), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

