/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.webserver;

import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.webserver.DPSMessageResource;
import com.selima.fbi.webserver.LocalServer;
import com.selima.fbi.webserver.MailMessageResource;
import com.selima.fbi.webserver.PAYEMessageResource;
import com.selima.fbi.webserver.PagePart;
import com.selima.fbi.webserver.WebServer;
import com.selima.fbi.webserver.WebServerException;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class JettyWebServer
implements WebServer {
    List<MailMessageResource> resources = new LinkedList<MailMessageResource>();

    public JettyWebServer() throws WebServerException {
        LocalServer ls = LocalServer.getInstance();
        if (!ls.isContextInstalled("mails")) {
            ls.installResourceContext("mails");
        }
        if (!ls.isContextInstalled("classpath")) {
            ls.installClasspathContext("classpath");
        }
    }

    @Override
    public void showMessage(IMailMessage message) throws WebServerException {
        ListIterator<MailMessageResource> it = this.resources.listIterator();
        while (it.hasNext()) {
            if (it.next().getMessage() != message) continue;
            MailMessageResource resource = it.previous();
            resource.incrementRefCount();
            return;
        }
        if (message instanceof IDPSMessage) {
            this.showMessage(new DPSMessageResource((IDPSMessage)message));
        } else if (message instanceof IPAYEMessage) {
            this.showMessage(new PAYEMessageResource((IPAYEMessage)message));
        } else {
            throw new IllegalArgumentException(String.valueOf(message));
        }
    }

    @Override
    public URL classpathURL(String path) {
        LocalServer ls = LocalServer.getInstance();
        return ls.getClasspathURL("classpath", path);
    }

    @Override
    public int pageCount(IMailMessage message) throws WebServerException, IOException {
        this.showMessage(message);
        try {
            int n = this.listPages(message).size();
            return n;
        }
        finally {
            this.hideMessage(message);
        }
    }

    private URL showMessage(MailMessageResource resource) throws WebServerException {
        LocalServer ls = LocalServer.getInstance();
        URL result = ls.createResourceURL("mails", resource);
        resource.setURL(result);
        this.resources.add(resource);
        resource.incrementRefCount();
        return result;
    }

    @Override
    public void hideMessage(IMailMessage message) {
        ListIterator<MailMessageResource> it = this.resources.listIterator();
        while (it.hasNext()) {
            if (it.next().getMessage() != message) continue;
            MailMessageResource resource = it.previous();
            if (resource.decrementRefCount() == 0) {
                LocalServer ls = LocalServer.getInstance();
                ls.deleteResourceURL("mails", resource);
                it.remove();
            }
            return;
        }
    }

    @Override
    public Map<String, List<PagePart>> listPages(IMailMessage message) throws IOException {
        for (MailMessageResource resource : this.resources) {
            if (resource.getMessage() != message) continue;
            return resource.getPages();
        }
        throw new IllegalArgumentException("Message not found");
    }
}

