/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.webserver;

import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.webserver.InjectingReader;
import com.selima.fbi.webserver.MailMessageResource;
import com.selima.fbi.webserver.PagePart;
import com.selima.fbi.webserver.StylesheetRepository;
import com.selima.fbi.webserver.WebServerException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class DPSMessageResource
extends MailMessageResource {
    static String PROLOG = "<ns0:DPSdata xmlns:ns0='http://www.govtalk.gov.uk/taxation/DPSwrapper/1'><ns0:DPSheader><ns0:Service>PAYE</ns0:Service><ns0:EntityType>EmpRef</ns0:EntityType><ns0:Entity>123/A6</ns0:Entity><ns0:DataType>P9</ns0:DataType><ns0:Got>0</ns0:Got><ns0:NItems>20</ns0:NItems><ns0:VendorID>0190</ns0:VendorID><ns0:MoreData>false</ns0:MoreData><ns0:HighWaterMark>49</ns0:HighWaterMark><ns0:NItemsReturned>8</ns0:NItemsReturned><ns0:Timestamp>2006-03-09T17:57:20.073Z</ns0:Timestamp></ns0:DPSheader>";
    static String EPILOG = "</ns0:DPSdata>";

    DPSMessageResource(IDPSMessage message) throws WebServerException {
        super(message);
    }

    @Override
    Map<String, List<PagePart>> getPages() {
        return Collections.singletonMap("Default", new ArrayList<PagePart>(Collections.singletonList(new PagePart(this.message.getSubject(), "1", this.getURL()))));
    }

    @Override
    String getStylesheetPath(Map<String, Object> params) {
        return StylesheetRepository.get(this.message.getFormType(), this.message.getNamespace(), this.message.getTaxYearEnd(), this.message.getIssueDate()).get(0);
    }

    @Override
    Reader getReader(Map<String, Object> params) throws IOException {
        return new InjectingReader(super.getReader(params), PROLOG, EPILOG);
    }
}

