/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReflectionUtil {
    static Map<Class<?>, Set<Class<?>>> cachedInterfaces = new HashMap(32);

    public static Class<?>[] getInterfaces(Object original) {
        return ReflectionUtil.getInterfaces(original.getClass());
    }

    public static Class<?>[] getInterfaces(Class<?> originalType) {
        Set<Class<?>> set = ReflectionUtil.getInterfaceSetInternal(originalType);
        return set.toArray(new Class[set.size()]);
    }

    public static Set<Class<?>> getInterfacesSet(Object original) {
        return ReflectionUtil.getInterfacesSet(original.getClass());
    }

    public static Set<Class<?>> getInterfacesSet(Class<?> originalType) {
        return new HashSet(ReflectionUtil.getInterfaceSetInternal(originalType));
    }

    private static Set<Class<?>> getInterfaceSetInternal(Class<?> originalType) {
        Set<Class<?>> result = cachedInterfaces.get(originalType);
        if (result == null) {
            result = new HashSet(4);
            if (originalType.isInterface()) {
                result.add(originalType);
            }
            for (Class<?> type = originalType; type != Object.class && type != null; type = type.getSuperclass()) {
                result.addAll(Arrays.asList(type.getInterfaces()));
            }
            cachedInterfaces.put(originalType, result);
        }
        return result;
    }

    public static <T> T invokeGetter(Object source, Class<T> target, String ... getters) {
        return ReflectionUtil.invokeGetter(source, target, Arrays.asList(getters));
    }

    public static <T> T invokeGetter(Object source, Class<T> target, List<String> getters) {
        return ReflectionUtil.invokeChain(source, getters, target);
    }

    public static void invokeSetter(Object source, List<String> path, Class<?> type, Object value) throws InvocationTargetException {
        Object target = ReflectionUtil.invokeGetter(source, Object.class, path.subList(0, path.size() - 1));
        try {
            target.getClass().getMethod(path.get(path.size() - 1), type).invoke(target, value);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T invokeChain(Object source, List<String> path, Class<T> returnType) {
        Object value = source;
        for (String method : path) {
            try {
                value = value.getClass().getMethod(method, new Class[0]).invoke(value, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(method + " on " + source.getClass(), e);
            }
        }
        return returnType.cast(value);
    }

    public static <T> T getFieldValue(Object object, Class<T> type, String ... fields) {
        block5: for (String fieldName : fields) {
            Class<?> c = object.getClass();
            while (true) {
                try {
                    Field fieldOject = c.getDeclaredField(fieldName);
                    fieldOject.setAccessible(true);
                    object = fieldOject.get(object);
                    continue block5;
                }
                catch (SecurityException e) {
                    throw new IllegalStateException();
                }
                catch (NoSuchFieldException e) {
                    if (c == Object.class) {
                        throw new IllegalArgumentException(object + " lacks [" + fieldName + "]");
                    }
                    c = c.getSuperclass();
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                break;
            }
        }
        return type.cast(object);
    }
}

