/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.util;

import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;

public class NetUtil {
    public static void unwrapConnectException(RemoteException e) throws ConnectException, RemoteException {
        IOException netException = NetUtil.getConnectivityException(e);
        if (netException instanceof ConnectException) {
            throw (ConnectException)netException;
        }
        if (netException != null) {
            ConnectException connectException = new ConnectException(netException.getMessage());
            connectException.initCause(netException);
            throw connectException;
        }
    }

    public static URL addURL(URL source, String name, String value) {
        try {
            return new URL(source.getProtocol(), source.getHost(), source.getPort(), source.getQuery() != null ? source.getFile() + '&' + name + '=' + value : '?' + name + '=' + value);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isConnectivityProblem(Throwable tw) {
        return NetUtil.getConnectivityException(tw) != null;
    }

    private static IOException getConnectivityException(Throwable remoteException) {
        for (Throwable cause = remoteException; cause != null; cause = cause.getCause()) {
            if (cause instanceof ConnectException) {
                return (ConnectException)cause;
            }
            if (cause instanceof UnknownHostException) {
                return (UnknownHostException)cause;
            }
            if (!(cause instanceof NoRouteToHostException)) continue;
            return (NoRouteToHostException)cause;
        }
        return null;
    }
}

