/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.user;

import com.selima.fbi.CancelException;
import com.selima.fbi.plugin.PluginType;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.fbi.storage.Transaction;
import com.selima.fbi.user.IUser;
import com.selima.fbi.user.IUserManager;
import com.selima.fbi.user.UserImpl;
import java.io.IOException;

public class UserManager
implements IUserManager {
    PluginType defaultPluginType;
    IStorageFactory storageFactory;

    public UserManager(IStorageFactory storageFactory) {
        this.storageFactory = storageFactory;
    }

    @Override
    public void setDetaultPluginType(PluginType pluginType) {
        this.defaultPluginType = pluginType;
    }

    @Override
    public IUser createUser(String login, String password) {
        UserImpl result = new UserImpl();
        result.setLogin(login);
        result.setPassword(password);
        result.setStoreId(login);
        result.setDefaultPluginType(this.defaultPluginType);
        return result;
    }

    @Override
    public IUser getUser(final String login) throws IOException, CancelException {
        return new Transaction(this.storageFactory).run(new Transaction.InteractionR0<IUser>(){

            @Override
            public IUser run() throws IOException, CancelException {
                IStorage<UserImpl> storage = UserManager.this.getStorage();
                if (storage.contains(login)) {
                    UserImpl result = storage.load(login);
                    result.setDefaultPluginType(UserManager.this.defaultPluginType);
                    result.setStoreId(login);
                    return result;
                }
                for (String existingId : storage.getIds()) {
                    UserImpl user = storage.load(existingId);
                    if (!login.equals(user.getNick())) continue;
                    user.setDefaultPluginType(UserManager.this.defaultPluginType);
                    user.setStoreId(existingId);
                    return user;
                }
                return null;
            }
        });
    }

    @Override
    public IUser[] getUsers() throws IOException, CancelException {
        return new Transaction(this.storageFactory).run(new Transaction.InteractionR0<IUser[]>(){

            @Override
            public IUser[] run() throws IOException, CancelException {
                IStorage<UserImpl> storage = UserManager.this.getStorage();
                String[] ids = storage.getIds();
                IUser[] users = new IUser[ids.length];
                for (int i = 0; i < ids.length; ++i) {
                    users[i] = storage.load(ids[i]);
                }
                return users;
            }
        });
    }

    @Override
    public void saveUser(IUser user) throws IOException, CancelException {
        this.getStorage().store((UserImpl)user);
    }

    IStorage<UserImpl> getStorage() throws IOException, CancelException {
        return this.storageFactory.getStorage("users", UserImpl.class);
    }
}

