/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.user;

import com.selima.fbi.CancelException;
import com.selima.fbi.storage.IStorage;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.fbi.storage.Transaction;
import com.selima.fbi.user.DefaultServerSpec;
import com.selima.fbi.user.FullReference;
import com.selima.fbi.user.IFullReference;
import com.selima.fbi.user.IReferenceManager;
import com.selima.fbi.user.PayrollServerSpec;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ReferenceManager
implements IReferenceManager {
    Map<String, FullReference> references = new HashMap<String, FullReference>();
    DefaultServerSpec defaultServer = new DefaultServerSpec();
    final IStorageFactory storageFactory;
    final IStorage<FullReference> refStorage;
    final IStorage<DefaultServerSpec> defStorage;

    public ReferenceManager(IStorageFactory factory) throws IOException, CancelException {
        this.storageFactory = factory;
        this.refStorage = factory.getStorage("reference", FullReference.class);
        this.defStorage = factory.getStorage("default-payroll", DefaultServerSpec.class);
    }

    @Override
    public void load() throws IOException, CancelException {
        new Transaction(this.storageFactory).run(new Transaction.InteractionV0(){

            @Override
            public void run() throws IOException, CancelException {
                if (ReferenceManager.this.defStorage.contains(ReferenceManager.this.defaultServer.getStoreId())) {
                    ReferenceManager.this.defaultServer = ReferenceManager.this.defStorage.load(ReferenceManager.this.defaultServer.getStoreId());
                }
                ReferenceManager.this.references.clear();
                for (String id : ReferenceManager.this.refStorage.getIds()) {
                    FullReference reference = ReferenceManager.this.refStorage.load(id);
                    ReferenceManager.this.references.put(reference.getEmpRef(), reference);
                }
            }
        });
    }

    @Override
    public IFullReference getFullReference(String empRef) {
        FullReference reference = this.references.get(empRef);
        if (reference == null) {
            reference = new FullReference(empRef);
            int freeLock = this.findFreeTaskLock();
            reference.setTaskLock(freeLock);
            this.references.put(empRef, reference);
        }
        return reference;
    }

    @Override
    public PayrollServerSpec getPayrollServer(String empRef) {
        IFullReference reference = this.getFullReference(empRef);
        if (reference != null && reference.isPayrollServerDefined()) {
            return reference.toPayrollServerSpec();
        }
        return this.getDefaultServer();
    }

    @Override
    public void save() throws IOException, CancelException {
        new Transaction(this.storageFactory).run(new Transaction.InteractionV0(){

            @Override
            public void run() throws IOException, CancelException {
                ReferenceManager.this.defStorage.store(ReferenceManager.this.defaultServer);
                for (FullReference ref : ReferenceManager.this.references.values()) {
                    ReferenceManager.this.refStorage.store(ref);
                }
            }
        });
    }

    @Override
    public PayrollServerSpec getDefaultServer() {
        return this.defaultServer;
    }

    private int findFreeTaskLock() {
        int[] locks = new int[64];
        for (FullReference ref : this.references.values()) {
            Integer lock = ref.getTaskLock();
            if (lock == null) continue;
            int n = lock;
            locks[n] = locks[n] + 1;
        }
        int freeLock = 0;
        int minimum = Integer.MAX_VALUE;
        for (int i = 0; i < locks.length; ++i) {
            if (locks[i] >= minimum) continue;
            minimum = locks[i];
            freeLock = i;
        }
        return freeLock;
    }
}

