/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.user;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class PropertiesAdapter
extends XmlAdapter<PropertiesBoundType, Properties> {
    public PropertiesBoundType marshal(Properties properties) throws Exception {
        return properties == null || properties.isEmpty() ? null : new PropertiesBoundType(properties);
    }

    public Properties unmarshal(PropertiesBoundType mapType) throws Exception {
        return mapType == null ? new Properties() : mapType.toProperties();
    }

    public static class PropertyType {
        @XmlAttribute
        public String key;
        @XmlAttribute
        public String value;

        public PropertyType() {
        }

        public PropertyType(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class PropertiesBoundType {
        @XmlElement(name="Property")
        List<PropertyType> entries;

        public PropertiesBoundType() {
        }

        public PropertiesBoundType(Properties properties) {
            this.entries = new ArrayList<PropertyType>(properties.size());
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.entries.add(new PropertyType(entry.getKey().toString(), entry.getValue().toString()));
            }
        }

        Properties toProperties() {
            Properties result = new Properties();
            for (PropertyType entry : this.entries) {
                result.setProperty(entry.key, entry.value);
            }
            return result;
        }
    }
}

