/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.user;

import com.selima.fbi.storage.IStorable;
import com.selima.fbi.user.IFullReference;
import com.selima.fbi.user.PayrollServerSpec;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class FullReference
implements IStorable,
IFullReference {
    @XmlAttribute(required=true)
    String empRef;
    @XmlElement
    String description;
    @XmlElement
    String host;
    @XmlElement
    String account;
    @XmlElement
    String user;
    @XmlElement
    String password;
    @XmlElement
    Integer port;
    @XmlElement
    Integer taskLock;

    public FullReference() {
    }

    public FullReference(String empRef, String host, String user, String password, String account, String description, Integer port, Integer taskLock) {
        this.empRef = empRef;
        this.host = host;
        this.user = user;
        this.password = password;
        this.account = account;
        this.description = description;
        this.port = port;
        this.taskLock = taskLock;
    }

    public FullReference(IFullReference ref) {
        this(ref.getEmpRef(), ref.getHost(), ref.getUser(), ref.getPassword(), ref.getAccount(), ref.getDescription(), ref.getPort(), ref.getTaskLock());
    }

    public FullReference(String empRef) {
        this.empRef = empRef;
    }

    @Override
    public String getEmpRef() {
        return this.empRef;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getAccount() {
        return this.account;
    }

    @Override
    public void setAccount(String account) {
        this.account = account;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public void setPort(Integer port) {
        this.port = port;
    }

    public String toString() {
        return this.empRef + "," + this.host + "," + this.port + "," + this.user + "," + this.password + "," + this.account + "," + this.description + "," + this.taskLock;
    }

    @Override
    public boolean isPayrollServerDefined() {
        return this.toPayrollServerSpec().isSufficient();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FullReference) {
            FullReference other = (FullReference)obj;
            Object[] otherParts = new Object[]{other.empRef, other.host, other.user, other.password, other.account, other.description, other.port, other.taskLock};
            Object[] thisParts = new Object[]{this.empRef, this.host, this.user, this.password, this.account, this.description, this.port, this.taskLock};
            for (int i = 0; i < thisParts.length; ++i) {
                if (!(thisParts[i] == null ? otherParts[i] != null : !thisParts[i].equals(otherParts[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        Object[] parts;
        int result = 0;
        for (Object part : parts = new Object[]{this.empRef, this.host, this.user, this.password, this.account, this.description, this.port, this.taskLock}) {
            result += String.valueOf(part).hashCode();
        }
        return result;
    }

    @Override
    public PayrollServerSpec toPayrollServerSpec() {
        return new PayrollServerSpec(this.host, this.account, this.user, this.password, this.port, this.taskLock);
    }

    @Override
    public String getStoreId() {
        return this.empRef;
    }

    @Override
    public String getStoreSpace() {
        return null;
    }

    @Override
    public Integer getTaskLock() {
        return this.taskLock;
    }

    @Override
    public void setTaskLock(Integer taskLock) {
        this.taskLock = taskLock;
    }
}

