/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.logdialog;

import com.selima.fbi.CancelException;
import com.selima.fbi.ui.common.NumberField;
import com.selima.fbi.ui.logdialog.AbstractForm;
import com.selima.fbi.ui.logdialog.ProxyFormContext;
import com.selima.fbi.user.IProxySettings;
import com.selima.fbi.user.IUser;
import com.selima.fbi.user.IUserManager;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ProxyForm
extends AbstractForm {
    public static final String SCREEN = "+-----------------------------------------------------+\n| Title BOTH 10 10 15 15                              |\n+------------+--------------+-------------------------+\n|            | ProxyHost    | ProxyHostField          |\n| GwLogo     | WEST         | HORIZONTAL              |\n|            | 0 3 5 3      |  0 3 5 15 100%          |\n| HORIZONTAL +--------------+-------------------------+\n| NORTH      | ProxyPort    | ProxyPortField          |\n| 0 10 15 15 | WEST         | HORIZONTAL              |\n|            | 0 3 5 3      | 0 3 5 15                |\n|            |              | 100%                    |\n|            +--------------+-------------------------+\n|            | ProxyUser    | ProxyUserField          |\n|            | WEST         | HORIZONTAL              |\n|            | 0 3 5 3      | 0 3 5 15                |\n|            |              | 100%                    |\n|            +--------------+-------------------------+\n|            | ProxyPassword| ProxyPasswordField      |\n|            | WEST         | HORIZONTAL              |\n|            | 0 3 5 3      | 0 3 5 15                |\n|            |              | 100%                    |\n|            |              |                         |\n+------------+--------------+-------------------------+\n| Back  SOUTHWEST           | Login SOUTHEAST         |\n|  15 10 10 15 0% 100%      | 15 0 10 15 50% 100%     |\n+---------------------------+-------------------------+";
    JTextField fldHost;
    JTextField fldUser;
    JPasswordField fldPassword;
    JFormattedTextField fldPort;
    JButton btnBack;

    public ProxyForm(ProxyFormContext context) {
        super(context, SCREEN);
        this.setName("proxyForm");
        this.add((Component)new JLabel("Proxy Host"), (Object)"ProxyHost");
        this.fldHost = new JTextField(12);
        this.add(this.fldHost, "ProxyHostField");
        this.add((Component)new JLabel("Proxy Port"), (Object)"ProxyPort");
        this.fldPort = new NumberField();
        this.add(this.fldPort, "ProxyPortField");
        this.add((Component)new JLabel("Proxy User"), (Object)"ProxyUser");
        this.fldUser = new JTextField(12);
        this.add(this.fldUser, "ProxyUserField");
        this.add((Component)new JLabel("Proxy Password"), (Object)"ProxyPassword");
        this.fldPassword = new JPasswordField(12);
        this.add(this.fldPassword, "ProxyPasswordField");
        this.btnBack = new JButton("Back");
        this.add(this.btnBack, "Back");
        this.btnBack.addActionListener(new AbstractForm.BackAction());
        InitWork initWork = new InitWork();
        this.btnLogin.addActionListener(initWork);
        this.addAncestorListener(initWork);
    }

    ProxySettings getProxySettings() {
        return new ProxySettings(this.fldHost.getText(), this.toInt(this.fldPort.getValue()), this.fldUser.getText(), new String(this.fldPassword.getPassword()));
    }

    private void setProxySettings(IProxySettings result) {
        this.fldHost.setText(result.getProxyHost());
        this.fldPort.setValue(result.getProxyPort());
        this.fldUser.setText(result.getProxyUser());
        this.fldPassword.setText(result.getProxyPassword());
    }

    private Integer toInt(Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return null;
    }

    class InitWork
    implements BackendWork,
    AncestorListener,
    ActionListener {
        Map<String, IProxySettings> settingsMap = new HashMap<String, IProxySettings>();

        InitWork() {
        }

        public String getName() {
            return "Loading Proxy Settings";
        }

        public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
            ProxyFormContext proxyContext = (ProxyFormContext)ProxyForm.this.context;
            IUserManager userManager = proxyContext.getUserManager();
            if (userManager != null) {
                try {
                    IUser user = userManager.getUser(proxyContext.getUsername());
                    if (user != null) {
                        IProxySettings proxySettings = user.getProxySettings();
                        handle.setResult((Object)(proxySettings != null ? proxySettings : new ProxySettings()));
                    }
                }
                catch (IOException e) {
                    LogAPI.logSevere((Throwable)e);
                }
                catch (CancelException e) {
                    throw new CanceledException((Exception)e);
                }
            }
        }

        public void invokeSwing(SwingOperationHandle handle) {
            IProxySettings result = (IProxySettings)handle.getResult();
            if (result != null) {
                ProxyForm.this.setProxySettings(result);
            }
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            ProxyFormContext proxyFormContext = (ProxyFormContext)ProxyForm.this.context;
            String key = proxyFormContext.getUsername() + "@" + proxyFormContext.getServiceAlias();
            if (this.settingsMap.containsKey(key)) {
                ProxyForm.this.setProxySettings(this.settingsMap.get(key));
            } else {
                ProxyForm.this.context.getSubmitter().submitWork((BackendWork)this);
            }
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProxyFormContext proxyFormContext = (ProxyFormContext)ProxyForm.this.context;
            String key = proxyFormContext.getUsername() + "@" + proxyFormContext.getServiceAlias();
            this.settingsMap.put(key, ProxyForm.this.getProxySettings());
        }
    }

    class ProxySettings
    implements IProxySettings {
        String host;
        String user;
        String password;
        Integer port;

        ProxySettings(String host, Integer port, String user, String password) {
            if (host.length() > 0) {
                this.host = host;
            }
            this.port = port;
            if (user.length() > 0) {
                this.user = user;
            }
            if (password.length() > 0) {
                this.password = password;
            }
        }

        ProxySettings() {
        }

        @Override
        public boolean isEmpty() {
            return this.host == null;
        }

        @Override
        public String getProxyUser() {
            return this.user;
        }

        @Override
        public void setProxyUser(String user) {
            this.user = user;
        }

        @Override
        public String getProxyPassword() {
            return this.password;
        }

        @Override
        public void setProxyPassword(String password) {
            this.password = password;
        }

        @Override
        public String getProxyHost() {
            return this.host;
        }

        @Override
        public void setProxyHost(String host) {
            this.host = host;
        }

        @Override
        public Integer getProxyPort() {
            return this.port;
        }

        @Override
        public void setProxyPort(Integer port) {
            this.port = port;
        }
    }
}

