/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.logdialog;

import com.selima.fbi.CancelException;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.MainFacade;
import com.selima.fbi.ProxySettingsException;
import com.selima.fbi.service.DPSException;
import com.selima.fbi.service.IMailService;
import com.selima.fbi.service.MailServiceException;
import com.selima.fbi.service.MailServiceFactory;
import com.selima.fbi.ui.logdialog.LoginWorkContext;
import com.selima.fbi.user.IProxySettings;
import com.selima.fbi.user.IUser;
import com.selima.fbi.user.IUserManager;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.JOptionPane;

class LoginWork
implements BackendWork {
    boolean success;
    IProxySettings proxySettings;
    IMailServiceFacade mailService;
    private LoginWorkContext context;

    LoginWork(LoginWorkContext context) {
        this.context = context;
    }

    public String getName() {
        return "Connecting HMRC DPS Service";
    }

    public void invokeBackend(BackendOperationHandle handle) throws InterruptedException, CanceledException {
        try {
            this.mailService = this.createMailService();
            IUserManager userManager = this.context.getUserManager();
            String username = this.context.getUsername();
            String password = this.context.getPassword();
            IUser user = userManager.getUser(username);
            if (user != null) {
                user.setPassword(password);
            } else {
                user = userManager.createUser(username, password);
            }
            IProxySettings proxySettings = this.context.getProxySettings();
            if (proxySettings != null) {
                user.setProxySettings(proxySettings);
            }
            this.success = this.mailService.logon(user);
        }
        catch (DPSException e) {
            LogAPI.logSevere((Throwable)e);
            handle.setFailure((Throwable)e);
        }
        catch (RemoteException e) {
            LogAPI.logSevere((Throwable)e);
            handle.setFailure((Throwable)e);
        }
        catch (MailServiceException e) {
            LogAPI.logSevere((Throwable)e);
            handle.setFailure((Throwable)e);
        }
        catch (IOException e) {
            LogAPI.logSevere((Throwable)e);
            handle.setFailure((Throwable)e);
        }
        catch (CancelException e) {
            throw new CanceledException((Exception)e);
        }
    }

    public void invokeSwing(SwingOperationHandle handle) {
        if (this.success) {
            if (this.mailService.isOffline()) {
                switch (this.showOptionDialog("Work Offline", "Change Proxy Settings", "Cancel")) {
                    case 0: {
                        this.context.loggedInCallBack(this.mailService);
                        break;
                    }
                    case 1: {
                        this.context.showProxyForm();
                        break;
                    }
                    default: {
                        this.context.showLoginForm();
                        break;
                    }
                }
            } else {
                this.context.loggedInCallBack(this.mailService);
            }
        } else if (handle.getFailure() == null) {
            if (this.mailService.isOffline()) {
                this.context.showErrorText("HMRC DPS service cannot be connected. Your credentials can not be verified.");
                switch (this.showOptionDialog("Change Proxy Settings", "Cancel")) {
                    case 0: {
                        this.context.showProxyForm();
                        break;
                    }
                    default: {
                        this.context.showLoginForm();
                        break;
                    }
                }
            } else {
                this.context.showErrorText("Your credentials has been rejected by HMRC DPS service.");
                this.context.showLoginForm();
            }
        } else if (!(handle.getFailure() instanceof CanceledException)) {
            Throwable tw = handle.getFailure();
            if (tw instanceof DPSException) {
                DPSException dpse = (DPSException)tw;
                this.context.showErrorText("The DPS service failed: '" + (Object)((Object)dpse.getDPSErrors()[0]) + ":" + dpse.getDescriptions()[0]);
            } else if (tw instanceof RemoteException) {
                this.context.showErrorText("Network related malfunction:' " + tw.getMessage() + "'");
            } else if (tw instanceof MailServiceException) {
                this.context.showErrorText("The '" + this.context.getAlias() + "' service is not properly configured: '" + tw.getMessage() + "'");
            } else if (tw instanceof ProxySettingsException) {
                this.context.showErrorText("Proxy error: '" + tw.getMessage() + "'");
            } else if (tw instanceof IOException) {
                this.context.showErrorText("FBI storage error: '" + tw.getMessage() + "'");
            }
            LogAPI.logSevere((Throwable)handle.getFailure());
            this.context.showLoginForm();
        }
    }

    IMailServiceFacade createMailService() throws MailServiceException, IOException, CancelException {
        String alias = this.context.getAlias();
        IMailService service = MailServiceFactory.createService(alias);
        MainFacade mailService = new MainFacade(alias, service, this.context.getUserManager(), this.context.getStorageFactory(), this.context.getReferenceManager(), this.context.getSenderDetailsSource());
        return mailService;
    }

    private int showOptionDialog(String ... options) {
        return JOptionPane.showOptionDialog(this.context.getComponent(), "HMRC DPS service cannot be connected.", this.context.getTitle(), 0, 3, null, options, options[0]);
    }
}

