/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.logdialog;

import com.selima.fbi.ui.logdialog.AbstractForm;
import com.selima.fbi.ui.logdialog.LoginDialogContext;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTextPane;

public class InstallationCodeForm
extends AbstractForm {
    private static final String LAYOUT_TEMPLATE = "+-------------------------------------------------------+\n| Title BOTH 10 10 15 15                                |\n+------------+------------------------------------------+\n| GwLogo     | Explanation    HORIZONTAL 0 0 0 0 100%   |\n| HORIZONTAL +--------------+---------------------------+\n| NORTH      | CodeLabel    | CodeField                 |\n| 0 10 15 15 | WEST         | HORIZONTAL                |\n|            |  5 3 5 3     |  5 5 5 15 100%            |\n+------------+--------------+---------------------------+\n| Back  SOUTHWEST           | Login SOUTHEAST           |\n|  3 10 10 15 0% 100%       | 3 0 10 15 0% 100%         |\n+---------------------------+---------------------------+";
    private JFormattedTextField textField;

    InstallationCodeForm(LoginDialogContext context) {
        super(context, LAYOUT_TEMPLATE);
        this.setName("codeForm");
        this.add((Component)new ExplanationPane(), (Object)"Explanation");
        this.add((Component)new JLabel("Installation Code"), (Object)"CodeLabel");
        this.textField = new JFormattedTextField(DecimalFormat.getIntegerInstance());
        this.add(this.textField, "CodeField");
        this.add(new JButton(new AbstractForm.BackAction()), "Back");
    }

    public long getInstallationCode() {
        try {
            this.textField.commitEdit();
            return (Long)this.textField.getValue();
        }
        catch (ParseException e) {
            return -1L;
        }
    }

    class ExplanationPane
    extends JTextPane {
        ExplanationPane() {
            this.setContentType("text/html");
            this.setFocusable(false);
            this.setOpaque(false);
            this.setText("<html><body style='color:olive;margin:0px'>Enter installation code to proceed.<br>Ask your customer support to have the code provided to you.</body></html>");
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(175, 100);
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension result = super.getMinimumSize();
            if (this.getParent() != null) {
                result.height = Math.min(result.height, this.getParent().getHeight() - 150);
                return result;
            }
            return super.getMinimumSize();
        }
    }
}

