/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.logdialog;

import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.ui.logdialog.AbstractForm;
import com.selima.fbi.ui.logdialog.LoginDialogContext;
import com.selima.framework.exception.BackendException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class DirectoryForm
extends AbstractForm {
    JTextField textField;
    volatile JFileChooser fileChooser;
    StoreTypeComboBox storeTypeComboBox;
    public static final String SCREEN = "+---------------------------------------------------------------------+\n| Title BOTH 10 10 15 15                                              |\n+------------+--------------------------------------------------------+\n| GwLogo     | Explanation    HORIZONTAL 0 0 0 0                      |\n| HORIZONTAL +--------------+-----------------------+-----------------+\n| NORTH      | Directory    | DirectoryField        | DirectoryChooser|\n| 0 10 15 15 | WEST         | HORIZONTAL            | WEST            |\n|            |  5 3 5 3     |  5 0 5 1 100%         | 5 0 5 15        |\n|            +--------------+-----------------------+-----------------+\n|            | StoreType    | StoreTypeComboBox     |                 |\n|            | WEST         | HORIZONTAL            |                 |\n|            | 0 3 5 3      | 0 0 5 1  100%         |                 |\n|            |              |                       |                 |\n+------------+--------------+-----------------------+-----------------+\n| Back  SOUTHWEST           | Login SOUTHEAST                         |\n|  3 10 10 15 0% 100%       | 3 0 10 15 0% 100%                       |\n+---------------------------+-----------------------------------------+";

    DirectoryForm(LoginDialogContext context) {
        super(context, SCREEN);
        this.setName("directoryForm");
        this.add((Component)new ExplanationPane(), (Object)"Explanation");
        this.add((Component)new JLabel("Directory"), (Object)"Directory");
        this.textField = new DirectoryField(MailServiceConfig.getBaseDir());
        this.add(this.textField, "DirectoryField");
        JButton dirButton = new JButton(new ChooseDirectoryAction());
        dirButton.setPreferredSize(new Dimension(25, 25));
        this.add(dirButton, "DirectoryChooser");
        this.add((Component)new JLabel("Files"), (Object)"StoreType");
        this.storeTypeComboBox = new StoreTypeComboBox();
        this.add(this.storeTypeComboBox, "StoreTypeComboBox");
        this.add(new JButton(new AbstractForm.BackAction()), "Back");
        this.addAncestorListener(new EagerLoader());
    }

    boolean isSelectedUniverseStore() {
        return this.storeTypeComboBox.isUniverseSelected();
    }

    void savePreferences() {
        this.storeTypeComboBox.savePreferences();
    }

    File getDirectory() throws IOException {
        File directory = new File(this.textField.getText());
        if (directory.exists() && !directory.isDirectory()) {
            throw new IOException(directory.getPath() + " is not a directory");
        }
        if (!directory.getName().startsWith("Selima-FBI")) {
            directory = MailServiceConfig.isDevelopmentVersion() ? new File(directory, "Selima-FBI-Dev") : new File(directory, "Selima-FBI");
        }
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Failed to create directory " + directory.getPath());
        }
        return directory;
    }

    class EagerLoader
    implements AncestorListener,
    BackendWork {
        EagerLoader() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            DirectoryForm.this.context.getSubmitter().submitWork((BackendWork)this);
            event.getComponent().removeAncestorListener(this);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        public String getName() {
            return "Warming-up";
        }

        public void invokeBackend(BackendOperationHandle handle) throws BackendException, CanceledException, InterruptedException {
            try {
                Class.forName("javax.swing.JFileChooser", true, ClassLoader.getSystemClassLoader());
                handle.setResult((Object)new JFileChooser());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        public void invokeSwing(SwingOperationHandle handle) {
            if (DirectoryForm.this.fileChooser == null) {
                DirectoryForm.this.fileChooser = (JFileChooser)handle.getResult();
            }
        }
    }

    class ExplanationPane
    extends JTextPane {
        ExplanationPane() {
            this.setContentType("text/html");
            this.setFocusable(false);
            this.setOpaque(false);
            this.setText("<html><body style='color:olive;margin:0px'>Work directory to keep logs and local data files.</body></html>");
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(150, 40);
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension result = super.getMinimumSize();
            if (this.getParent() != null) {
                result.height = Math.min(result.height, this.getParent().getHeight() - 175);
                return result;
            }
            return super.getMinimumSize();
        }
    }

    class ChooseDirectoryAction
    extends AbstractAction {
        public ChooseDirectoryAction() {
            super("...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DirectoryForm.this.fileChooser == null) {
                DirectoryForm.this.fileChooser = new JFileChooser();
            }
            DirectoryForm.this.fileChooser.setFileSelectionMode(1);
            File startingDirectory = DirectoryForm.this.textField.getDocument().getLength() > 0 ? new File(DirectoryForm.this.textField.getText()).getParentFile() : MailServiceConfig.getBaseDir().getParentFile();
            DirectoryForm.this.fileChooser.setCurrentDirectory(startingDirectory);
            int result = DirectoryForm.this.fileChooser.showDialog((Component)e.getSource(), "Select Directory");
            if (result == 0) {
                File file = DirectoryForm.this.fileChooser.getSelectedFile();
                if (file != null) {
                    try {
                        DirectoryForm.this.textField.setText(file.getCanonicalPath());
                    }
                    catch (IOException e1) {
                        DirectoryForm.this.textField.setText(file.getAbsolutePath());
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    class DirectoryField
    extends JTextField {
        DirectoryField(File directory) {
            this.setText(directory.getAbsolutePath());
            Dimension size = this.getPreferredSize();
            size.width = 50;
            this.setPreferredSize(size);
        }
    }

    static class StoreTypeComboBox
    extends JComboBox {
        boolean useSystemNode = true;

        StoreTypeComboBox() {
            super(new StoreTypeComboBoxModel());
            this.setEditable(false);
            Preferences prefs = Preferences.systemNodeForPackage(this.getClass());
            this.useSystemNode = "System".equals(prefs.get("store.node", "System"));
            if (!this.useSystemNode) {
                prefs = Preferences.userNodeForPackage(this.getClass());
            }
            this.setSelectedItem(prefs.get("store.type", "Local Files"));
        }

        boolean isUniverseSelected() {
            return "Universe".equals(this.getSelectedItem());
        }

        void savePreferences() {
            Preferences prefs = this.useSystemNode ? Preferences.systemNodeForPackage(this.getClass()) : Preferences.userNodeForPackage(this.getClass());
            prefs.put("store.type", String.valueOf(this.getSelectedItem()));
        }

        static class StoreTypeComboBoxModel
        extends DefaultComboBoxModel {
            public StoreTypeComboBoxModel() {
                super(new Object[]{"Local Files", "Universe"});
            }
        }
    }
}

