/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.logdialog;

import com.selima.fbi.threading.GWImageSupplyFactory;
import com.selima.fbi.threading.GWPanel;
import com.selima.fbi.ui.ResourceDrivenLayout;
import com.selima.fbi.ui.common.AbstractDialogKeyAction;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.logdialog.LoginDialogContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

class AbstractForm
extends JPanel {
    protected static final String IMAGE = "/img/selima-bulanci.png";
    protected LoginDialogContext context;
    protected JButton btnLogin;
    protected GWPanel gwLogo;

    AbstractForm(LoginDialogContext context, String template) {
        super(new ResourceDrivenLayout(template));
        this.setFocusable(false);
        this.setOpaque(true);
        this.context = context;
        this.gwLogo = new GWPanel(GWImageSupplyFactory.createMovingImageSupply(IMAGE, 1, true, true)){

            @Override
            public Dimension getMinimumSize() {
                return super.getPreferredSize();
            }
        };
        this.add((Component)this.gwLogo, (Object)"GwLogo");
        JLabel lbTitle = new JLabel(SwingHelper.imageIcon("/img/selima.software.png"));
        lbTitle.setHorizontalAlignment(2);
        this.add((Component)lbTitle, (Object)"Title");
        this.btnLogin = new JButton(new LoginAction());
        this.add(this.btnLogin, "Login");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setEnabled(enabled);
        }
    }

    void add(JComboBox comboBox, String name) {
        new ComboEscapeHelper(comboBox);
        if (comboBox.isEditable()) {
            JTextField editor = (JTextField)comboBox.getEditor().getEditorComponent();
            editor.addActionListener(new TransferFocusListener());
            SwingHelper.fixJTextComponentEscapeConsumation(editor);
        } else {
            comboBox.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "enter");
            comboBox.getActionMap().put("enter", new TransferFocusListener());
        }
        super.add((Component)comboBox, name);
    }

    void add(JFormattedTextField textField, String name) {
        textField.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "enter");
        textField.getActionMap().put("enter", new TransferFocusListener());
        super.add((Component)textField, name);
    }

    void add(JTextField textField, String name) {
        textField.addActionListener(new TransferFocusListener());
        SwingHelper.fixJTextComponentEscapeConsumation(textField);
        super.add((Component)textField, name);
    }

    void add(JSpinner spinner, String name) {
        JFormattedTextField textField = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
        SwingHelper.fixJTextComponentEscapeConsumation(textField);
        textField.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "enter");
        textField.getActionMap().put("enter", new TransferFocusListener());
        super.add((Component)spinner, name);
    }

    void add(AbstractButton button, String name) {
        button.setMinimumSize(button.getPreferredSize());
        button.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "enter");
        button.getActionMap().put("enter", new TransferFocusListener());
        super.add((Component)button, name);
    }

    public void finalize() {
        this.gwLogo.detach();
    }

    void detach() {
        this.gwLogo.detach();
    }

    class ComboEscapeHelper
    extends KeyAdapter {
        JComboBox comboBox;
        boolean armed;

        ComboEscapeHelper(JComboBox box) {
            this.comboBox = box;
            if (box.isEditable()) {
                box.getEditor().getEditorComponent().addKeyListener(this);
            } else {
                box.addKeyListener(this);
            }
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 27 && this.comboBox.isPopupVisible()) {
                this.comboBox.hidePopup();
                evt.consume();
                this.armed = true;
            }
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            if (this.armed) {
                this.armed = false;
                if (evt.getKeyChar() == '\u001b') {
                    evt.consume();
                }
            }
        }
    }

    class TransferFocusListener
    extends AbstractAction {
        TransferFocusListener() {
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            if (!((JComponent)e.getSource()).isShowing()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Component comp = (Component)e.getSource();
                    if (comp == AbstractForm.this.btnLogin) {
                        AbstractForm.this.btnLogin.doClick();
                    } else {
                        Container focusCycleRootAncestor = AbstractForm.this.getFocusCycleRootAncestor();
                        FocusTraversalPolicy policy = focusCycleRootAncestor.getFocusTraversalPolicy();
                        comp = policy.getComponentAfter(focusCycleRootAncestor, comp);
                        if (comp == AbstractForm.this.btnLogin) {
                            AbstractForm.this.btnLogin.doClick();
                        } else {
                            comp.requestFocusInWindow();
                        }
                    }
                }
            });
        }
    }

    class BackAction
    extends AbstractDialogKeyAction {
        public BackAction() {
            super("Back");
            this.addDialogKey(AbstractForm.this, "ESCAPE");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractForm.this.context.prevForm();
        }
    }

    class LoginAction
    extends AbstractAction {
        LoginAction() {
            super("Login");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractForm.this.context.nextForm();
        }
    }
}

