/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.export;

import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.ui.IStatusBar;
import com.selima.fbi.ui.export.XMLExportListener;
import com.selima.fbi.util.IOUtil;
import com.selima.fbi.webserver.WebServerException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class XMLExporter {
    private final IStatusBar statusBar;
    private final EventBroadcast<XMLExportListener> listeners = EventBroadcastFactory.createEventBroadcast(XMLExportListener.class);

    public XMLExporter(IStatusBar statusBar) {
        this.statusBar = statusBar;
    }

    public void addListener(XMLExportListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removeListener(XMLExportListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    public void export(IMailMessage message, File file, BackendOperationHandle handle) throws IOException, WebServerException, CanceledException {
        handle.checkCancelRequest();
        if (this.statusBar != null) {
            this.statusBar.displayMessage("Saving '" + file + "'");
        }
        ((XMLExportListener)this.listeners.getListener()).saving(message);
        IOUtil.copy((InputStream)new ByteArrayInputStream(message.getBytes()), file);
        ((XMLExportListener)this.listeners.getListener()).saved(message);
    }
}

