/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.export;

import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.ui.IStatusBar;
import com.selima.fbi.ui.export.ExportResourceStorage;
import com.selima.fbi.ui.export.HTMLExportListener;
import com.selima.fbi.util.IOUtil;
import com.selima.fbi.util.ResourceStorage;
import com.selima.fbi.util.RewritingOutputStream;
import com.selima.fbi.webserver.PagePart;
import com.selima.fbi.webserver.WebServer;
import com.selima.fbi.webserver.WebServerException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class HTMLExporter
implements ResourceStorage.Observer {
    private final WebServer webServer;
    private final IStatusBar statusBar;
    private final EventBroadcast<HTMLExportListener> listeners = EventBroadcastFactory.createEventBroadcast(HTMLExportListener.class);

    public HTMLExporter(WebServer webServer, IStatusBar statusBar) {
        this.webServer = webServer;
        this.statusBar = statusBar;
    }

    public void addListener(HTMLExportListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removeListener(HTMLExportListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    @Override
    public void savingFile(URL url) {
        if (this.statusBar != null) {
            this.statusBar.displayMessage("Saving '" + url + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(IMailMessage message, PagePart pagePart, File file, BackendOperationHandle handle) throws IOException, WebServerException, CanceledException {
        this.webServer.showMessage(message);
        try {
            List<PagePart> pages = Collections.singletonList(pagePart);
            ((HTMLExportListener)this.listeners.getListener()).saving(message, pages);
            this.export(pages, file, handle);
            ((HTMLExportListener)this.listeners.getListener()).saved(message);
        }
        finally {
            this.webServer.hideMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(IMailMessage message, String mode, File file, BackendOperationHandle handle) throws IOException, WebServerException, CanceledException {
        this.webServer.showMessage(message);
        try {
            Map<String, List<PagePart>> pages = this.webServer.listPages(message);
            List<PagePart> list = null;
            if (mode != null) {
                list = pages.get(mode);
            } else if (pages.size() > 0) {
                list = pages.values().iterator().next();
            } else {
                return;
            }
            ((HTMLExportListener)this.listeners.getListener()).saving(message, list);
            this.export(list, file, handle);
            ((HTMLExportListener)this.listeners.getListener()).saved(message);
        }
        finally {
            this.webServer.hideMessage(message);
        }
    }

    private void export(List<PagePart> pages, File file, BackendOperationHandle handle) throws IOException, WebServerException, CanceledException {
        if (pages.size() == 1) {
            handle.checkCancelRequest();
            if (file.getName().contains("%page%")) {
                file = new File(file.getParentFile(), file.getName().replaceAll("%page%", ""));
            }
            this.saveFile(new ExportResourceStorage(file), pages.get((int)0).url, file);
            ((HTMLExportListener)this.listeners.getListener()).savedPage(pages.get(0));
        } else if (pages.size() > 1) {
            String baseName = IOUtil.stripExtension(file);
            String extension = IOUtil.getExtension(file);
            ExportResourceStorage storage = new ExportResourceStorage(new File(file.getParentFile(), baseName.replaceAll("%page%", "") + extension));
            HashSet<File> usedFiles = new HashSet<File>(pages.size());
            for (int i = 0; i < pages.size(); ++i) {
                handle.checkCancelRequest();
                PagePart page = pages.get(i);
                String partFileName = baseName.replace("%page%", IOUtil.idToFile(page.getName()));
                File partFile = new File(file.getParent(), partFileName + extension);
                partFile = IOUtil.uniqueFile(partFile, usedFiles);
                this.saveFile(storage, page.url, partFile);
                usedFiles.add(partFile);
                ((HTMLExportListener)this.listeners.getListener()).savedPage(page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(ExportResourceStorage storage, URL pageURL, File file) throws IOException {
        RewritingOutputStream stream = new RewritingOutputStream(storage, file);
        stream.setServer(pageURL.getProtocol() + "://" + pageURL.getAuthority());
        storage.addObserver(this);
        try {
            IOUtil.copy(pageURL.openStream(), (OutputStream)stream);
        }
        finally {
            storage.removeObserver(this);
        }
    }
}

