/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.edialog;

import com.selima.fbi.ui.ResourceDrivenLayout;
import com.selima.fbi.ui.common.AbstractDialogKeyAction;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.edialog.FailureModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.View;

class FailurePanel
extends JPanel {
    static final String LAYOUT = "+-------------+-------------------------------------------+\n| ErrorIcon   | MessagePane HORIZONTAL                    |\n|  NONE       | CENTER                                    |\n| NORTHWEST   | 5 5 5 20 10% 0%                           |\n| 15 15 10 20 +-------------------------------------------+\n| 0%   0%     | DetailPane BOTH                           |\n|             | 5 5 0 20 10%   0%                         |\n|             |                                           |\n+-------------+-------------------------------------------+\n| StackTracePane BOTH 0 5 0 5 100% 100%                   |\n|                                                         |\n+-----------------+---------------------+-----------------+\n|  StackButton    | OkButton NONE       |                 |\n|  NONE           | SOUTHEAST           |                 |\n|  SOUTHEAST      | 5 5 10 10   1% 0%   |                 |\n|  5 15 10 5  99% |                     |                 |\n|  0%             |                     |                 |\n+-----------------+---------------------+-----------------+\n";
    private JButton stackTraceButton;
    private JButton okButton;
    private JButton specialButton;
    private JTextPane detailArea;
    private JTextPane messageArea;
    private JTextPane stackPane;
    private StackAction stackTraceAction;
    private JScrollPane stackTracePane;
    private JLabel iconLabel;
    private JDialog dialog;
    private FailureModel model;

    FailurePanel(JDialog dialog, FailureModel model) {
        this.setLayout(new ResourceDrivenLayout(LAYOUT));
        this.dialog = dialog;
        this.model = model;
        Icon icon = UIManager.getIcon("OptionPane.errorIcon");
        this.iconLabel = new JLabel(icon);
        this.add((Component)this.iconLabel, "ErrorIcon");
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setVerticalAlignment(1);
        this.iconLabel.setMinimumSize(this.iconLabel.getPreferredSize());
        this.messageArea = new JTextPane();
        this.add((Component)this.messageArea, "MessagePane");
        this.messageArea.setContentType("text/html");
        this.messageArea.setOpaque(false);
        this.detailArea = new JTextPane();
        this.add((Component)this.detailArea, "DetailPane");
        this.detailArea.setContentType("text/html");
        this.detailArea.setOpaque(false);
        this.stackPane = new JTextPane();
        this.stackPane.setEditable(false);
        this.stackTracePane = new JScrollPane(this.stackPane);
        this.add((Component)this.stackTracePane, "StackTracePane");
        this.stackTracePane.setHorizontalScrollBarPolicy(32);
        this.stackTracePane.setVerticalScrollBarPolicy(22);
        this.stackTracePane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), this.stackTracePane.getBorder()));
        this.stackTracePane.setPreferredSize(new Dimension(325, 300));
        this.stackPane.setContentType("text/html");
        CloseAction closeAction = new CloseAction();
        closeAction.addDialogKey(this, "ENTER");
        closeAction.addDialogKey(this, "ESCAPE");
        this.okButton = new JButton(closeAction);
        this.add((Component)this.okButton, "OkButton");
        this.stackTraceAction = new StackAction();
        this.stackTraceButton = new JButton(this.stackTraceAction);
        this.add((Component)this.stackTraceButton, "StackButton");
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){
            LinkedList<Component> buttons = new LinkedList();
            {
                this.buttons.add(FailurePanel.this.okButton);
                this.buttons.add(FailurePanel.this.stackTraceButton);
                if (FailurePanel.this.specialButton != null) {
                    this.buttons.add(FailurePanel.this.specialButton);
                }
            }

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                return this.buttons.getFirst();
            }

            @Override
            public Component getFirstComponent(Container focusCycleRoot) {
                return this.buttons.getFirst();
            }

            @Override
            public Component getComponentBefore(Container container, Component component) {
                int i = this.buttons.indexOf(component);
                if (i < this.buttons.size() - 1) {
                    return this.buttons.get(i + 1);
                }
                return this.buttons.getFirst();
            }

            @Override
            public Component getComponentAfter(Container container, Component component) {
                int i = this.buttons.indexOf(component);
                if (i > 0) {
                    return this.buttons.get(i - 1);
                }
                return this.buttons.getLast();
            }

            @Override
            public Component getLastComponent(Container focusCycleRoot) {
                return this.buttons.getLast();
            }
        });
        dialog.setTitle(model.getTitle());
        this.messageArea.setText(model.getMessage());
        this.detailArea.setText(model.getDetails());
        String stackPaneText = model.getThrowable();
        if (stackPaneText != null && !this.isHtml(stackPaneText)) {
            stackPaneText = "<html><pre>" + stackPaneText.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + stackPaneText + "</pre></html>";
        }
        this.stackPane.setText(stackPaneText);
        this.stackTraceButton.setVisible(stackPaneText != null);
        this.setPreferredWidth(this.messageArea, model.getMaximumWidth());
        this.setPreferredWidth(this.detailArea, model.getMaximumWidth());
        this.stackTraceAction.hide();
    }

    private boolean isHtml(String text) {
        return text.startsWith("<html>") || text.endsWith("<HTML>");
    }

    public FailureModel getModel() {
        return this.model;
    }

    private void setPreferredWidth(JTextPane textPane, int width) {
        textPane.setPreferredSize(null);
        width = Math.min(width, textPane.getPreferredSize().width);
        View view = ((BasicTextUI)textPane.getUI()).getRootView(textPane);
        Insets insets = textPane.getInsets();
        view.setSize(width - insets.left - insets.right, 2.1474836E9f);
        int height = (int)view.getPreferredSpan(1);
        textPane.setPreferredSize(new Dimension(width, height + 5));
    }

    private final class StackAction
    extends AbstractAction {
        private static final String HIDDEN = "Show details";
        private static final String SHOWN = "Hide details";

        StackAction() {
            super(HIDDEN, SwingHelper.imageIcon("/img/16x16/actions/viewmag.png"));
        }

        public void hide() {
            FailurePanel.this.stackTracePane.setVisible(false);
            this.putValue("Name", HIDDEN);
            FailurePanel.this.dialog.pack();
        }

        public void show() {
            FailurePanel.this.stackTracePane.setVisible(true);
            FailurePanel.this.stackPane.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
            this.putValue("Name", SHOWN);
            FailurePanel.this.dialog.pack();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.getValue("Name") == HIDDEN) {
                this.show();
            } else {
                this.hide();
            }
            FailurePanel.this.dialog.pack();
        }
    }

    private final class CloseAction
    extends AbstractDialogKeyAction {
        public CloseAction() {
            super("OK", SwingHelper.imageIcon("/img/16x16/actions/ok.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FailurePanel.this.dialog.setVisible(false);
        }
    }
}

