/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.edialog;

import com.selima.fbi.ui.edialog.FBIFailureModelFactory;
import com.selima.fbi.ui.edialog.FailureModel;
import com.selima.fbi.ui.edialog.FailureModelFactory;
import com.selima.fbi.ui.edialog.FailurePanel;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Frame;
import javax.swing.JDialog;

public class FailureDialog {
    public static final String SUPPRESS_PROPERTY = "EDialog.suppress";

    public static void show(String title, String message, Throwable error) {
        FailureDialog.showInternal(FailureDialog.getFailureModelFactory().create(title, message, null, error, 300));
    }

    public static void show(String title, String message, String details, Throwable error) {
        FailureDialog.showInternal(FailureDialog.getFailureModelFactory().create(title, message, details, error, 300));
    }

    public static void show(String title, String message, Throwable error, int width) {
        FailureDialog.showInternal(FailureDialog.getFailureModelFactory().create(title, message, null, error, width));
    }

    private static FailureModelFactory getFailureModelFactory() {
        String cn = System.getProperty(FailureModelFactory.class.getName());
        if (cn != null) {
            try {
                Class<?> c = Class.forName(cn);
                return (FailureModelFactory)c.newInstance();
            }
            catch (Exception e) {
                LogAPI.logSevere((Throwable)e);
            }
        }
        return new FBIFailureModelFactory();
    }

    private static void showInternal(FailureModel model) {
        if (!Boolean.getBoolean(SUPPRESS_PROPERTY)) {
            FailureDialog.getDialog(model).setVisible(true);
        }
    }

    static JDialog getDialog(FailureModel model) {
        FailurePanel panel = null;
        Frame[] frames = Frame.getFrames();
        JDialog dialog = new JDialog(frames.length > 0 ? frames[frames.length - 1] : null, true);
        panel = new FailurePanel(dialog, model);
        dialog.setContentPane(panel);
        dialog.setResizable(false);
        panel.transferFocusDownCycle();
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        return dialog;
    }
}

