/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.settings.sender;

import com.selima.fbi.sender.IModifiableSenderDetails;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.common.EmpRefCellRenderer;
import com.selima.fbi.ui.content.settings.TaxRefSelection;
import com.selima.fbi.ui.content.settings.sender.AbstractTablePanel;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class UseForEmpRefsPanel
extends AbstractTablePanel<String> {
    private static final String EMPTY_VALUE = "<nothing>";
    private final IModifiableSenderDetails senderDetails;

    public UseForEmpRefsPanel(ClientContext clientContext, IModifiableSenderDetails senderDetails) {
        super(clientContext, "Use For");
        this.senderDetails = senderDetails;
        senderDetails.addEmpRefListener(((EmpRefsTable)this.table).getModel());
    }

    @Override
    protected AbstractTablePanel.CustomTable createTable() {
        return new EmpRefsTable();
    }

    @Override
    protected int getDisplayRowCount() {
        return 6;
    }

    private TreeSet<String> getInsertableValues() {
        TreeSet<String> empRefSet = new TreeSet<String>();
        empRefSet.addAll(Arrays.asList(this.getClientContext().getCurrentUser().getEmpRef()));
        empRefSet.removeAll(this.senderDetails.getAllEmpRefs());
        return empRefSet;
    }

    class EmpRefModel
    extends AbstractTablePanel.CustomTableModel
    implements ChangeListener {
        boolean selfUpdate;

        EmpRefModel() {
        }

        @Override
        void deleteRow(int rowIndex) {
            this.selfUpdate = true;
            try {
                UseForEmpRefsPanel.this.senderDetails.removeEmpRef(rowIndex);
                this.fireTableRowsDeleted(rowIndex, rowIndex);
            }
            finally {
                this.selfUpdate = false;
            }
        }

        void insertRow(String empRef) {
            this.selfUpdate = true;
            try {
                int insertedRowIndex = UseForEmpRefsPanel.this.senderDetails.getEmpRefCount();
                UseForEmpRefsPanel.this.senderDetails.addEmpRef(empRef);
                this.fireTableRowsInserted(insertedRowIndex, insertedRowIndex);
            }
            finally {
                this.selfUpdate = false;
            }
        }

        @Override
        void insertRow() {
            if (!UseForEmpRefsPanel.this.getInsertableValues().isEmpty()) {
                this.insertRow(UseForEmpRefsPanel.EMPTY_VALUE);
            }
        }

        @Override
        void pruneEmptyValue() {
            int index = UseForEmpRefsPanel.this.senderDetails.getAllEmpRefs().indexOf(UseForEmpRefsPanel.EMPTY_VALUE);
            if (index >= 0) {
                this.deleteRow(index);
            }
        }

        @Override
        void populateModel() {
        }

        @Override
        void populateUI() {
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return UseForEmpRefsPanel.this.senderDetails == null ? 0 : UseForEmpRefsPanel.this.senderDetails.getEmpRefCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String empRef = UseForEmpRefsPanel.this.senderDetails.getEmpRef(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return empRef;
                }
            }
            throw new IllegalArgumentException(String.valueOf(columnIndex));
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Reference";
                }
            }
            throw new IllegalArgumentException(String.valueOf(column));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue == null) {
                aValue = UseForEmpRefsPanel.EMPTY_VALUE;
            }
            this.selfUpdate = true;
            try {
                UseForEmpRefsPanel.this.senderDetails.setEmpRef(rowIndex, (String)aValue);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
            finally {
                this.selfUpdate = false;
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!this.selfUpdate) {
                this.populateUI();
            }
        }
    }

    private final class EmpRefsTable
    extends AbstractTablePanel.CustomTable {
        EmpRefsTable() {
            super(new EmpRefModel());
            TableColumn column = this.getColumnModel().getColumn(0);
            column.setPreferredWidth(160);
            column.setCellRenderer(new CustomEmpRefCellRenderer(this.getDefaultRenderer(Object.class)));
            column.setCellEditor(new EmpRefCellEditor(new JComboBox(){
                {
                    this.setRenderer(new CustomEmpRefCellRenderer(this.getRenderer()));
                }
            }));
            this.setTransferHandler(new EmpRefsTransferHandler());
            this.setShowVerticalLines(false);
        }

        @Override
        public EmpRefModel getModel() {
            return (EmpRefModel)super.getModel();
        }

        @Override
        public void removeEditor() {
            super.removeEditor();
            this.getModel().pruneEmptyValue();
        }

        private final class EmpRefsTransferHandler
        extends TransferHandler {
            private EmpRefsTransferHandler() {
            }

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                return Arrays.asList(transferFlavors).contains(TaxRefSelection.TAX_REF_FLAVOR);
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                try {
                    List addedRefs = (List)t.getTransferData(TaxRefSelection.TAX_REF_FLAVOR);
                    addedRefs.removeAll(UseForEmpRefsPanel.this.senderDetails.getAllEmpRefs());
                    for (String empRef : addedRefs) {
                        EmpRefsTable.this.getModel().insertRow(empRef);
                    }
                    return !addedRefs.isEmpty();
                }
                catch (UnsupportedFlavorException e) {
                    throw new IllegalStateException(e);
                }
                catch (IOException e) {
                    LogAPI.logSevere((Throwable)e);
                    return false;
                }
            }
        }

        private final class EmpRefCellEditor
        extends DefaultCellEditor {
            private EmpRefCellEditor(final JComboBox comboBox) {
                super(comboBox);
                this.setClickCountToStart(2);
                comboBox.addAncestorListener(new AncestorListener(){

                    @Override
                    public void ancestorAdded(AncestorEvent event) {
                        comboBox.setPopupVisible(true);
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent event) {
                    }

                    @Override
                    public void ancestorRemoved(AncestorEvent event) {
                    }
                });
            }

            @Override
            public Component getTableCellEditorComponent(JTable jtable, Object obj, boolean flag, int i, int j) {
                JComboBox combo = (JComboBox)super.getTableCellEditorComponent(jtable, obj, flag, i, j);
                TreeSet empRefSet = UseForEmpRefsPanel.this.getInsertableValues();
                empRefSet.add((String)obj);
                empRefSet.add(UseForEmpRefsPanel.EMPTY_VALUE);
                combo.setModel(new DefaultComboBoxModel(new Vector(empRefSet)));
                combo.setSelectedItem(null);
                return combo;
            }
        }

        private final class CustomEmpRefCellRenderer
        extends EmpRefCellRenderer {
            CustomEmpRefCellRenderer(TableCellRenderer renderer) {
                super(UseForEmpRefsPanel.this.getClientContext().getReferenceManager(), renderer);
            }

            CustomEmpRefCellRenderer(ListCellRenderer renderer) {
                super(UseForEmpRefsPanel.this.getClientContext().getReferenceManager(), renderer);
            }

            @Override
            protected Object toHtml(Object value) {
                if (value == UseForEmpRefsPanel.EMPTY_VALUE) {
                    return "";
                }
                return super.toHtml(value);
            }
        }
    }
}

