/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.settings.sender;

import com.selima.fbi.core.SenderType;
import com.selima.fbi.sender.IModifiableSenderDetails;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.ResourceDrivenLayout;
import com.selima.fbi.ui.content.settings.SettingsGroup;
import com.selima.fbi.ui.content.settings.common.EnumComboBox;
import com.selima.fbi.ui.content.settings.common.MinSizeLabel;
import com.selima.fbi.ui.content.settings.common.TextField;
import com.selima.fbi.ui.content.settings.sender.UseForEmpRefsPanel;
import com.selima.framework.util.Util;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class BasicsPanel
extends JPanel
implements SettingsGroup {
    public static final String LAYOUT = "+-----------------+---------------+--------------+--------------+--------------+\n| RecordLabel     |  RecordField  |  SenderLabel | SenderType   |   Table      |\n| NONE            |  HORIZONTAL   |  NONE        | NONE         |   VERTICAL   |\n|      WEST       |       WEST    |       WEST   |      WEST    |   NORTHWEST  |\n| 10 10 0 3       |  10 0 0 0     |  10 10 0 3   | 10 0 0 10    |   10 40 30 45|\n|                 |  0% 0%        |              | 100% 0%      |   0% 100%    |\n+-----------------+---------------+--------------+--------------+              |\n| DefaultCheckbox NONE SOUTHWEST 10 10 30 10                    |              |\n|                                                               |              |\n+---------------------------------------------------------------+--------------+\n";
    private IModifiableSenderDetails senderDetails;
    private String label;
    private TextField fldLabel;
    private EnumComboBox<SenderType> fldSenderType;
    private UseForEmpRefsPanel useForRefs;
    private JCheckBox defaultDetail;

    BasicsPanel(ClientContext clientContext, IModifiableSenderDetails senderDetails) {
        super(new ResourceDrivenLayout(LAYOUT));
        this.senderDetails = senderDetails;
        this.add((Component)new MinSizeLabel("Record Label"), "RecordLabel");
        this.fldLabel = new TextField(15);
        this.add((Component)this.fldLabel, "RecordField");
        this.add((Component)new MinSizeLabel("Sender Type"), "SenderLabel");
        this.fldSenderType = new EnumComboBox<SenderType>(SenderType.class);
        this.add(this.fldSenderType, "SenderType");
        this.useForRefs = new UseForEmpRefsPanel(clientContext, senderDetails);
        this.add((Component)this.useForRefs, "Table");
        this.defaultDetail = new JCheckBox("Default");
        this.add((Component)this.defaultDetail, "DefaultCheckbox");
        this.fldLabel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    BasicsPanel.this.setLabel(BasicsPanel.this.fldLabel.getText());
                }
            }
        });
        this.fldLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicsPanel.this.setLabel(BasicsPanel.this.fldLabel.getText());
            }
        });
        this.defaultDetail.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean wasSelected = e.getStateChange() == 2;
                boolean isSelected = e.getStateChange() == 1;
                BasicsPanel.this.firePropertyChange("defaultDetail", wasSelected, isSelected);
            }
        });
        this.fldLabel.setName("recordLabelField");
        this.defaultDetail.setName("defaultFlagCheckbox");
    }

    public String getLabel() {
        return this.fldLabel.getText();
    }

    public void setLabel(String label) {
        String oldLabel = this.label;
        this.label = label;
        if (!Util.equals((Object)this.fldLabel.getText(), (Object)label)) {
            this.fldLabel.setText(label);
        }
        this.firePropertyChange("label", oldLabel, label);
    }

    public boolean isDefaultDetail() {
        return this.defaultDetail.isSelected();
    }

    public void setDefaultDetail(boolean state) {
        this.defaultDetail.setSelected(state);
    }

    @Override
    public void populateUI() {
        this.setLabel(this.senderDetails.getLabel());
        this.fldSenderType.setSelectedValue(this.senderDetails.getSenderType());
        this.useForRefs.populateUI();
    }

    @Override
    public void populateModel() {
        this.senderDetails.setLabel(this.fldLabel.getText());
        this.senderDetails.setSenderType(this.fldSenderType.getSelectedValue());
        this.useForRefs.populateModel();
    }

    @Override
    public boolean isModified() {
        return !Util.equals((Object)this.fldLabel.getText(), (Object)this.senderDetails.getLabel()) || !Util.equals((Object)((Object)this.fldSenderType.getSelectedValue()), (Object)((Object)this.senderDetails.getSenderType())) || this.useForRefs.isModified();
    }
}

