/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.settings.sender;

import com.selima.fbi.sender.IModifiableSenderDetails;
import com.selima.fbi.sender.ModifiableAddress;
import com.selima.fbi.sender.ModifiableAgent;
import com.selima.fbi.sender.ModifiableContact;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.content.settings.SettingsGroup;
import com.selima.fbi.ui.content.settings.common.MinSizeLabel;
import com.selima.fbi.ui.content.settings.common.TextField;
import com.selima.fbi.ui.content.settings.sender.AddressLinesPanel;
import com.selima.fbi.ui.content.settings.sender.ContactEditorPanel;
import com.selima.framework.util.Util;
import java.awt.Component;

public class AgentPanel
extends ContactEditorPanel
implements SettingsGroup {
    public static final String LAYOUT = "+--------------+-------------+-------------+-------------+-----------------+---------------+--------------+--------------+--------------+-------------+--------------+---+\n| AgentLabel   |AgentField   |CompanyLabel |CompanyField | TitleLabel      |  TitleField   |  ForeLabel   | Fore1Field   |   Fore2Field | SurnameLabel| SurnameField |   |\n| NONE WEST    | NONE WEST   | NONE WEST   | NONE WEST   | NONE            |  NONE         |  NONE        | NONE         |   NONE WEST  | NONE WEST   | NONE WEST    |   |\n| 10 10 0 3    | 10 0 0 0    | 10 10 0 3   | 10 0 0 0    |      EAST       |       WEST    |       EAST   |      WEST    |   10  5  0 0 | 10 10 0 3   | 10 0 0 0     |   |\n|              |             |             |             |  10 10 0 3      |  10 0 0 0     |  10 10 0 3   | 10 0 0  0    |     0% 0%    |             |   0% 0%      |   |\n|              |             |             |             |  1% 0%          |  0% 0%        |              | 0% 0%        |              |             |              |   |\n+--------------+-------------+-------------+-------------+-----------------+---------------+--------------+--------------+--------------+-------------+--------------+---+\n| PostCodeLabel|PostCodeField|CountryLabel | CountryField|                 |               |              |              |              |             |              |   |\n| NONE WEST    | NONE WEST   | NONE WEST   | NONE WEST   |                 |               |              |              |              |             |              |   |\n|  5 10 0 3    |  5 0 0 0    |  5 10 0 3   |  5 0 0 0    |                 |               |              |              |              |             |              |   |\n|              |             |             |             |                 |               |              |              |              |             |              |   |\n|              |             |             |             |                 |               |              |              |              |             |              |   |\n+--------------+-------------+-------------+-------------+-----------------+---------------+--------------+--------------+--------------+-------------+--------------+---|\n|  AddressLines  BOTH    WEST 10 10 0 5 50% 50%                                                           |Faxes BOTH NORTH                                              |\n|                                                                                                         | 10 10 0 10 50%  50%                                          |\n|                                                                                                         |                                                              |\n+---------------------------------------------------------------------------------------------------------+--------------------------------------------------------------+\n| Phones BOTH    WEST 10 10 10 5 50% 50%                                                                  | Emails BOTH WEST                                             |\n|                                                                                                         | 10 10 10 10 50% 50%                                          |\n+---------------------------------------------------------------------------------------------------------+--------------------------------------------------------------+\n";
    private TextField fldAgentId;
    private TextField fldCompany;
    private TextField fldAddressPostCode;
    private TextField fldAddressCountry;
    private AddressLinesPanel pnlAddressLines;
    private IModifiableSenderDetails senderDetails;
    private ModifiableAgent agent;
    private ModifiableContact contact;
    private ModifiableAddress address;

    public AgentPanel(ClientContext clientContext, IModifiableSenderDetails senderDetails) {
        this(clientContext, AgentPanel.obtainAgent(senderDetails));
        this.senderDetails = senderDetails;
    }

    private AgentPanel(ClientContext clientContext, ModifiableAgent agent) {
        this(clientContext, AgentPanel.obtainContact(agent), AgentPanel.obtainAddress(agent));
        this.agent = agent;
    }

    public AgentPanel(ClientContext clientContext, ModifiableContact contact, ModifiableAddress address) {
        super(clientContext, contact, LAYOUT);
        this.contact = contact;
        this.address = address;
        this.add((Component)new MinSizeLabel("Agent ID"), "AgentLabel");
        this.fldAgentId = new TextField(8);
        this.add((Component)this.fldAgentId, "AgentField");
        this.add((Component)new MinSizeLabel("Company"), "CompanyLabel");
        this.fldCompany = new TextField(10);
        this.add((Component)this.fldCompany, "CompanyField");
        this.pnlAddressLines = new AddressLinesPanel(clientContext, address);
        this.add((Component)this.pnlAddressLines, "AddressLines");
        this.add((Component)new MinSizeLabel("Post Code"), "PostCodeLabel");
        this.fldAddressPostCode = new TextField(6);
        this.add((Component)this.fldAddressPostCode, "PostCodeField");
        this.add((Component)new MinSizeLabel("Country"), "CountryLabel");
        this.fldAddressCountry = new TextField(3);
        this.add((Component)this.fldAddressCountry, "CountryField");
    }

    @Override
    public void populateUI() {
        this.fldAgentId.setText(this.agent.getAgentID());
        this.fldCompany.setText(this.agent.getCompany());
        this.fldAddressCountry.setText(this.address.getCountry());
        this.fldAddressPostCode.setText(this.address.getPostCode());
        this.pnlAddressLines.populateUI();
        super.populateUI();
    }

    @Override
    public void populateModel() {
        if (this.isModified()) {
            if (super.isModified()) {
                super.populateModel();
                this.agent.setContact(this.contact.isEmpty() ? null : this.contact);
            }
            if (this.isAddressModified()) {
                this.pnlAddressLines.populateModel();
                this.address.setPostCode(this.fldAddressPostCode.getText());
                this.address.setCountry(this.fldAddressCountry.getText());
                this.agent.setAddress(this.address.isEmpty() ? null : this.address);
            }
            this.agent.setAgentID(this.fldAgentId.getText());
            this.agent.setCompany(this.fldCompany.getText());
            this.senderDetails.setAgent(this.agent.isEmpty() ? null : this.agent);
        }
    }

    @Override
    public boolean isModified() {
        return !Util.equals((Object)this.fldAgentId.getText(), (Object)this.agent.getAgentID()) || !Util.equals((Object)this.fldCompany.getText(), (Object)this.agent.getCompany()) || this.isAddressModified() || super.isModified();
    }

    private boolean isAddressModified() {
        return !Util.equals((Object)this.fldAddressPostCode.getText(), (Object)this.address.getPostCode()) || !Util.equals((Object)this.fldAddressCountry.getText(), (Object)this.address.getCountry()) || this.pnlAddressLines.isModified();
    }

    private static ModifiableAgent obtainAgent(IModifiableSenderDetails senderDetails) {
        ModifiableAgent agent = senderDetails.getAgent();
        if (agent == null) {
            agent = new ModifiableAgent();
        }
        return agent;
    }

    private static ModifiableContact obtainContact(ModifiableAgent agent) {
        ModifiableContact contact = agent.getContact();
        if (contact == null) {
            contact = new ModifiableContact();
        }
        return contact;
    }

    private static ModifiableAddress obtainAddress(ModifiableAgent agent) {
        ModifiableAddress address = agent.getAddress();
        if (address == null) {
            address = new ModifiableAddress();
        }
        return address;
    }
}

