/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.settings.common;

import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class SelectionDrivenAction
extends AbstractAction
implements ListSelectionListener,
TableModelListener {
    private boolean hasSelection;
    private boolean canBeEnabled;
    private JTable table;

    public SelectionDrivenAction(JTable table) {
        this.table = table;
        table.getSelectionModel().addListSelectionListener(this);
        table.getModel().addTableModelListener(this);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean value) {
        this.canBeEnabled = value;
        super.setEnabled(this.hasSelection && this.canBeEnabled);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        this.checkAvailability();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.checkAvailability();
    }

    private void checkAvailability() {
        int leadIndex = this.table.getSelectionModel().getLeadSelectionIndex();
        this.hasSelection = leadIndex >= 0 && leadIndex < this.table.getRowCount();
        super.setEnabled(this.hasSelection && this.canBeEnabled);
    }
}

