/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.settings;

import com.selima.fbi.CancelException;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.waitdlg.BasicInterrupter;
import com.selima.fbi.ui.common.waitdlg.PluginProgressModel;
import com.selima.fbi.ui.common.waitdlg.SingletonWaitingDialog;
import com.selima.fbi.ui.edialog.FailureDialog;
import com.selima.fbi.user.PayrollServerSpec;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class TestUniverseConnectionWork
extends BasicInterrupter
implements BackendWork {
    private PayrollServerSpec payrollServer;
    private Component component;
    private MailServiceClientContext clientContext;

    public TestUniverseConnectionWork(MailServiceClientContext clientContext, Component component, PayrollServerSpec payrollServer) {
        this.clientContext = clientContext;
        this.payrollServer = payrollServer;
        this.component = component;
        SingletonWaitingDialog.showDialog(clientContext, new PluginProgressModel(true), this);
    }

    public String getName() {
        return "Testing Universe connection to '" + this.payrollServer.getHostOrLocalhost() + "' using account '" + this.payrollServer.getAccount() + "'";
    }

    public void invokeSwing(SwingOperationHandle handle) {
        SingletonWaitingDialog.hideDialog();
        if (handle.getFailure() == null) {
            JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this.component), "Payroll server connected successfully", this.clientContext.getTitle(), 2);
        } else if (!(handle.getFailure() instanceof CanceledException)) {
            FailureDialog.show(this.clientContext.getTitle(), "<html>Failed to connect <b>" + this.payrollServer.getHostOrLocalhost() + "</b>, account <b>" + this.payrollServer.getAccount() + "</b> as <b>" + this.payrollServer.getUser() + "</b>", handle.getFailure().getMessage(), handle.getFailure());
            LogAPI.logSevere((Throwable)handle.getFailure());
        }
    }

    public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
        handle.checkCancelRequest();
        try {
            this.clientContext.getMailService().testPayroll(this.payrollServer);
        }
        catch (CancelException e) {
            throw new CanceledException((Exception)e);
        }
        catch (PluginException e) {
            handle.setFailure((Throwable)e);
        }
    }
}

