/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.settings;

import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.ResourceDrivenLayout;
import com.selima.fbi.ui.common.TitledPanel;
import com.selima.fbi.ui.content.settings.SettingsGroup;
import com.selima.fbi.ui.content.settings.TestUniverseConnectionWork;
import com.selima.fbi.ui.content.settings.common.AbstractTestButton;
import com.selima.fbi.ui.content.settings.common.FirstModificationFilter;
import com.selima.fbi.ui.content.settings.common.FormattedField;
import com.selima.fbi.ui.content.settings.common.MinSizeLabel;
import com.selima.fbi.ui.content.settings.common.PasswordField;
import com.selima.fbi.ui.content.settings.common.TextField;
import com.selima.fbi.user.PayrollServerSpec;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.Util;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class PayrollServerPanel
extends TitledPanel
implements SettingsGroup {
    public static final String LAYOUT = "+------------+------------+-------------+--------------+------------+--------------+\n| HostLabel  | HostField  |AccountLabel |AccountField  |PortLabel   | PortField    |\n| NONE       | HORIZONTAL | NONE        | HORIZONTAL   | NONE       | HORIZONTAL   |\n| WEST       | CENTER     | WEST        | CENTER       |WEST        | CENTER       |\n| 0 0 3 3    | 0 0 3 3    | 0 5 3 3     | 0 0 3 3      |0 5 3 3     | 0 0 3 0      |\n|            | 33%        |             | 33%          |            | 33%          |\n|            |            |             |              |            |              |\n+------------+------------+-------------+--------------+------------+--------------+\n|UserLabel   |UserField   | PassLabel   | PassField    |               TestBtn     |\n| NONE       | HORIZONTAL | NONE        | HORIZONTAL   |               NONE        |\n| WEST       | CENTER     | WEST        | CENTER       |               EAST        |\n| 3 0 0 3    | 3 0 0 3    | 3 5 0 3     | 3 0 0 3      |               3 3 0 0     |\n|            | 33%        |             | 33%          |                           |\n|            |            |             |              |                           |\n|            |            |             |              |                           |\n+------------+------------+-------------+--------------+---------------------------+\n";
    private TextField fldServerHost;
    private TextField fldServerUser;
    private TextField fldServerAccount;
    private PasswordField fldServerPassword;
    private FormattedField fldPort;
    private ServerTestButton btnServerTest;
    private MailServiceClientContext clientContext;

    PayrollServerPanel(MailServiceClientContext clientContext) {
        super("Payroll", new ResourceDrivenLayout(LAYOUT));
        this.clientContext = clientContext;
        this.add((Component)new MinSizeLabel("Host"), "HostLabel");
        this.fldServerHost = new TextField(8);
        this.add((Component)this.fldServerHost, "HostField");
        this.add((Component)new MinSizeLabel("User"), "UserLabel");
        this.fldServerUser = new TextField(8);
        this.add((Component)this.fldServerUser, "UserField");
        this.add((Component)new MinSizeLabel("Port"), "PortLabel");
        this.fldPort = new FormattedField(3);
        this.add((Component)this.fldPort, "PortField");
        this.add((Component)new MinSizeLabel("Password"), "PassLabel");
        this.fldServerPassword = new PasswordField(5);
        this.add((Component)this.fldServerPassword, "PassField");
        this.add((Component)new MinSizeLabel("Account"), "AccountLabel");
        this.fldServerAccount = new TextField(6);
        this.add((Component)this.fldServerAccount, "AccountField");
        this.btnServerTest = new ServerTestButton();
        this.add((Component)this.btnServerTest, "TestBtn");
        new FirstModificationFilter(this.btnServerTest, this.fldServerAccount, this.fldServerHost, this.fldServerPassword, this.fldServerUser, this.fldPort);
    }

    @Override
    public boolean isModified() {
        PayrollServerSpec payroll = this.clientContext.getReferenceManager().getDefaultServer();
        return !Util.equals((Object)this.fldServerAccount.getText(), (Object)payroll.getAccount()) || !Util.equals((Object)this.fldServerHost.getText(), (Object)payroll.getHost()) || !Util.equals((Object)this.fldServerPassword.getPasswordText(), (Object)payroll.getPassword()) || !Util.equals((Object)this.fldServerUser.getText(), (Object)payroll.getUser()) || !Util.equals((Object)this.fldPort.getValue(), (Object)payroll.getPort());
    }

    @Override
    public void populateUI() {
        PayrollServerSpec payroll = this.clientContext.getReferenceManager().getDefaultServer();
        this.fldServerAccount.setText(payroll.getAccount());
        this.fldServerHost.setText(payroll.getHost());
        this.fldServerPassword.setText(payroll.getPassword());
        this.fldServerUser.setText(payroll.getUser());
        this.fldPort.setValue(payroll.getPort());
        this.btnServerTest.displayValid();
    }

    @Override
    public void populateModel() {
        PayrollServerSpec payroll = this.clientContext.getReferenceManager().getDefaultServer();
        payroll.setAccount(this.fldServerAccount.getText());
        payroll.setHost(this.fldServerHost.getText());
        payroll.setPassword(this.fldServerPassword.getPasswordText());
        payroll.setUser(this.fldServerUser.getText());
        payroll.setPort(this.fldPort.getInteger());
    }

    @Override
    protected Border titleBorder(String title) {
        return BorderFactory.createTitledBorder(title);
    }

    private void testServer() {
        PayrollServerSpec payrollServer = new PayrollServerSpec(this.fldServerHost.getText(), this.fldServerAccount.getText(), this.fldServerUser.getText(), this.fldServerPassword.getPasswordText(), this.fldPort.getInteger(), null);
        if (this.validateServer(payrollServer)) {
            this.btnServerTest.setEnabled(false);
            this.fldServerHost.setEnabled(false);
            this.fldServerAccount.setEnabled(false);
            this.fldServerPassword.setEnabled(false);
            this.fldServerUser.setEnabled(false);
            this.fldPort.setEnabled(false);
            TestUniverseConnectionWork work = new TestUniverseConnectionWork(this.clientContext, this.btnServerTest, payrollServer){

                @Override
                public void invokeSwing(SwingOperationHandle handle) {
                    PayrollServerPanel.this.btnServerTest.setEnabled(true);
                    PayrollServerPanel.this.fldServerHost.setEnabled(true);
                    PayrollServerPanel.this.fldServerAccount.setEnabled(true);
                    PayrollServerPanel.this.fldServerPassword.setEnabled(true);
                    PayrollServerPanel.this.fldServerUser.setEnabled(true);
                    PayrollServerPanel.this.fldPort.setEnabled(true);
                    super.invokeSwing(handle);
                    if (handle.getFailure() == null) {
                        PayrollServerPanel.this.btnServerTest.displayValid();
                    } else {
                        PayrollServerPanel.this.btnServerTest.displayUntested();
                    }
                    PayrollServerPanel.this.btnServerTest.requestFocusInWindow();
                }
            };
            work.setTaskHandle(this.clientContext.getSubmitter().submitWork((BackendWork)work));
        }
    }

    public boolean validateServer(PayrollServerSpec payrollServer) {
        String[] names = new String[]{"account", "user"};
        String[] values = new String[]{payrollServer.getAccount(), payrollServer.getUser()};
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this.btnServerTest), "Missing " + names[i], this.clientContext.getTitle(), -1, 2);
            return false;
        }
        return true;
    }

    class ServerTestButton
    extends AbstractTestButton {
        ServerTestButton() {
            super("Test");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PayrollServerPanel.this.testServer();
        }
    }
}

