/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.sendtable;

import com.selima.fbi.FormType;
import com.selima.fbi.core.IEASMessage;
import com.selima.fbi.core.IEOYMessage;
import com.selima.fbi.core.IEYUMessage;
import com.selima.fbi.core.IFPSMessage;
import com.selima.fbi.core.IMovMessage;
import com.selima.fbi.core.ININOVRMessage;
import com.selima.fbi.core.IP14PartMessage;
import com.selima.fbi.core.IP35PartMessage;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.IWnuMessage;
import com.selima.fbi.ui.common.table.RowTableModel;
import com.selima.fbi.ui.common.table.RowTableModelColumn;
import com.selima.fbi.ui.content.sendtable.EASEmployeeCountGetter;
import com.selima.fbi.ui.content.sendtable.EOYP14CountGetter;
import com.selima.fbi.ui.content.sendtable.EOYTotalNICGetter;
import com.selima.fbi.ui.content.sendtable.EOYTotalTaxGetter;
import com.selima.fbi.ui.content.sendtable.EYUEmployeeCountGetter;
import com.selima.fbi.ui.content.sendtable.EmpRefGetter;
import com.selima.fbi.ui.content.sendtable.FPSEmployeeCountGetter;
import com.selima.fbi.ui.content.sendtable.MovCountGetter;
import com.selima.fbi.ui.content.sendtable.NINOVREmployeeCountGetter;
import com.selima.fbi.ui.content.sendtable.NumberOfPartsGetter;
import com.selima.fbi.ui.content.sendtable.P14PartP14CountGetter;
import com.selima.fbi.ui.content.sendtable.P14PartTotalContributionGetter;
import com.selima.fbi.ui.content.sendtable.P35PartTotalNICGetter;
import com.selima.fbi.ui.content.sendtable.P35PartTotalTaxGetter;
import com.selima.fbi.ui.content.sendtable.SubjectGetter;
import com.selima.fbi.ui.content.sendtable.TotalTaxGetter;
import com.selima.fbi.ui.content.sendtable.UniqueIDGetter;
import com.selima.fbi.ui.content.sendtable.WnuRecordCountGetter;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class TypedPAYEMessageTableModel
extends RowTableModel<IPAYEMessage> {
    public static final RowTableModelColumn[] P14PART_COLUMNS = new RowTableModelColumn[]{new RowTableModelColumn<IPAYEMessage>("Employer", 120, 2, new EmpRefGetter()), new RowTableModelColumn<IP14PartMessage>("Unique ID", 100, 2, new UniqueIDGetter()), new RowTableModelColumn<IPAYEMessage>("Subject", 250, 2, new SubjectGetter()), new RowTableModelColumn<IP14PartMessage>("P14 Count", 90, 4, new P14PartP14CountGetter()), new RowTableModelColumn<IP14PartMessage>("Total Contributions", 130, 4, new P14PartTotalContributionGetter()), new RowTableModelColumn<IP14PartMessage>("Total Tax", 110, 4, new TotalTaxGetter())};
    public static final RowTableModelColumn[] P35PART_COLUMNS = new RowTableModelColumn[]{new RowTableModelColumn<IPAYEMessage>("Employer", 120, 2, new EmpRefGetter()), new RowTableModelColumn<IPAYEMessage>("Subject", 320, 2, new SubjectGetter()), new RowTableModelColumn<IP35PartMessage>("Number Of Parts", 120, 4, new NumberOfPartsGetter()), new RowTableModelColumn<IP35PartMessage>("Total NIC", 90, 4, new P35PartTotalNICGetter()), new RowTableModelColumn<IP35PartMessage>("Total Tax", 90, 4, new P35PartTotalTaxGetter())};
    public static final RowTableModelColumn[] EOY_COLUMNS = new RowTableModelColumn[]{new RowTableModelColumn<IPAYEMessage>("Employer", 120, 2, new EmpRefGetter()), new RowTableModelColumn<IPAYEMessage>("Title", 320, 2, new SubjectGetter()), new RowTableModelColumn<IEOYMessage>("P14 Count", 80, 4, new EOYP14CountGetter()), new RowTableModelColumn<IEOYMessage>("Total NIC", 90, 4, new EOYTotalNICGetter()), new RowTableModelColumn<IEOYMessage>("Total Tax", 90, 4, new EOYTotalTaxGetter())};
    public static final RowTableModelColumn[] MOV_COLUMNS = new RowTableModelColumn[]{new RowTableModelColumn<IPAYEMessage>("Employer", 120, 2, new EmpRefGetter()), new RowTableModelColumn<IPAYEMessage>("Title", 300, 2, new SubjectGetter()), new RowTableModelColumn<IMovMessage>("Count", 70, 4, new MovCountGetter())};
    public static final RowTableModelColumn[] WNU_COLUMNS = new RowTableModelColumn[]{new RowTableModelColumn<IPAYEMessage>("Employer", 120, 2, new EmpRefGetter()), new RowTableModelColumn<IPAYEMessage>("Title", 300, 2, new SubjectGetter()), new RowTableModelColumn<IWnuMessage>("Count", 70, 4, new WnuRecordCountGetter())};
    public static final RowTableModelColumn[] EAS_COLUMNS = new RowTableModelColumn[]{new RowTableModelColumn<IPAYEMessage>("Employer", 120, 2, new EmpRefGetter()), new RowTableModelColumn<IPAYEMessage>("Title", 300, 2, new SubjectGetter()), new RowTableModelColumn<IEASMessage>("Employee Count", 70, 4, new EASEmployeeCountGetter())};
    public static final RowTableModelColumn[] EPS_COLUMNS = new RowTableModelColumn[]{new RowTableModelColumn<IPAYEMessage>("Employer", 120, 2, new EmpRefGetter()), new RowTableModelColumn<IPAYEMessage>("Title", 300, 2, new SubjectGetter())};
    public static final RowTableModelColumn[] FPS_COLUMNS = new RowTableModelColumn[]{new RowTableModelColumn<IPAYEMessage>("Employer", 120, 2, new EmpRefGetter()), new RowTableModelColumn<IPAYEMessage>("Title", 300, 2, new SubjectGetter()), new RowTableModelColumn<IFPSMessage>("Employee Count", 70, 4, new FPSEmployeeCountGetter())};
    public static final RowTableModelColumn[] EYU_COLUMNS = new RowTableModelColumn[]{new RowTableModelColumn<IPAYEMessage>("Employer", 120, 2, new EmpRefGetter()), new RowTableModelColumn<IPAYEMessage>("Title", 300, 2, new SubjectGetter()), new RowTableModelColumn<IEYUMessage>("Employee Count", 70, 4, new EYUEmployeeCountGetter())};
    public static final RowTableModelColumn[] NINOVR_COLUMNS = new RowTableModelColumn[]{new RowTableModelColumn<IPAYEMessage>("Employer", 120, 2, new EmpRefGetter()), new RowTableModelColumn<IPAYEMessage>("Title", 300, 2, new SubjectGetter()), new RowTableModelColumn<ININOVRMessage>("Employee Count", 70, 4, new NINOVREmployeeCountGetter())};
    FormType currentType;

    public TypedPAYEMessageTableModel(FormType type) {
        super(TypedPAYEMessageTableModel.columnsForType(type));
        this.currentType = type;
    }

    static RowTableModelColumn[] columnsForType(FormType type) {
        switch (type) {
            case P14Part: {
                return P14PART_COLUMNS;
            }
            case P35Part: {
                return P35PART_COLUMNS;
            }
            case EOY: {
                return EOY_COLUMNS;
            }
            case P45Part1: 
            case P45Part3: 
            case P46: 
            case PENNOT: {
                return MOV_COLUMNS;
            }
            case WNU: {
                return WNU_COLUMNS;
            }
            case EAS: {
                return EAS_COLUMNS;
            }
            case FPS: {
                return FPS_COLUMNS;
            }
            case EPS: {
                return EPS_COLUMNS;
            }
            case NINOVR: {
                return NINOVR_COLUMNS;
            }
            case EYU: {
                return EYU_COLUMNS;
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)type));
    }

    public FormType getType() {
        return this.currentType;
    }

    public void setType(FormType type) {
        if (this.currentType != type) {
            this.currentType = type;
            this.setRows(new PAYEMessageRow[0]);
            this.setColumns(TypedPAYEMessageTableModel.columnsForType(type));
        }
    }

    public void setMessages(List<IPAYEMessage> messages) {
        PAYEMessageRow[] rows = new PAYEMessageRow[messages.size()];
        ListIterator<IPAYEMessage> it = messages.listIterator();
        while (it.hasNext()) {
            rows[it.nextIndex()] = new PAYEMessageRow(it.nextIndex(), it.next());
        }
        this.setRows(rows);
        this.fireTableDataChanged();
    }

    @Override
    public Map<String, RowTableModelColumn<?>> getMapOfColumns() {
        HashMap result = new HashMap();
        for (RowTableModelColumn column : this.getColumns()) {
            result.put(column.getTitle(), column);
        }
        return result;
    }

    public class PAYEMessageRow
    extends RowTableModel.TableRow<IPAYEMessage> {
        IPAYEMessage message;

        public PAYEMessageRow(int rowIndex, IPAYEMessage message) {
            super(rowIndex);
            this.message = message;
        }

        @Override
        public IPAYEMessage getRowData() {
            return this.message;
        }
    }
}

