/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.resutable;

import com.selima.fbi.ui.content.resutable.Row;
import java.util.LinkedList;

public abstract class RowVisitor {
    private Row root;

    public RowVisitor(Row root) {
        this.root = root;
    }

    public void visit() {
        this.visit(this.root, new LinkedList<Row>());
    }

    protected void visit(Row row, LinkedList<Row> path) {
        if (path.contains(row)) {
            this.cycleDetected(row, path);
        }
        this.visitBegin(row, path);
        try {
            if (row.isLeaf()) {
                this.visitLeaf(row, path);
            } else {
                this.visitChildren(row, path);
            }
        }
        finally {
            this.visitEnd(row, path);
        }
    }

    protected void visitBegin(Row row, LinkedList<Row> path) {
    }

    protected void visitEnd(Row row, LinkedList<Row> path) {
    }

    protected void visitLeaf(Row row, LinkedList<? extends Row> path) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitChildren(Row row, LinkedList<Row> path) {
        int childCount = row.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Row child = row.getChild(i);
            path.addLast(row);
            try {
                this.visit(child, path);
                continue;
            }
            finally {
                path.removeLast();
            }
        }
    }

    protected void cycleDetected(Row row, LinkedList<? extends Row> path) {
        throw new IllegalStateException("Cycle Detected: " + path + ", " + row);
    }
}

