/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.resutable;

import com.selima.fbi.plugin.PluginChainableException;
import com.selima.fbi.ui.content.resutable.AbstractResultsTable;
import com.selima.fbi.ui.content.resutable.AbstractResultsTreeTableModel;
import com.selima.fbi.ui.content.resutable.Row;
import java.util.ListIterator;

public class PluginErrorTable
extends AbstractResultsTable {
    public PluginErrorTable(PluginChainableException error) {
        super(new PluginErrorTreeTableModel(error));
        this.getColumnModel().getColumn(0).setPreferredWidth(75);
        this.getColumnModel().getColumn(0).setMaxWidth(75);
        this.expandWholeTree();
    }

    static class PluginErrorTreeTableModel
    extends AbstractResultsTreeTableModel<PluginErrorRootRow> {
        public PluginErrorTreeTableModel(PluginChainableException error) {
            super(new PluginErrorRootRow(error));
        }
    }

    static class ErrorLineRow
    extends Row {
        final String line;
        final int index;

        ErrorLineRow(String line, int index) {
            this.index = index;
            this.line = line;
        }

        @Override
        public Object getValueAt(int col) {
            return col == 0 ? String.valueOf(this.index) : this.line;
        }

        @Override
        public String getIcon() {
            return "/img/16x16/actions/quiz.png";
        }
    }

    static class ServerRow
    extends Row {
        final String server;

        ServerRow(String server, PluginChainableException error) {
            this.server = server;
            ListIterator<String> it = error.getErrors(server).listIterator();
            while (it.hasNext()) {
                this.addChild(new ErrorLineRow(it.next(), it.nextIndex()));
            }
        }

        @Override
        public Object getValueAt(int col) {
            return col == 0 ? "Payroll" : this.server;
        }

        @Override
        public boolean needHorizontalRule() {
            return true;
        }
    }

    static class PluginErrorRootRow
    extends Row {
        PluginErrorRootRow(PluginChainableException error) {
            for (String server : error.getServers()) {
                this.addChild(new ServerRow(server, error));
            }
        }

        @Override
        public Object getValueAt(int col) {
            return "";
        }
    }
}

