/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.resutable;

import com.selima.fbi.ui.common.PopupOwner;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.common.ToolBar;
import com.selima.fbi.ui.common.treetable.GTreeTable;
import com.selima.fbi.ui.common.treetable.TreeTableModel;
import com.selima.fbi.ui.content.resutable.AbstractResultsTreeTableModel;
import com.selima.fbi.ui.content.resutable.ResultsTableTransferHandler;
import com.selima.fbi.ui.content.resutable.Row;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.View;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class AbstractResultsTable
extends GTreeTable
implements PopupOwner {
    private ToolBar toolBar;
    private Point popupPoint;
    private Rectangle toolTipBounds;

    AbstractResultsTable(AbstractResultsTreeTableModel<?> model) {
        super(model);
        this.setRowHeight(19);
        this.setDefaultRenderer(TreeTableModel.class, new SelectionPaintingCellRenderer(this.getDefaultRenderer(TreeTableModel.class)));
        this.getTree().setCellRenderer(new CustomTreeRenderer());
        this.setTransferHandler(new ResultsTableTransferHandler(this));
        this.setCellSelectionEnabled(true);
        SwingHelper.installPopupTrigger(this, this);
    }

    @Override
    public void popupTriggered(JComponent source, Point mousePoint) {
        if (this.toolBar != null) {
            this.popupPoint = mousePoint;
            if (this.popupPoint == null) {
                int row = this.getSelectionModel().getLeadSelectionIndex();
                int col = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                if (row >= 0 && row < this.getRowCount() && col >= 0 && col < this.getColumnCount()) {
                    this.popupPoint = this.getCellRect(row, col, false).getLocation();
                    this.popupPoint.translate(2, this.getRowHeight(row) - 2);
                } else {
                    this.popupPoint = new Point(2, this.getRowHeight() - 2);
                }
            }
            class CustomPopupMenu
            extends JPopupMenu
            implements PopupMenuListener,
            Runnable {
                CustomPopupMenu() {
                    for (Action action : AbstractResultsTable.this.toolBar.getActions()) {
                        this.add(action);
                    }
                    this.addPopupMenuListener(this);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    SwingUtilities.invokeLater(this);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    SwingUtilities.invokeLater(this);
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void run() {
                    AbstractResultsTable.this.popupPoint = null;
                }
            }
            new CustomPopupMenu().show(source, this.popupPoint.x, this.popupPoint.y);
        }
    }

    public Point getPopupPoint() {
        return this.popupPoint;
    }

    public void setToolBar(ToolBar toolbar) {
        this.toolBar = toolbar;
    }

    @Override
    protected void expandTree(JTree tree, TreePath path) {
        if (path.getPathCount() < 3) {
            super.expandTree(tree, path);
        }
    }

    public Row rowAt(int rowIndex) {
        return (Row)this.getModelAdapter().nodeForRow(rowIndex);
    }

    public LinkedList<Row> pathAt(int rowIndex) {
        TreePath path = this.getModelAdapter().pathForRow(rowIndex);
        LinkedList<Row> result = new LinkedList<Row>();
        for (Object o : path.getPath()) {
            result.add((Row)o);
        }
        return result;
    }

    @Override
    public AbstractResultsTreeTableModel<?> getTreeTableModel() {
        return (AbstractResultsTreeTableModel)super.getTreeTableModel();
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        int col = this.columnAtPoint(event.getPoint());
        int row = this.rowAtPoint(event.getPoint());
        if (col != -1 && row != -1) {
            this.toolTipBounds = this.getCellRect(row, col, true);
            return this.toolTipBounds.getLocation();
        }
        this.toolTipBounds = null;
        return super.getToolTipLocation(event);
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip result = super.createToolTip();
        result.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                JComponent component = (JComponent)event.getSource();
                View view = (View)component.getClientProperty("html");
                if (view != null && AbstractResultsTable.this.toolTipBounds != null) {
                    Insets insets = component.getInsets();
                    view.setSize(((AbstractResultsTable)AbstractResultsTable.this).toolTipBounds.width - insets.left - insets.right, 32767.0f);
                    int height = (int)view.getPreferredSpan(1);
                    component.setPreferredSize(new Dimension(((AbstractResultsTable)AbstractResultsTable.this).toolTipBounds.width, height + insets.top + insets.bottom + 3));
                }
            }
        });
        return result;
    }

    @Override
    protected TableCellRenderer getTableRenderer(TableCellRenderer original) {
        return new CustomCellRenderer(original);
    }

    public class SelectionPaintingCellRenderer
    extends DefaultTableCellRenderer {
        TableCellRenderer renderer;

        SelectionPaintingCellRenderer(TableCellRenderer renderer) {
            this.renderer = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent rendererComponent = (JComponent)this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            rendererComponent.setForeground(table.getForeground());
            rendererComponent.setOpaque(isSelected);
            return rendererComponent;
        }
    }

    private class CustomCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer wrapped;

        CustomCellRenderer(TableCellRenderer renderer) {
            this.wrapped = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent result = (JComponent)this.wrapped.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                value = value.toString().replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                result.setToolTipText("<html>" + value + "</html>");
            }
            TreePath path = AbstractResultsTable.this.getTree().getPathForRow(row);
            Object rowObject = path.getLastPathComponent();
            if (!(((AbstractResultsTreeTableModel)AbstractResultsTable.this.getTreeTableModel()).isLeaf(rowObject) || AbstractResultsTable.this.getColumnModel().getColumn(column).getModelIndex() != 0 && path.getPathCount() >= 3)) {
                result.setFont(result.getFont().deriveFont(1));
            }
            if (((AbstractResultsTreeTableModel)AbstractResultsTable.this.getTreeTableModel()).needHorizontalRule(rowObject) && row > 0) {
                MatteBorder extraBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK);
                Border originalBorder = result.getBorder();
                if (originalBorder == null) {
                    result.setBorder(extraBorder);
                } else {
                    result.setBorder(BorderFactory.createCompoundBorder(extraBorder, originalBorder));
                }
            }
            return result;
        }
    }

    private class CustomTreeRenderer
    extends DefaultTreeCellRenderer {
        DecimalFormat decimalFormat = new DecimalFormat("00000");

        CustomTreeRenderer() {
            this.setBackgroundSelectionColor(null);
            this.setTextSelectionColor(this.getTextNonSelectionColor());
        }

        @Override
        public Color getBackground() {
            return null;
        }

        @Override
        public Color getBackgroundNonSelectionColor() {
            return null;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object cellValue = ((AbstractResultsTreeTableModel)AbstractResultsTable.this.getTreeTableModel()).getValueAt(value, 0);
            if (cellValue instanceof Number) {
                cellValue = this.decimalFormat.format(cellValue);
            }
            super.getTreeCellRendererComponent(tree, cellValue, selected, expanded, leaf, row, hasFocus);
            String iconPath = ((AbstractResultsTreeTableModel)AbstractResultsTable.this.getTreeTableModel()).getIcon(value);
            if (iconPath != null) {
                this.setIcon(SwingHelper.imageIcon(iconPath));
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }
}

