/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.result;

import com.selima.fbi.CancelException;
import com.selima.fbi.ProxySettingsException;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.response.IResponse;
import com.selima.fbi.submission.SubmitException;
import com.selima.fbi.ui.ClientContent;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.waitdlg.BasicInterrupter;
import com.selima.fbi.ui.common.waitdlg.MultiSendingModel;
import com.selima.fbi.ui.common.waitdlg.SingletonWaitingDialog;
import com.selima.fbi.ui.content.SubmitContent;
import com.selima.fbi.ui.content.detail.SubmitDetailContent;
import com.selima.fbi.ui.content.result.AbstractSubmissionResultsContent;
import com.selima.fbi.ui.content.resutable.ValidationResult;
import com.selima.fbi.ui.content.resutable.ValidationResultsTreeTable;
import com.selima.fbi.ui.edialog.FailureDialog;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class ValidationContent
extends AbstractSubmissionResultsContent<ValidationResultsTreeTable> {
    private ValidationResultsTreeTable table;
    private List<IPAYEMessage> messages;
    private boolean executed;
    private int actual;

    public ValidationContent(MailServiceClientContext cctx, SubmitContent parent, List<IPAYEMessage> messages) {
        this(cctx, parent, messages, new ValidationResultsTreeTable());
    }

    public ValidationContent(MailServiceClientContext cctx, SubmitDetailContent parent, List<IPAYEMessage> messages) {
        this(cctx, parent, messages, new ValidationResultsTreeTable());
    }

    private ValidationContent(MailServiceClientContext cctx, ClientContent parent, List<IPAYEMessage> messages, ValidationResultsTreeTable table) {
        super(cctx, parent, table);
        this.messages = messages;
        this.table = table;
    }

    @Override
    public String getDescription() {
        return "Validating messages";
    }

    @Override
    public String getContentName() {
        return "Validation results";
    }

    @Override
    public String getHelpTopic() {
        return "content.context-help.validate-result";
    }

    @Override
    public BackendWork getOpeningWork() {
        if (this.executed) {
            return super.getOpeningWork();
        }
        this.executed = true;
        return new ValidatingWork();
    }

    @Override
    protected void displayDetailContent(IPAYEMessage message) {
        if (message != null) {
            if (this.parent instanceof SubmitDetailContent) {
                this.getClientContext().displayContent(this.parent);
            } else {
                this.getClientContext().displayContent(new SubmitDetailContent((SubmitContent)this.parent, this.getClientContext(), message));
            }
        }
    }

    class ValidatingWork
    extends BasicInterrupter
    implements BackendWork {
        MultiSendingModel waitingModel;

        ValidatingWork() {
            this.waitingModel = new MultiSendingModel(ValidationContent.this.messages.size()){
                {
                    super(numOfMessages);
                    this.validation = true;
                }

                @Override
                public String actualTitle() {
                    return ((IPAYEMessage)ValidationContent.this.messages.get(ValidationContent.this.actual)).getSubject();
                }

                @Override
                public int actualIndex() {
                    return ValidationContent.this.actual;
                }
            };
            SingletonWaitingDialog.showDialog(ValidationContent.this.getClientContext(), this.waitingModel, this);
        }

        public String getName() {
            return "Validating messages";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeBackend(BackendOperationHandle handle) {
            try {
                ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(ValidationContent.this.messages.size());
                ValidationContent.this.actual = 0;
                while (ValidationContent.this.actual < ValidationContent.this.messages.size()) {
                    IPAYEMessage message = (IPAYEMessage)ValidationContent.this.messages.get(ValidationContent.this.actual);
                    try {
                        handle.checkCancelRequest();
                        IResponse response = message.validate();
                        results.add(new ValidationResult(message, response));
                    }
                    catch (CanceledException e) {
                        break;
                    }
                    catch (CancelException e) {
                        break;
                    }
                    catch (RuntimeException e) {
                        LogAPI.logWarning((Throwable)e);
                        break;
                    }
                    catch (ProxySettingsException e) {
                        handle.setFailure((Throwable)e);
                        SingletonWaitingDialog.hideDialog();
                        return;
                    }
                    catch (IOException e) {
                        LogAPI.logSevere((Throwable)e);
                        results.add(new ValidationResult(message, e));
                    }
                    catch (SubmitException e) {
                        results.add(new ValidationResult(message, e));
                    }
                    {
                        ValidationContent.this.actual++;
                    }
                }
                handle.setResult(results);
            }
            finally {
                SingletonWaitingDialog.hideDialog();
            }
        }

        public void invokeSwing(SwingOperationHandle handle) {
            if (handle.getResult() != null) {
                List result = (List)handle.getResult();
                if (result.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ValidationContent.this.getClientContext().displayContent(ValidationContent.this.parent);
                        }
                    });
                } else {
                    ValidationContent.this.table.setValidationResults(result);
                }
            } else {
                FailureDialog.show(ValidationContent.this.getClientContext().getTitle(), "<b>Failed to validate message" + (ValidationContent.this.messages.size() > 1 ? "s" : "") + "</b>", handle.getFailure());
                LogAPI.logSevere((Throwable)handle.getFailure());
            }
        }
    }
}

