/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.mboxtable;

import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.content.mboxtable.DPSMessageTable;
import com.selima.fbi.ui.content.mboxtable.TransferredMessageTableModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class TransferredMessageTable
extends DPSMessageTable {
    public TransferredMessageTable(ClientContext cctx) {
        super(cctx, new TransferredMessageTableModel());
        this.setDefaultRenderer(Object.class, new TransferredRenderer(this.getDefaultRenderer(Object.class)));
    }

    private static class TransferredRenderer
    implements TableCellRenderer {
        Icon MAIL_TRANSFERED_ICON = SwingHelper.imageIcon("/img/16x16/actions/mail_transfer.png");
        private TableCellRenderer wrapped;

        private TransferredRenderer(TableCellRenderer renderer) {
            this.wrapped = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)this.wrapped.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            IDPSMessage message = (IDPSMessage)((DPSMessageTable)table).getModel().getRow(row).getRowData();
            if (column == 0) {
                label.setIcon(this.MAIL_TRANSFERED_ICON);
            }
            label.setForeground(new Color(128, 64, 0));
            if (message.isDeletable()) {
                label.setForeground(Color.BLACK);
            } else {
                label.setForeground(Color.GRAY);
            }
            return label;
        }
    }
}

